/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Callable;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.executor.ClassLoaderDelegator;
import org.redisson.executor.CronExpression;
import org.redisson.executor.RedissonClassLoader;
import org.redisson.executor.RemoteExecutorService;
import org.redisson.executor.RemoteExecutorServiceAsync;
import org.redisson.executor.ScheduledTasksService;
import org.redisson.misc.Injector;
import org.redisson.remote.RemoteParams;

public class TasksRunnerService
implements RemoteExecutorService,
RemoteParams {
    private final ClassLoaderDelegator classLoader = new ClassLoaderDelegator();
    private final ThreadLocal<String> requestId = new ThreadLocal();
    private final Codec codec;
    private final String name;
    private final CommandExecutor commandExecutor;
    private final RedissonClient redisson;
    private String tasksCounterName;
    private String statusName;
    private String terminationTopicName;
    private String tasksName;
    private String schedulerQueueName;
    private String schedulerChannelName;

    public TasksRunnerService(CommandExecutor commandExecutor, RedissonClient redisson, Codec codec, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.redisson = redisson;
        try {
            this.codec = (Codec)codec.getClass().getConstructor(ClassLoader.class).newInstance(this.classLoader);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialize codec with ClassLoader parameter", e);
        }
    }

    public void setSchedulerQueueName(String schedulerQueueName) {
        this.schedulerQueueName = schedulerQueueName;
    }

    public void setSchedulerChannelName(String schedulerChannelName) {
        this.schedulerChannelName = schedulerChannelName;
    }

    public void setTasksName(String tasksName) {
        this.tasksName = tasksName;
    }

    public void setTasksCounterName(String tasksCounterName) {
        this.tasksCounterName = tasksCounterName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public void setTerminationTopicName(String terminationTopicName) {
        this.terminationTopicName = terminationTopicName;
    }

    @Override
    public void scheduleAtFixedRate(String className, byte[] classBody, byte[] state, long startTime, long period) {
        long newStartTime = System.currentTimeMillis() + period;
        RFuture<Void> future = this.asyncScheduledServiceAtFixed().scheduleAtFixedRate(className, classBody, state, newStartTime, period);
        try {
            this.executeRunnable(className, classBody, state, null);
        }
        catch (RuntimeException e) {
            future.cancel(true);
            throw e;
        }
    }

    @Override
    public void schedule(String className, byte[] classBody, byte[] state, long startTime, String cronExpression) {
        Date nextStartDate = new CronExpression(cronExpression).getNextValidTimeAfter(new Date());
        RFuture<Void> future = this.asyncScheduledServiceAtFixed().schedule(className, classBody, state, nextStartDate.getTime(), cronExpression);
        try {
            this.executeRunnable(className, classBody, state, null);
        }
        catch (RuntimeException e) {
            future.cancel(true);
            throw e;
        }
    }

    private RemoteExecutorServiceAsync asyncScheduledServiceAtFixed() {
        ScheduledTasksService scheduledRemoteService = new ScheduledTasksService(this.codec, this.redisson, this.name, this.commandExecutor);
        scheduledRemoteService.setTerminationTopicName(this.terminationTopicName);
        scheduledRemoteService.setTasksCounterName(this.tasksCounterName);
        scheduledRemoteService.setStatusName(this.statusName);
        scheduledRemoteService.setSchedulerQueueName(this.schedulerQueueName);
        scheduledRemoteService.setSchedulerChannelName(this.schedulerChannelName);
        scheduledRemoteService.setTasksName(this.tasksName);
        scheduledRemoteService.setRequestId(this.requestId.get());
        RemoteExecutorServiceAsync asyncScheduledServiceAtFixed = scheduledRemoteService.get(RemoteExecutorServiceAsync.class, RemoteInvocationOptions.defaults().noAck().noResult());
        return asyncScheduledServiceAtFixed;
    }

    @Override
    public void scheduleWithFixedDelay(String className, byte[] classBody, byte[] state, long startTime, long delay) {
        this.executeRunnable(className, classBody, state, null);
        long newStartTime = System.currentTimeMillis() + delay;
        this.asyncScheduledServiceAtFixed().scheduleWithFixedDelay(className, classBody, state, newStartTime, delay);
    }

    @Override
    public Object scheduleCallable(String className, byte[] classBody, byte[] state, long startTime) {
        return this.executeCallable(className, classBody, state, this.requestId.get());
    }

    @Override
    public void scheduleRunnable(String className, byte[] classBody, byte[] state, long startTime) {
        this.executeRunnable(className, classBody, state, this.requestId.get());
    }

    @Override
    public Object executeCallable(String className, byte[] classBody, byte[] state) {
        return this.executeCallable(className, classBody, state, this.requestId.get());
    }

    private Object executeCallable(String className, byte[] classBody, byte[] state, String scheduledRequestId) {
        ByteBuf buf = null;
        try {
            buf = Unpooled.wrappedBuffer(state);
            RedissonClassLoader cl = new RedissonClassLoader(this.getClass().getClassLoader());
            cl.loadClass(className, classBody);
            this.classLoader.setCurrentClassLoader(cl);
            Callable callable = (Callable)this.decode(buf);
            Object v = callable.call();
            return v;
        }
        catch (RedissonShutdownException e) {
            Object var7_11 = null;
            return var7_11;
        }
        catch (RedisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            buf.release();
            this.finish(scheduledRequestId);
        }
    }

    private <T> T decode(ByteBuf buf) throws IOException {
        Object task = this.codec.getValueDecoder().decode(buf, null);
        Injector.inject(task, this.redisson);
        return (T)task;
    }

    @Override
    public void executeRunnable(String className, byte[] classBody, byte[] state) {
        this.executeRunnable(className, classBody, state, this.requestId.get());
    }

    private void executeRunnable(String className, byte[] classBody, byte[] state, String scheduledRequestId) {
        ByteBuf buf = null;
        try {
            buf = Unpooled.wrappedBuffer(state);
            RedissonClassLoader cl = new RedissonClassLoader(this.getClass().getClassLoader());
            cl.loadClass(className, classBody);
            this.classLoader.setCurrentClassLoader(cl);
            Runnable runnable = (Runnable)this.decode(buf);
            runnable.run();
        }
        catch (RedissonShutdownException e) {
        }
        catch (RedisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            buf.release();
            this.finish(scheduledRequestId);
        }
    }

    private void finish(String scheduledRequestId) {
        this.classLoader.clearCurrentClassLoader();
        if (scheduledRequestId != null) {
            this.commandExecutor.evalWriteAsync(this.name, this.codec, RedisCommands.EVAL_VOID, "redis.call('hdel', KEYS[4], ARGV[3]); if redis.call('decr', KEYS[1]) == 0 then redis.call('del', KEYS[1]);if redis.call('get', KEYS[2]) == ARGV[1] then redis.call('set', KEYS[2], ARGV[2]);redis.call('publish', KEYS[3], ARGV[2]);end;end;", Arrays.asList(this.tasksCounterName, this.statusName, this.terminationTopicName, this.tasksName), 1, 2, scheduledRequestId);
            return;
        }
        this.commandExecutor.evalWriteAsync(this.name, this.codec, RedisCommands.EVAL_VOID, "if redis.call('decr', KEYS[1]) == 0 then redis.call('del', KEYS[1]);if redis.call('get', KEYS[2]) == ARGV[1] then redis.call('set', KEYS[2], ARGV[2]);redis.call('publish', KEYS[3], ARGV[2]);end;end;", Arrays.asList(this.tasksCounterName, this.statusName, this.terminationTopicName), 1, 2);
    }

    @Override
    public void setRequestId(String id) {
        this.requestId.set(id);
    }
}

