/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.BitSet;
import org.reactivestreams.Publisher;
import org.redisson.RedissonBitSet;
import org.redisson.api.RBitSetReactive;
import org.redisson.client.codec.BitSetCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonExpirableReactive;
import reactor.rx.Streams;

public class RedissonBitSetReactive
extends RedissonExpirableReactive
implements RBitSetReactive {
    private final RedissonBitSet instance;

    public RedissonBitSetReactive(CommandReactiveExecutor connectionManager, String name) {
        super(connectionManager, name);
        this.instance = new RedissonBitSet(connectionManager, name);
    }

    @Override
    public Publisher<Boolean> get(long bitIndex) {
        return this.reactive(this.instance.getAsync(bitIndex));
    }

    @Override
    public Publisher<Void> set(long bitIndex, boolean value) {
        return this.reactive(this.instance.setAsync(bitIndex, value));
    }

    @Override
    public Publisher<byte[]> toByteArray() {
        return this.reactive(this.instance.toByteArrayAsync());
    }

    @Override
    public Publisher<BitSet> asBitSet() {
        return this.commandExecutor.readReactive(this.getName(), BitSetCodec.INSTANCE, RedisCommands.GET, this.getName());
    }

    @Override
    public Publisher<Long> length() {
        return this.reactive(this.instance.lengthAsync());
    }

    @Override
    public Publisher<Void> set(long fromIndex, long toIndex, boolean value) {
        return this.reactive(this.instance.setAsync(fromIndex, toIndex, value));
    }

    @Override
    public Publisher<Void> clear(long fromIndex, long toIndex) {
        return this.reactive(this.instance.clearAsync(fromIndex, toIndex));
    }

    @Override
    public Publisher<Void> set(BitSet bs) {
        return this.reactive(this.instance.setAsync(bs));
    }

    @Override
    public Publisher<Void> not() {
        return this.reactive(this.instance.notAsync());
    }

    @Override
    public Publisher<Void> set(long fromIndex, long toIndex) {
        return this.reactive(this.instance.setAsync(fromIndex, toIndex));
    }

    @Override
    public Publisher<Integer> size() {
        return this.reactive(this.instance.sizeAsync());
    }

    @Override
    public Publisher<Void> set(long bitIndex) {
        return this.reactive(this.instance.setAsync(bitIndex));
    }

    @Override
    public Publisher<Long> cardinality() {
        return this.reactive(this.instance.cardinalityAsync());
    }

    @Override
    public Publisher<Void> clear(long bitIndex) {
        return this.reactive(this.instance.clearAsync(bitIndex));
    }

    @Override
    public Publisher<Void> clear() {
        return this.reactive(this.instance.clearAsync());
    }

    @Override
    public Publisher<Void> or(String ... bitSetNames) {
        return this.reactive(this.instance.orAsync(bitSetNames));
    }

    @Override
    public Publisher<Void> and(String ... bitSetNames) {
        return this.reactive(this.instance.andAsync(bitSetNames));
    }

    @Override
    public Publisher<Void> xor(String ... bitSetNames) {
        return this.reactive(this.instance.xorAsync(bitSetNames));
    }

    public String toString() {
        return Streams.create(this.asBitSet()).next().poll().toString();
    }
}

