/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.core;

import io.netty.util.internal.PlatformDependent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.redisson.RedissonBitSet;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonClient;
import org.redisson.RedissonDeque;
import org.redisson.RedissonList;
import org.redisson.RedissonMap;
import org.redisson.RedissonQueue;
import org.redisson.RedissonReference;
import org.redisson.RedissonSet;
import org.redisson.RedissonSortedSet;
import org.redisson.api.RBitSet;
import org.redisson.api.RLiveObject;
import org.redisson.api.RMap;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.liveobject.annotation.REntity;
import org.redisson.liveobject.annotation.RId;
import org.redisson.liveobject.annotation.RObjectField;
import org.redisson.liveobject.misc.Introspectior;
import org.redisson.liveobject.misc.RedissonObjectFactory;
import org.redisson.liveobject.provider.CodecProvider;
import org.redisson.liveobject.provider.ResolverProvider;
import org.redisson.liveobject.resolver.NamingScheme;

public class AccessorInterceptor {
    private final RedissonClient redisson;
    private final CodecProvider codecProvider;
    private final ResolverProvider resolverProvider;
    private final ConcurrentMap<String, NamingScheme> namingSchemeCache = PlatformDependent.newConcurrentHashMap();
    private static final LinkedHashMap<Class, Class<? extends RObject>> supportedClassMapping = new LinkedHashMap();

    public AccessorInterceptor(RedissonClient redisson, CodecProvider codecProvider, ResolverProvider resolverProvider) {
        this.redisson = redisson;
        this.codecProvider = codecProvider;
        this.resolverProvider = resolverProvider;
    }

    @RuntimeType
    public Object intercept(@Origin Method method, @SuperCall Callable<?> superMethod, @AllArguments Object[] args, @This Object me, @FieldValue(value="liveObjectLiveMap") RMap liveMap) throws Exception {
        if (this.isGetter(method, AccessorInterceptor.getREntityIdFieldName(me))) {
            return ((RLiveObject)me).getLiveObjectId();
        }
        if (this.isSetter(method, AccessorInterceptor.getREntityIdFieldName(me))) {
            ((RLiveObject)me).setLiveObjectId(args[0]);
            return null;
        }
        String fieldName = this.getFieldName(method);
        if (this.isGetter(method, fieldName)) {
            Object result = liveMap.get(fieldName);
            if (result instanceof RedissonReference) {
                return RedissonObjectFactory.create(this.redisson, this.codecProvider, this.resolverProvider, (RedissonReference)result, method.getReturnType());
            }
            return result;
        }
        if (this.isSetter(method, fieldName)) {
            Class<? extends RObject> mappedClass;
            Class<?> idFieldType = me.getClass().getSuperclass().getDeclaredField(fieldName).getType();
            if (args[0].getClass().getSuperclass().isAnnotationPresent(REntity.class)) {
                Class<?> rEntity = args[0].getClass().getSuperclass();
                REntity anno = rEntity.getAnnotation(REntity.class);
                NamingScheme ns = anno.namingScheme().getDeclaredConstructor(Codec.class).newInstance(this.codecProvider.getCodec(anno, rEntity));
                liveMap.put(fieldName, new RedissonReference(rEntity, ns.getName(rEntity, idFieldType, AccessorInterceptor.getREntityIdFieldName(args[0]), ((RLiveObject)args[0]).getLiveObjectId())));
                return me;
            }
            Object arg = args[0];
            if (!(arg instanceof RObject) && (arg instanceof BitSet || arg instanceof Collection || arg instanceof Map) && REntity.TransformationMode.ANNOTATION_BASED.equals((Object)me.getClass().getSuperclass().getAnnotation(REntity.class).fieldTransformation()) && (mappedClass = AccessorInterceptor.getMappedClass(arg)) != null) {
                Map.Entry<NamingScheme, Codec> entry = this.getFieldNamingSchemeAndCodec(me.getClass().getSuperclass(), mappedClass, fieldName);
                RObject obj = RedissonObjectFactory.create(this.redisson, mappedClass, entry.getKey().getFieldReferenceName(me.getClass().getSuperclass(), idFieldType, AccessorInterceptor.getREntityIdFieldName(me), ((RLiveObject)me).getLiveObjectId(), mappedClass, fieldName, arg), entry.getValue());
                if (obj instanceof RBitSet) {
                    ((RBitSet)obj).set((BitSet)args[0]);
                } else if (obj instanceof Collection) {
                    ((Collection)((Object)obj)).addAll((Collection)arg);
                } else {
                    ((Map)((Object)obj)).putAll((Map)arg);
                }
                arg = obj;
            }
            if (arg instanceof RObject) {
                RObject ar = (RObject)arg;
                Codec codec = ar.getCodec();
                this.codecProvider.registerCodec(codec.getClass(), ar, codec);
                liveMap.put(fieldName, new RedissonReference(ar.getClass(), ar.getName(), codec));
                return me;
            }
            liveMap.put(fieldName, args[0]);
            return me;
        }
        return superMethod.call();
    }

    private String getFieldName(Method method) {
        return method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
    }

    private boolean isGetter(Method method, String fieldName) {
        return method.getName().startsWith("get") && method.getName().endsWith(AccessorInterceptor.getFieldNameSuffix(fieldName));
    }

    private boolean isSetter(Method method, String fieldName) {
        return method.getName().startsWith("set") && method.getName().endsWith(AccessorInterceptor.getFieldNameSuffix(fieldName));
    }

    private Map.Entry<NamingScheme, Codec> getFieldNamingSchemeAndCodec(Class<?> rEntity, Class<? extends RObject> rObjectClass, String fieldName) throws Exception {
        Object c;
        Annotation anno;
        Field field = rEntity.getDeclaredField(fieldName);
        if (field.isAnnotationPresent(RObjectField.class)) {
            anno = field.getAnnotation(RObjectField.class);
            c = this.codecProvider.getCodec((RObjectField)anno, rEntity, rObjectClass, fieldName);
            if (!this.namingSchemeCache.containsKey(fieldName)) {
                this.namingSchemeCache.putIfAbsent(fieldName, anno.namingScheme().getDeclaredConstructor(Codec.class).newInstance(c));
            }
        } else {
            anno = rEntity.getAnnotation(REntity.class);
            c = this.codecProvider.getCodec((REntity)anno, rEntity);
            if (!this.namingSchemeCache.containsKey(fieldName)) {
                this.namingSchemeCache.putIfAbsent(fieldName, anno.namingScheme().getDeclaredConstructor(Codec.class).newInstance(c));
            }
        }
        AbstractMap.SimpleImmutableEntry<NamingScheme, Codec> entry = new AbstractMap.SimpleImmutableEntry<NamingScheme, Codec>((NamingScheme)this.namingSchemeCache.get(fieldName), (Codec)c);
        return entry;
    }

    private static String getFieldNameSuffix(String fieldName) {
        return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static String getREntityIdFieldName(Object o) throws Exception {
        return ((FieldDescription.InDefinedShape)Introspectior.getFieldsWithAnnotation(o.getClass().getSuperclass(), RId.class).getOnly()).getName();
    }

    private static Class<? extends RObject> getMappedClass(Object obj) {
        for (Map.Entry<Class, Class<? extends RObject>> entrySet : supportedClassMapping.entrySet()) {
            if (!entrySet.getKey().isInstance(obj)) continue;
            return entrySet.getValue();
        }
        return null;
    }

    static {
        supportedClassMapping.put(SortedSet.class, RedissonSortedSet.class);
        supportedClassMapping.put(Set.class, RedissonSet.class);
        supportedClassMapping.put(ConcurrentMap.class, RedissonMap.class);
        supportedClassMapping.put(Map.class, RedissonMap.class);
        supportedClassMapping.put(BlockingDeque.class, RedissonBlockingDeque.class);
        supportedClassMapping.put(Deque.class, RedissonDeque.class);
        supportedClassMapping.put(BlockingQueue.class, RedissonBlockingQueue.class);
        supportedClassMapping.put(Queue.class, RedissonQueue.class);
        supportedClassMapping.put(List.class, RedissonList.class);
        supportedClassMapping.put(BitSet.class, RedissonBitSet.class);
    }
}

