/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.balancer;

import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.balancer.LoadBalancer;
import org.redisson.misc.URIBuilder;

public class WeightedRoundRobinBalancer
implements LoadBalancer {
    private final AtomicInteger index = new AtomicInteger(-1);
    private final Map<InetSocketAddress, WeightEntry> weights = PlatformDependent.newConcurrentHashMap();
    private final int defaultWeight;

    public WeightedRoundRobinBalancer(Map<String, Integer> weights, int defaultWeight) {
        for (Map.Entry<String, Integer> entry : weights.entrySet()) {
            URI uri = URIBuilder.create(entry.getKey());
            InetSocketAddress addr = new InetSocketAddress(uri.getHost(), uri.getPort());
            if (entry.getValue() <= 0) {
                throw new IllegalArgumentException("Weight can't be less than or equal zero");
            }
            this.weights.put(addr, new WeightEntry(entry.getValue()));
        }
        if (defaultWeight <= 0) {
            throw new IllegalArgumentException("Weight can't be less than or equal zero");
        }
        this.defaultWeight = defaultWeight;
    }

    private Set<InetSocketAddress> getAddresses(List<ClientConnectionsEntry> clients) {
        HashSet<InetSocketAddress> result = new HashSet<InetSocketAddress>();
        for (ClientConnectionsEntry entry : clients) {
            if (entry.isFreezed()) continue;
            result.add(entry.getClient().getAddr());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientConnectionsEntry getEntry(List<ClientConnectionsEntry> clients) {
        Set<InetSocketAddress> addresses = this.getAddresses(clients);
        if (!addresses.equals(this.weights.keySet())) {
            HashSet<InetSocketAddress> newAddresses = new HashSet<InetSocketAddress>(addresses);
            newAddresses.removeAll(this.weights.keySet());
            for (InetSocketAddress addr : newAddresses) {
                this.weights.put(addr, new WeightEntry(this.defaultWeight));
            }
        }
        Map<InetSocketAddress, WeightEntry> weightsCopy = new HashMap<InetSocketAddress, WeightEntry>(this.weights);
        ArrayList<ClientConnectionsEntry> clientsCopy = new ArrayList<ClientConnectionsEntry>();
        WeightedRoundRobinBalancer weightedRoundRobinBalancer = this;
        synchronized (weightedRoundRobinBalancer) {
            Iterator iterator = weightsCopy.values().iterator();
            while (iterator.hasNext()) {
                WeightEntry weightEntry = (WeightEntry)iterator.next();
                if (!weightEntry.isWeightCounterZero()) continue;
                iterator.remove();
            }
            if (weightsCopy.isEmpty()) {
                for (WeightEntry weightEntry : this.weights.values()) {
                    weightEntry.resetWeightCounter();
                }
                weightsCopy = this.weights;
            }
            block6: for (InetSocketAddress inetSocketAddress : weightsCopy.keySet()) {
                for (ClientConnectionsEntry clientConnectionsEntry : clients) {
                    if (!clientConnectionsEntry.getClient().getAddr().equals(inetSocketAddress) || clientConnectionsEntry.isFreezed()) continue;
                    clientsCopy.add(clientConnectionsEntry);
                    continue block6;
                }
            }
            int ind = Math.abs(this.index.incrementAndGet() % clientsCopy.size());
            ClientConnectionsEntry clientConnectionsEntry = (ClientConnectionsEntry)clientsCopy.get(ind);
            WeightEntry weightEntry = this.weights.get(clientConnectionsEntry.getClient().getAddr());
            weightEntry.decWeightCounter();
            return clientConnectionsEntry;
        }
    }

    static class WeightEntry {
        final int weight;
        int weightCounter;

        WeightEntry(int weight) {
            this.weight = weight;
            this.weightCounter = weight;
        }

        public boolean isWeightCounterZero() {
            return this.weightCounter == 0;
        }

        public void decWeightCounter() {
            --this.weightCounter;
        }

        public void resetWeightCounter() {
            this.weightCounter = this.weight;
        }
    }
}

