/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.api.NodeType;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.connection.balancer.LoadBalancerManager;
import org.redisson.connection.balancer.LoadBalancerManagerImpl;
import org.redisson.connection.pool.MasterConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSlaveEntry {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    LoadBalancerManager slaveBalancer;
    ClientConnectionsEntry masterEntry;
    final MasterSlaveServersConfig config;
    final ConnectionManager connectionManager;
    final MasterConnectionPool writeConnectionHolder;
    final Set<Integer> slots = new HashSet<Integer>();
    final AtomicBoolean active = new AtomicBoolean(true);

    public MasterSlaveEntry(Set<ClusterSlotRange> slotRanges, ConnectionManager connectionManager, MasterSlaveServersConfig config) {
        for (ClusterSlotRange clusterSlotRange : slotRanges) {
            for (int i = clusterSlotRange.getStartSlot(); i < clusterSlotRange.getEndSlot() + 1; ++i) {
                this.slots.add(i);
            }
        }
        this.connectionManager = connectionManager;
        this.config = config;
        this.slaveBalancer = new LoadBalancerManagerImpl(config, connectionManager, this);
        this.writeConnectionHolder = new MasterConnectionPool(config, connectionManager, this);
    }

    public List<Future<Void>> initSlaveBalancer(Collection<URI> disconnectedNodes) {
        boolean freezeMasterAsSlave = !this.config.getSlaveAddresses().isEmpty() && this.config.getReadMode() == ReadMode.SLAVE && disconnectedNodes.size() < this.config.getSlaveAddresses().size();
        LinkedList<Future<Void>> result = new LinkedList<Future<Void>>();
        Future<Void> f = this.addSlave(this.config.getMasterAddress().getHost(), this.config.getMasterAddress().getPort(), freezeMasterAsSlave, NodeType.MASTER);
        result.add(f);
        for (URI address : this.config.getSlaveAddresses()) {
            f = this.addSlave(address.getHost(), address.getPort(), disconnectedNodes.contains(address), NodeType.SLAVE);
            result.add(f);
        }
        return result;
    }

    public Future<Void> setupMasterEntry(String host, int port) {
        RedisClient client = this.connectionManager.createClient(NodeType.MASTER, host, port);
        this.masterEntry = new ClientConnectionsEntry(client, this.config.getMasterConnectionMinimumIdleSize(), this.config.getMasterConnectionPoolSize(), 0, 0, this.connectionManager, NodeType.MASTER);
        return this.writeConnectionHolder.add(this.masterEntry);
    }

    private boolean slaveDown(ClientConnectionsEntry entry, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry e = this.slaveBalancer.freeze(entry, freezeReason);
        if (e == null) {
            return false;
        }
        return this.slaveDown(e);
    }

    public boolean slaveDown(String host, int port, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry entry = this.slaveBalancer.freeze(host, port, freezeReason);
        if (entry == null) {
            return false;
        }
        return this.slaveDown(entry);
    }

    private boolean slaveDown(ClientConnectionsEntry entry) {
        RedisConnection connection;
        InetSocketAddress addr;
        if (this.config.getReadMode() == ReadMode.SLAVE && this.slaveBalancer.getAvailableClients() == 0 && this.slaveUp((addr = this.masterEntry.getClient().getAddr()).getHostName(), addr.getPort(), ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {}:{} used as slave", (Object)addr.getHostName(), (Object)addr.getPort());
        }
        while ((connection = entry.pollConnection()) != null) {
            connection.closeAsync().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    MasterSlaveEntry.this.reattachBlockingQueue(connection);
                }
            });
        }
        while ((connection = entry.pollSubscribeConnection()) != null) {
            connection.closeAsync();
        }
        for (RedisPubSubConnection connection2 : entry.getAllSubscribeConnections()) {
            this.reattachPubSub(connection2);
        }
        entry.getAllSubscribeConnections().clear();
        return true;
    }

    private void reattachPubSub(RedisPubSubConnection redisPubSubConnection) {
        Collection<RedisPubSubListener> listeners;
        PubSubConnectionEntry pubSubEntry;
        for (String channelName : redisPubSubConnection.getChannels().keySet()) {
            pubSubEntry = this.connectionManager.getPubSubEntry(channelName);
            listeners = pubSubEntry.getListeners(channelName);
            this.reattachPubSubListeners(channelName, listeners);
        }
        for (String channelName : redisPubSubConnection.getPatternChannels().keySet()) {
            pubSubEntry = this.connectionManager.getPubSubEntry(channelName);
            listeners = pubSubEntry.getListeners(channelName);
            this.reattachPatternPubSubListeners(channelName, listeners);
        }
    }

    private void reattachPubSubListeners(final String channelName, final Collection<RedisPubSubListener> listeners) {
        Codec subscribeCodec = this.connectionManager.unsubscribe(channelName);
        if (listeners.isEmpty()) {
            return;
        }
        Future<PubSubConnectionEntry> subscribeFuture = this.connectionManager.subscribe(subscribeCodec, channelName, null);
        subscribeFuture.addListener((GenericFutureListener<Future<PubSubConnectionEntry>>)new FutureListener<PubSubConnectionEntry>(){

            @Override
            public void operationComplete(Future<PubSubConnectionEntry> future) throws Exception {
                if (!future.isSuccess()) {
                    MasterSlaveEntry.this.log.error("Can't resubscribe topic channel: " + channelName);
                    return;
                }
                PubSubConnectionEntry newEntry = future.getNow();
                for (RedisPubSubListener redisPubSubListener : listeners) {
                    newEntry.addListener(channelName, redisPubSubListener);
                }
                MasterSlaveEntry.this.log.debug("resubscribed listeners for '{}' channel", (Object)channelName);
            }
        });
    }

    private void reattachPatternPubSubListeners(final String channelName, final Collection<RedisPubSubListener> listeners) {
        Codec subscribeCodec = this.connectionManager.punsubscribe(channelName);
        if (!listeners.isEmpty()) {
            Future<PubSubConnectionEntry> future = this.connectionManager.psubscribe(channelName, subscribeCodec, null);
            future.addListener((GenericFutureListener<Future<PubSubConnectionEntry>>)new FutureListener<PubSubConnectionEntry>(){

                @Override
                public void operationComplete(Future<PubSubConnectionEntry> future) throws Exception {
                    if (!future.isSuccess()) {
                        MasterSlaveEntry.this.log.error("Can't resubscribe topic channel: " + channelName);
                        return;
                    }
                    PubSubConnectionEntry newEntry = future.getNow();
                    for (RedisPubSubListener redisPubSubListener : listeners) {
                        newEntry.addListener(channelName, redisPubSubListener);
                    }
                    MasterSlaveEntry.this.log.debug("resubscribed listeners for '{}' channel-pattern", (Object)channelName);
                }
            });
        }
    }

    private void reattachBlockingQueue(RedisConnection connection) {
        final CommandData commandData = connection.getCurrentCommand();
        if (commandData == null || !commandData.isBlockingCommand()) {
            return;
        }
        Future<RedisConnection> newConnection = this.connectionReadOp();
        newConnection.addListener((GenericFutureListener<Future<RedisConnection>>)new FutureListener<RedisConnection>(){

            @Override
            public void operationComplete(Future<RedisConnection> future) throws Exception {
                if (!future.isSuccess()) {
                    MasterSlaveEntry.this.log.error("Can't resubscribe blocking queue {}", (Object)commandData);
                    return;
                }
                final RedisConnection newConnection = future.getNow();
                final FutureListener<Object> listener = new FutureListener<Object>(){

                    @Override
                    public void operationComplete(Future<Object> future) throws Exception {
                        MasterSlaveEntry.this.releaseRead(newConnection);
                    }
                };
                commandData.getPromise().addListener(listener);
                if (commandData.getPromise().isDone()) {
                    return;
                }
                ChannelFuture channelFuture = newConnection.send(commandData);
                channelFuture.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            listener.operationComplete(null);
                            commandData.getPromise().removeListener(listener);
                            MasterSlaveEntry.this.releaseRead(newConnection);
                            MasterSlaveEntry.this.log.error("Can't resubscribe blocking queue {}", (Object)commandData);
                        }
                    }
                });
            }
        });
    }

    public Future<Void> addSlave(String host, int port) {
        return this.addSlave(host, port, true, NodeType.SLAVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> addSlave(String host, int port, boolean freezed, NodeType mode) {
        RedisClient client = this.connectionManager.createClient(NodeType.SLAVE, host, port);
        ClientConnectionsEntry entry = new ClientConnectionsEntry(client, this.config.getSlaveConnectionMinimumIdleSize(), this.config.getSlaveConnectionPoolSize(), this.config.getSlaveSubscriptionConnectionMinimumIdleSize(), this.config.getSlaveSubscriptionConnectionPoolSize(), this.connectionManager, mode);
        if (freezed) {
            ClientConnectionsEntry clientConnectionsEntry = entry;
            synchronized (clientConnectionsEntry) {
                entry.setFreezed(freezed);
                entry.setFreezeReason(ClientConnectionsEntry.FreezeReason.SYSTEM);
            }
        }
        return this.slaveBalancer.add(entry);
    }

    public RedisClient getClient() {
        return this.masterEntry.getClient();
    }

    public boolean slaveUp(String host, int port, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (!this.slaveBalancer.unfreeze(host, port, freezeReason)) {
            return false;
        }
        InetSocketAddress addr = this.masterEntry.getClient().getAddr();
        if (!(this.config.getReadMode() != ReadMode.SLAVE || addr.getHostName().equals(host) && port == addr.getPort())) {
            this.slaveDown(addr.getHostName(), addr.getPort(), ClientConnectionsEntry.FreezeReason.SYSTEM);
            this.log.info("master {}:{} excluded from slaves", (Object)addr.getHostName(), (Object)addr.getPort());
        }
        return true;
    }

    public void changeMaster(String host, int port) {
        ClientConnectionsEntry oldMaster = this.masterEntry;
        this.setupMasterEntry(host, port);
        this.writeConnectionHolder.remove(oldMaster);
        this.slaveDown(oldMaster, ClientConnectionsEntry.FreezeReason.MANAGER);
        if (this.config.getReadMode() == ReadMode.SLAVE && this.slaveBalancer.getAvailableClients() > 1) {
            this.slaveDown(host, port, ClientConnectionsEntry.FreezeReason.SYSTEM);
        }
        this.connectionManager.shutdownAsync(oldMaster.getClient());
    }

    public boolean isFreezed() {
        return this.masterEntry.isFreezed();
    }

    public ClientConnectionsEntry.FreezeReason getFreezeReason() {
        return this.masterEntry.getFreezeReason();
    }

    public void freeze() {
        this.masterEntry.freezeMaster(ClientConnectionsEntry.FreezeReason.MANAGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfreeze() {
        this.masterEntry.resetFailedAttempts();
        ClientConnectionsEntry clientConnectionsEntry = this.masterEntry;
        synchronized (clientConnectionsEntry) {
            this.masterEntry.setFreezed(false);
            this.masterEntry.setFreezeReason(null);
        }
    }

    public void shutdownMasterAsync() {
        if (!this.active.compareAndSet(true, false)) {
            return;
        }
        this.connectionManager.shutdownAsync(this.masterEntry.getClient());
        this.slaveBalancer.shutdownAsync();
    }

    public Future<RedisConnection> connectionWriteOp() {
        return this.writeConnectionHolder.get();
    }

    public Future<RedisConnection> connectionReadOp() {
        return this.slaveBalancer.nextConnection();
    }

    public Future<RedisConnection> connectionReadOp(InetSocketAddress addr) {
        return this.slaveBalancer.getConnection(addr);
    }

    Future<RedisPubSubConnection> nextPubSubConnection() {
        return this.slaveBalancer.nextPubSubConnection();
    }

    public void returnPubSubConnection(PubSubConnectionEntry entry) {
        this.slaveBalancer.returnPubSubConnection(entry.getConnection());
    }

    public void releaseWrite(RedisConnection connection) {
        this.writeConnectionHolder.returnConnection(this.masterEntry, connection);
    }

    public void releaseRead(RedisConnection \u0441onnection) {
        this.slaveBalancer.returnConnection(\u0441onnection);
    }

    public void shutdown() {
        if (!this.active.compareAndSet(true, false)) {
            return;
        }
        this.masterEntry.getClient().shutdown();
        this.slaveBalancer.shutdown();
    }

    public void addSlotRange(Integer range) {
        this.slots.add(range);
    }

    public void removeSlotRange(Integer range) {
        this.slots.remove(range);
    }

    public Set<Integer> getSlotRanges() {
        return this.slots;
    }
}

