/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.Promise;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommand;

public class FutureConnectionListener<T extends RedisConnection>
implements FutureListener<Object> {
    private final AtomicInteger commandsCounter = new AtomicInteger();
    private final Promise<T> connectionPromise;
    private final T connection;
    private final List<Runnable> commands = new ArrayList<Runnable>(4);

    public FutureConnectionListener(Promise<T> connectionFuture, T connection) {
        this.connectionPromise = connectionFuture;
        this.connection = connection;
    }

    public void addCommand(final RedisCommand<?> command, final Object ... params) {
        this.commandsCounter.incrementAndGet();
        this.commands.add(new Runnable(){

            @Override
            public void run() {
                Future future = FutureConnectionListener.this.connection.async(command, params);
                future.addListener(FutureConnectionListener.this);
            }
        });
    }

    public void executeCommands() {
        if (this.commands.isEmpty()) {
            this.connectionPromise.setSuccess(this.connection);
            return;
        }
        for (Runnable command : this.commands) {
            command.run();
        }
        this.commands.clear();
    }

    @Override
    public void operationComplete(Future<Object> future) throws Exception {
        if (!future.isSuccess()) {
            ((RedisConnection)this.connection).closeAsync();
            this.connectionPromise.tryFailure(future.cause());
            return;
        }
        if (this.commandsCounter.decrementAndGet() == 0) {
            this.connectionPromise.trySuccess(this.connection);
        }
    }
}

