/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.Promise;
import org.redisson.api.NodeType;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ConnectionInitializer;
import org.redisson.connection.FutureConnectionListener;

public class DefaultConnectionListener
implements ConnectionInitializer {
    @Override
    public final <T extends RedisConnection> void onConnect(Promise<T> connectionFuture, T conn, NodeType nodeType, MasterSlaveServersConfig config) {
        FutureConnectionListener<T> listener = new FutureConnectionListener<T>(connectionFuture, conn);
        this.doConnect(config, nodeType, listener);
        listener.executeCommands();
    }

    protected void doConnect(MasterSlaveServersConfig config, NodeType nodeType, FutureConnectionListener<? extends RedisConnection> connectionListener) throws RedisException {
        if (config.getPassword() != null) {
            connectionListener.addCommand(RedisCommands.AUTH, config.getPassword());
        }
        if (config.getDatabase() != 0) {
            connectionListener.addCommand(RedisCommands.SELECT, config.getDatabase());
        }
        if (config.getClientName() != null) {
            connectionListener.addCommand(RedisCommands.CLIENT_SETNAME, config.getClientName());
        }
    }
}

