/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonMultiLock;

public class RedissonRedLock
extends RedissonMultiLock {
    public RedissonRedLock(RLock ... locks) {
        super(locks);
    }

    @Override
    protected boolean sync(Map<RLock, Future<Boolean>> tryLockFutures) {
        ArrayList<RLock> lockedLocks = new ArrayList<RLock>(tryLockFutures.size());
        RuntimeException latestException = null;
        for (Map.Entry<RLock, Future<Boolean>> entry : tryLockFutures.entrySet()) {
            try {
                if (!entry.getValue().syncUninterruptibly().getNow().booleanValue()) continue;
                lockedLocks.add(entry.getKey());
            }
            catch (RuntimeException e) {
                latestException = e;
            }
        }
        if (lockedLocks.size() < this.minLocksAmount(this.locks)) {
            this.unlockInner(lockedLocks);
            if (latestException != null) {
                throw latestException;
            }
            return false;
        }
        return true;
    }

    protected int minLocksAmount(List<RLock> locks) {
        return locks.size() / 2 + 1;
    }

    @Override
    public void unlock() {
        this.unlockInner(this.locks);
    }

    @Override
    protected boolean isLockFailed(Future<Boolean> future) {
        return false;
    }

    @Override
    protected boolean isAllLocksAcquired(AtomicReference<RLock> lockedLockHolder, AtomicReference<Throwable> failed, Queue<RLock> lockedLocks) {
        return lockedLockHolder.get() == null && failed.get() == null || lockedLocks.size() >= this.minLocksAmount(this.locks);
    }
}

