/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.Collections;
import java.util.List;
import org.redisson.PubSubMessageListener;
import org.redisson.PubSubStatusListener;
import org.redisson.api.MessageListener;
import org.redisson.api.RTopic;
import org.redisson.api.StatusListener;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.pubsub.AsyncSemaphore;

public class RedissonTopic<M>
implements RTopic<M> {
    final CommandAsyncExecutor commandExecutor;
    private final String name;
    private final Codec codec;

    protected RedissonTopic(CommandAsyncExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    protected RedissonTopic(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.codec = codec;
    }

    @Override
    public List<String> getChannelNames() {
        return Collections.singletonList(this.name);
    }

    @Override
    public long publish(M message) {
        return this.commandExecutor.get(this.publishAsync(message));
    }

    @Override
    public Future<Long> publishAsync(M message) {
        return this.commandExecutor.writeAsync(this.name, this.codec, RedisCommands.PUBLISH, this.name, message);
    }

    @Override
    public int addListener(StatusListener listener) {
        return this.addListener(new PubSubStatusListener(listener, this.name));
    }

    @Override
    public int addListener(MessageListener<M> listener) {
        PubSubMessageListener<M> pubSubListener = new PubSubMessageListener<M>(listener, this.name);
        return this.addListener((RedisPubSubListener<?>)pubSubListener);
    }

    @Override
    private int addListener(RedisPubSubListener<?> pubSubListener) {
        Future<PubSubConnectionEntry> future = this.commandExecutor.getConnectionManager().subscribe(this.codec, this.name, pubSubListener);
        future.syncUninterruptibly();
        return System.identityHashCode(pubSubListener);
    }

    @Override
    public void removeListener(int listenerId) {
        AsyncSemaphore semaphore = this.commandExecutor.getConnectionManager().getSemaphore(this.name);
        semaphore.acquireUninterruptibly();
        PubSubConnectionEntry entry = this.commandExecutor.getConnectionManager().getPubSubEntry(this.name);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeListener(this.name, listenerId);
        if (!entry.hasListeners(this.name)) {
            this.commandExecutor.getConnectionManager().unsubscribe(this.name, semaphore);
        } else {
            semaphore.release();
        }
    }
}

