/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.redisson.RedissonBaseIterator;
import org.redisson.RedissonExpirable;
import org.redisson.api.RSet;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.IntegerReplayConvertor;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ListScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.NestedMultiDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonSetMultimapValues<V>
extends RedissonExpirable
implements RSet<V> {
    private static final RedisCommand<ListScanResult<Object>> EVAL_SSCAN = new RedisCommand<Object>("EVAL", new NestedMultiDecoder(new ObjectListReplayDecoder(), new ListScanResultReplayDecoder()), 7, RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.OBJECT);
    private static final RedisCommand<Integer> EVAL_SIZE = new RedisCommand<Integer>("EVAL", new IntegerReplayConvertor(), 6, RedisCommand.ValueType.MAP_KEY);
    private static final RedisCommand<Set<Object>> EVAL_READALL = new RedisCommand("EVAL", new ObjectSetReplayDecoder(), 6, RedisCommand.ValueType.MAP_KEY);
    private static final RedisCommand<Boolean> EVAL_CONTAINS_VALUE = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 6, Arrays.asList(RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE));
    private static final RedisCommand<Boolean> EVAL_CONTAINS_ALL_WITH_VALUES = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 7, RedisCommand.ValueType.OBJECTS);
    private final Object key;
    private final String timeoutSetName;

    public RedissonSetMultimapValues(Codec codec, CommandAsyncExecutor commandExecutor, String name, String timeoutSetName, Object key) {
        super(codec, commandExecutor, name);
        this.timeoutSetName = timeoutSetName;
        this.key = key;
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public Future<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, EVAL_SIZE, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('scard', KEYS[2]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public Future<Boolean> containsAsync(Object o) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, EVAL_CONTAINS_VALUE, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('sismember', KEYS[2], ARGV[3]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key, o);
    }

    private ListScanResult<V> scanIterator(InetSocketAddress client, long startPos) {
        Future f = this.commandExecutor.evalReadAsync(client, this.getName(), this.codec, EVAL_SSCAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return {0, {}};end;return redis.call('sscan', KEYS[2], ARGV[2]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), startPos, this.key);
        return (ListScanResult)this.get(f);
    }

    @Override
    public Iterator<V> iterator() {
        return new RedissonBaseIterator<V>(){

            @Override
            ListScanResult<V> iterator(InetSocketAddress client, long nextIterPos) {
                return RedissonSetMultimapValues.this.scanIterator(client, nextIterPos);
            }

            @Override
            void remove(V value) {
                RedissonSetMultimapValues.this.remove(value);
            }
        };
    }

    @Override
    public Future<Set<V>> readAllAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, EVAL_READALL, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return {};end; return redis.call('smembers', KEYS[2]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key);
    }

    @Override
    public Set<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public Object[] toArray() {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public Future<Boolean> addAsync(V e) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SADD_SINGLE, this.getName(), e);
    }

    @Override
    public V removeRandom() {
        return this.get(this.removeRandomAsync());
    }

    @Override
    public Future<V> removeRandomAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SPOP_SINGLE, this.getName());
    }

    @Override
    public V random() {
        return this.get(this.randomAsync());
    }

    @Override
    public Future<V> randomAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SRANDMEMBER_SINGLE, this.getName());
    }

    @Override
    public Future<Boolean> removeAsync(Object o) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_CONTAINS_VALUE, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('srem', KEYS[2], ARGV[3]) > 0 and 1 or 0;", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key, o);
    }

    @Override
    public boolean remove(Object value) {
        return this.get(this.removeAsync(value));
    }

    @Override
    public Future<Boolean> moveAsync(String destination, V member) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SMOVE, this.getName(), destination, member);
    }

    @Override
    public boolean move(String destination, V member) {
        return this.get(this.moveAsync(destination, member));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public Future<Boolean> containsAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(this.key);
            args.add(System.currentTimeMillis());
            args.add(keyState);
            args.addAll(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, EVAL_CONTAINS_ALL_WITH_VALUES, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local s = redis.call('smembers', KEYS[2]);for i = 1, #s, 1 do for j = 2, #ARGV, 1 do if ARGV[j] == s[i] then table.remove(ARGV, j) end end; end;return #ARGV == 2 and 1 or 0; ", Arrays.asList(this.timeoutSetName, this.getName()), args.toArray());
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return false;
        }
        return this.get(this.addAllAsync(c));
    }

    @Override
    public Future<Boolean> addAllAsync(Collection<? extends V> c) {
        ArrayList<String> args = new ArrayList<String>(c.size() + 1);
        args.add(this.getName());
        args.addAll(c);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SADD_BOOL, args.toArray());
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public Future<Boolean> retainAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(this.key);
            args.add(System.currentTimeMillis());
            args.add(keyState);
            args.addAll(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_CONTAINS_ALL_WITH_VALUES, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local changed = 0 local s = redis.call('smembers', KEYS[2]) local i = 1 while i <= #s do local element = s[i] local isInAgrs = false for j = 2, #ARGV, 1 do if ARGV[j] == element then isInAgrs = true break end end if isInAgrs == false then redis.call('SREM', KEYS[2], element) changed = 1 end i = i + 1 end return changed ", Arrays.asList(this.timeoutSetName, this.getName()), args.toArray());
    }

    @Override
    public Future<Boolean> removeAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(this.key);
            args.add(System.currentTimeMillis());
            args.add(keyState);
            args.addAll(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_CONTAINS_ALL_WITH_VALUES, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local v = 0 for i = 2, #ARGV, 1 do if redis.call('srem', KEYS[2], ARGV[i]) == 1 then v = 1 end end return v ", Arrays.asList(this.timeoutSetName, this.getName()), args.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public int union(String ... names) {
        return this.get(this.unionAsync(names));
    }

    @Override
    public Future<Integer> unionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SUNIONSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readUnion(String ... names) {
        return this.get(this.readUnionAsync(names));
    }

    @Override
    public Future<Set<V>> readUnionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SUNION, args.toArray());
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public int diff(String ... names) {
        return this.get(this.diffAsync(names));
    }

    @Override
    public Future<Integer> diffAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SDIFFSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readDiff(String ... names) {
        return this.get(this.readDiffAsync(names));
    }

    @Override
    public Future<Set<V>> readDiffAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SDIFF, args.toArray());
    }

    @Override
    public int intersection(String ... names) {
        return this.get(this.intersectionAsync(names));
    }

    @Override
    public Future<Integer> intersectionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SINTERSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readIntersection(String ... names) {
        return this.get(this.readIntersectionAsync(names));
    }

    @Override
    public Future<Set<V>> readIntersectionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SINTER, args.toArray());
    }
}

