/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.redisson.RedissonMultimap;
import org.redisson.RedissonSet;
import org.redisson.RedissonSetMultimapIterator;
import org.redisson.api.RSetMultimap;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanAmountReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonSetMultimap<K, V>
extends RedissonMultimap<K, V>
implements RSetMultimap<K, V> {
    private static final RedisStrictCommand<Boolean> SCARD_VALUE = new RedisStrictCommand<Boolean>("SCARD", new BooleanAmountReplayConvertor());
    private static final RedisCommand<Boolean> SISMEMBER_VALUE = new RedisCommand<Boolean>("SISMEMBER", new BooleanReplayConvertor());

    RedissonSetMultimap(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    RedissonSetMultimap(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    @Override
    public Future<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_INTEGER, "local keys = redis.call('hgetall', KEYS[1]); local size = 0; for i, v in ipairs(keys) do if i % 2 == 0 then local name = '{' .. KEYS[1] .. '}:' .. v; size = size + redis.call('scard', name); end;end; return size; ", Arrays.asList(this.getName()), new Object[0]);
    }

    @Override
    public Future<Boolean> containsKeyAsync(Object key) {
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(key);
            String keyHash = this.hash(keyState);
            String setName = this.getValuesName(keyHash);
            return this.commandExecutor.readAsync(this.getName(), this.codec, SCARD_VALUE, setName);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Future<Boolean> containsValueAsync(Object value) {
        try {
            byte[] valueState = this.codec.getMapValueEncoder().encode(value);
            return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local keys = redis.call('hgetall', KEYS[1]); for i, v in ipairs(keys) do if i % 2 == 0 then local name = '{' .. KEYS[1] .. '}:' .. v; if redis.call('sismember', name, ARGV[1]) == 1 then return 1; end;end;end; return 0; ", Arrays.asList(this.getName()), new Object[]{valueState});
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Future<Boolean> containsEntryAsync(Object key, Object value) {
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(key);
            String keyHash = this.hash(keyState);
            byte[] valueState = this.codec.getMapValueEncoder().encode(value);
            String setName = this.getValuesName(keyHash);
            return this.commandExecutor.readAsync(this.getName(), this.codec, SISMEMBER_VALUE, setName, valueState);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Future<Boolean> putAsync(K key, V value) {
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(key);
            String keyHash = this.hash(keyState);
            byte[] valueState = this.codec.getMapValueEncoder().encode(value);
            String setName = this.getValuesName(keyHash);
            return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return redis.call('sadd', KEYS[2], ARGV[3]); ", Arrays.asList(this.getName(), setName), keyState, keyHash, valueState);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Future<Boolean> removeAsync(Object key, Object value) {
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(key);
            String keyHash = this.hash(keyState);
            byte[] valueState = this.codec.getMapValueEncoder().encode(value);
            String setName = this.getValuesName(keyHash);
            return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local res = redis.call('srem', KEYS[2], ARGV[2]); if res == 1 and redis.call('scard', KEYS[2]) == 0 then redis.call('hdel', KEYS[1], ARGV[1]); end; return res; ", Arrays.asList(this.getName(), setName), keyState, valueState);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Future<Boolean> putAllAsync(K key, Iterable<? extends V> values) {
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            byte[] keyState = this.codec.getMapKeyEncoder().encode(key);
            params.add(keyState);
            String keyHash = this.hash(keyState);
            params.add(keyHash);
            for (V value : values) {
                byte[] valueState = this.codec.getMapValueEncoder().encode(value);
                params.add(valueState);
            }
            String setName = this.getValuesName(keyHash);
            return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN_AMOUNT, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return redis.call('sadd', KEYS[2], unpack(ARGV, 3, #ARGV)); ", Arrays.asList(this.getName(), setName), params.toArray());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Set<V> get(K key) {
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(key);
            String keyHash = this.hash(keyState);
            String setName = this.getValuesName(keyHash);
            return new RedissonSet(this.codec, this.commandExecutor, setName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Set<V> getAll(K key) {
        return (Set)super.getAll(key);
    }

    @Override
    public Future<Collection<V>> getAllAsync(K key) {
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(key);
            String keyHash = this.hash(keyState);
            String setName = this.getValuesName(keyHash);
            return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SMEMBERS, setName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Set<V> removeAll(Object key) {
        return (Set)this.get(this.removeAllAsync(key));
    }

    @Override
    public Future<Collection<V>> removeAllAsync(Object key) {
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(key);
            String keyHash = this.hash(keyState);
            String setName = this.getValuesName(keyHash);
            return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_SET, "redis.call('hdel', KEYS[1], ARGV[1]); local members = redis.call('smembers', KEYS[2]); redis.call('del', KEYS[2]); return members; ", Arrays.asList(this.getName(), setName), new Object[]{keyState});
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return (Set)super.entries();
    }

    @Override
    public Set<V> replaceValues(K key, Iterable<? extends V> values) {
        return (Set)this.get(this.replaceValuesAsync(key, values));
    }

    @Override
    Iterator<V> valuesIterator() {
        return new RedissonSetMultimapIterator<K, V, V>(this, this.commandExecutor, this.codec){

            @Override
            V getValue(V entry) {
                return entry;
            }
        };
    }

    @Override
    RedissonSetMultimapIterator<K, V, Map.Entry<K, V>> entryIterator() {
        return new RedissonSetMultimapIterator(this, this.commandExecutor, this.codec);
    }

    @Override
    public Future<Collection<V>> replaceValuesAsync(K key, Iterable<? extends V> values) {
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            byte[] keyState = this.codec.getMapKeyEncoder().encode(key);
            params.add(keyState);
            String keyHash = this.hash(keyState);
            params.add(keyHash);
            for (V value : values) {
                byte[] valueState = this.codec.getMapValueEncoder().encode(value);
                params.add(valueState);
            }
            String setName = this.getValuesName(keyHash);
            return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_SET, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); local members = redis.call('smembers', KEYS[2]); redis.call('del', KEYS[2]); redis.call('sadd', KEYS[2], unpack(ARGV, 3, #ARGV)); return members; ", Arrays.asList(this.getName(), setName), params.toArray());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

