/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.PubSubEntry;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RSemaphore;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.pubsub.SemaphorePubSub;

public class RedissonSemaphore
extends RedissonExpirable
implements RSemaphore {
    private final SemaphorePubSub semaphorePubSub;
    final CommandExecutor commandExecutor;

    protected RedissonSemaphore(CommandExecutor commandExecutor, String name, SemaphorePubSub semaphorePubSub) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.semaphorePubSub = semaphorePubSub;
    }

    String getChannelName() {
        return RedissonSemaphore.getChannelName(this.getName());
    }

    public static String getChannelName(String name) {
        if (name.contains("{")) {
            return "redisson_sc:" + name;
        }
        return "redisson_sc:{" + name + "}";
    }

    @Override
    public void acquire() throws InterruptedException {
        this.acquire(1);
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        if (this.tryAcquire(permits)) {
            return;
        }
        Future<RedissonLockEntry> future = this.subscribe();
        this.get(future);
        try {
            while (true) {
                if (this.tryAcquire(permits)) {
                    return;
                }
                this.getEntry().getLatch().acquire(permits);
            }
        }
        finally {
            this.unsubscribe(future);
        }
    }

    @Override
    public Future<Void> acquireAsync() {
        return this.acquireAsync(1);
    }

    @Override
    public Future<Void> acquireAsync(final int permits) {
        final Promise<Void> result = this.newPromise();
        Future<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.setFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    result.setSuccess(null);
                    return;
                }
                final Future subscribeFuture = RedissonSemaphore.this.subscribe();
                subscribeFuture.addListener(new FutureListener<RedissonLockEntry>(){

                    @Override
                    public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.setFailure(future.cause());
                            return;
                        }
                        RedissonSemaphore.this.acquireAsync(permits, subscribeFuture, result);
                    }
                });
            }
        });
        return result;
    }

    private void tryAcquireAsync(final AtomicLong time, final int permits, final Future<RedissonLockEntry> subscribeFuture, final Promise<Boolean> result) {
        Future<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                RedissonLockEntry entry;
                if (!future.isSuccess()) {
                    RedissonSemaphore.this.unsubscribe(subscribeFuture);
                    result.tryFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    RedissonSemaphore.this.unsubscribe(subscribeFuture);
                    result.trySuccess(true);
                    return;
                }
                if (time.get() < 0L) {
                    RedissonSemaphore.this.unsubscribe(subscribeFuture);
                    result.trySuccess(false);
                    return;
                }
                final long current = System.currentTimeMillis();
                RedissonLockEntry redissonLockEntry = entry = RedissonSemaphore.this.getEntry();
                synchronized (redissonLockEntry) {
                    if (entry.getLatch().tryAcquire()) {
                        RedissonSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result);
                    } else {
                        final AtomicBoolean executed = new AtomicBoolean();
                        final AtomicReference futureRef = new AtomicReference();
                        final Runnable listener = new Runnable(){

                            @Override
                            public void run() {
                                executed.set(true);
                                if (futureRef.get() != null) {
                                    ((ScheduledFuture)futureRef.get()).cancel(false);
                                }
                                long elapsed = System.currentTimeMillis() - current;
                                time.addAndGet(-elapsed);
                                RedissonSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result);
                            }
                        };
                        entry.addListener(listener);
                        long t = time.get();
                        if (!executed.get()) {
                            ScheduledFuture<?> scheduledFuture = RedissonSemaphore.this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    RedissonLockEntry redissonLockEntry = entry;
                                    synchronized (redissonLockEntry) {
                                        if (entry.removeListener(listener)) {
                                            long elapsed = System.currentTimeMillis() - current;
                                            time.addAndGet(-elapsed);
                                            RedissonSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result);
                                        }
                                    }
                                }
                            }, t, TimeUnit.MILLISECONDS);
                            futureRef.set(scheduledFuture);
                        }
                    }
                }
            }
        });
    }

    private void acquireAsync(final int permits, final Future<RedissonLockEntry> subscribeFuture, final Promise<Void> result) {
        Future<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                RedissonLockEntry entry;
                if (!future.isSuccess()) {
                    RedissonSemaphore.this.unsubscribe(subscribeFuture);
                    result.setFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    RedissonSemaphore.this.unsubscribe(subscribeFuture);
                    result.setSuccess(null);
                    return;
                }
                RedissonLockEntry redissonLockEntry = entry = RedissonSemaphore.this.getEntry();
                synchronized (redissonLockEntry) {
                    if (entry.getLatch().tryAcquire(permits)) {
                        RedissonSemaphore.this.acquireAsync(permits, subscribeFuture, result);
                    } else {
                        Runnable listener = new Runnable(){

                            @Override
                            public void run() {
                                RedissonSemaphore.this.acquireAsync(permits, subscribeFuture, result);
                            }
                        };
                        entry.addListener(listener);
                    }
                }
            }
        });
    }

    @Override
    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryAcquire(int permits) {
        return this.get(this.tryAcquireAsync(permits));
    }

    @Override
    public Future<Boolean> tryAcquireAsync() {
        return this.tryAcquireAsync(1);
    }

    @Override
    public Future<Boolean> tryAcquireAsync(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits amount can't be negative");
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value ~= false and tonumber(value) >= tonumber(ARGV[1])) then local val = redis.call('decrby', KEYS[1], ARGV[1]); return 1; end; return 0;", Collections.singletonList(this.getName()), permits);
    }

    @Override
    public Future<Boolean> tryAcquireAsync(long waitTime, TimeUnit unit) {
        return this.tryAcquireAsync(1, waitTime, unit);
    }

    @Override
    public boolean tryAcquire(int permits, long waitTime, TimeUnit unit) throws InterruptedException {
        if (this.tryAcquire(permits)) {
            return true;
        }
        long time = unit.toMillis(waitTime);
        Future<RedissonLockEntry> future = this.subscribe();
        if (!this.await(future, time, TimeUnit.MILLISECONDS)) {
            return false;
        }
        try {
            while (true) {
                if (this.tryAcquire(permits)) {
                    boolean bl = true;
                    return bl;
                }
                if (time <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                long current = System.currentTimeMillis();
                this.getEntry().getLatch().tryAcquire(permits, time, TimeUnit.MILLISECONDS);
                long elapsed = System.currentTimeMillis() - current;
                time -= elapsed;
            }
        }
        finally {
            this.unsubscribe(future);
        }
    }

    @Override
    public Future<Boolean> tryAcquireAsync(final int permits, long waitTime, TimeUnit unit) {
        final Promise<Boolean> result = this.newPromise();
        final AtomicLong time = new AtomicLong(unit.toMillis(waitTime));
        Future<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.setFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    result.setSuccess(true);
                    return;
                }
                final long current = System.currentTimeMillis();
                final AtomicReference futureRef = new AtomicReference();
                final Future subscribeFuture = RedissonSemaphore.this.subscribe();
                subscribeFuture.addListener(new FutureListener<RedissonLockEntry>(){

                    @Override
                    public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.setFailure(future.cause());
                            return;
                        }
                        if (futureRef.get() != null) {
                            ((ScheduledFuture)futureRef.get()).cancel(false);
                        }
                        long elapsed = System.currentTimeMillis() - current;
                        time.addAndGet(-elapsed);
                        if (time.get() < 0L) {
                            RedissonSemaphore.this.unsubscribe(subscribeFuture);
                            result.trySuccess(false);
                            return;
                        }
                        RedissonSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result);
                    }
                });
                if (!subscribeFuture.isDone()) {
                    ScheduledFuture<?> scheduledFuture = RedissonSemaphore.this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (!subscribeFuture.isDone()) {
                                result.trySuccess(false);
                            }
                        }
                    }, time.get(), TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
        return result;
    }

    private RedissonLockEntry getEntry() {
        return (RedissonLockEntry)this.semaphorePubSub.getEntry(this.getName());
    }

    private Future<RedissonLockEntry> subscribe() {
        return this.semaphorePubSub.subscribe(this.getName(), this.getChannelName(), this.commandExecutor.getConnectionManager());
    }

    private void unsubscribe(Future<RedissonLockEntry> future) {
        this.semaphorePubSub.unsubscribe((PubSubEntry)future.getNow(), this.getName(), this.getChannelName(), this.commandExecutor.getConnectionManager());
    }

    @Override
    public boolean tryAcquire(long time, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, time, unit);
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        this.get(this.releaseAsync(permits));
    }

    @Override
    public Future<Void> releaseAsync() {
        return this.releaseAsync(1);
    }

    @Override
    public Future<Void> releaseAsync(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits amount can't be negative");
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_VOID, "local value = redis.call('incrby', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], value); ", Arrays.asList(this.getName(), this.getChannelName()), permits);
    }

    @Override
    public int drainPermits() {
        Long res = (Long)this.commandExecutor.evalWrite(this.getName(), LongCodec.INSTANCE, RedisCommands.EVAL_LONG, "local value = redis.call('get', KEYS[1]); if (value == false or value == 0) then return 0; end; redis.call('set', KEYS[1], 0); return value;", Collections.singletonList(this.getName()), new Object[0]);
        return res.intValue();
    }

    @Override
    public int availablePermits() {
        Long res = (Long)this.commandExecutor.write(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.GET_LONG, this.getName());
        return res.intValue();
    }

    @Override
    public void setPermits(int permits) {
        this.get(this.setPermitsAsync(permits));
    }

    @Override
    public Future<Void> setPermitsAsync(int permits) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local value = redis.call('get', KEYS[1]); if (value == false or value == 0) then redis.call('set', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], ARGV[1]); end;", Arrays.asList(this.getName(), this.getChannelName()), permits);
    }
}

