/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBufUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.Redisson;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RBatch;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RBlockingQueueAsync;
import org.redisson.api.RRemoteService;
import org.redisson.api.RScript;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.command.CommandExecutor;
import org.redisson.executor.RemotePromise;
import org.redisson.remote.RRemoteAsync;
import org.redisson.remote.RRemoteServiceResponse;
import org.redisson.remote.RemoteServiceAck;
import org.redisson.remote.RemoteServiceAckTimeoutException;
import org.redisson.remote.RemoteServiceKey;
import org.redisson.remote.RemoteServiceMethod;
import org.redisson.remote.RemoteServiceRequest;
import org.redisson.remote.RemoteServiceResponse;
import org.redisson.remote.RemoteServiceTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonRemoteService
implements RRemoteService {
    private static final Logger log = LoggerFactory.getLogger(RedissonRemoteService.class);
    private final Map<RemoteServiceKey, RemoteServiceMethod> beans = PlatformDependent.newConcurrentHashMap();
    protected final Codec codec;
    protected final Redisson redisson;
    protected final String name;
    protected final CommandExecutor commandExecutor;

    public RedissonRemoteService(Redisson redisson, CommandExecutor commandExecutor) {
        this(redisson, "redisson_remote_service", commandExecutor);
    }

    public RedissonRemoteService(Redisson redisson, String name, CommandExecutor commandExecutor) {
        this(null, redisson, name, commandExecutor);
    }

    public RedissonRemoteService(Codec codec, Redisson redisson, CommandExecutor commandExecutor) {
        this(codec, redisson, "redisson_remote_service", commandExecutor);
    }

    public RedissonRemoteService(Codec codec, Redisson redisson, String name, CommandExecutor commandExecutor) {
        this.codec = codec;
        this.redisson = redisson;
        this.name = name;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public <T> void register(Class<T> remoteInterface, T object) {
        this.register(remoteInterface, object, 1);
    }

    @Override
    public <T> void register(Class<T> remoteInterface, T object, int workersAmount) {
        this.register(remoteInterface, object, workersAmount, null);
    }

    @Override
    public <T> void register(Class<T> remoteInterface, T object, int workersAmount, Executor executor) {
        if (workersAmount < 1) {
            throw new IllegalArgumentException("executorsAmount can't be lower than 1");
        }
        for (Method method : remoteInterface.getMethods()) {
            RemoteServiceMethod value = new RemoteServiceMethod(method, object);
            RemoteServiceKey key = new RemoteServiceKey(remoteInterface, method.getName());
            if (this.beans.put(key, value) == null) continue;
            return;
        }
        for (int i = 0; i < workersAmount; ++i) {
            String requestQueueName = this.getRequestQueueName(remoteInterface);
            RBlockingQueue<RemoteServiceRequest> requestQueue = this.redisson.getBlockingQueue(requestQueueName, this.getCodec());
            this.subscribe(remoteInterface, requestQueue, executor);
        }
    }

    private String getAckName(Class<?> remoteInterface, String requestId) {
        return "{" + this.name + ":" + remoteInterface.getName() + "}:" + requestId + ":ack";
    }

    private String getResponseQueueName(Class<?> remoteInterface, String requestId) {
        return "{" + this.name + ":" + remoteInterface.getName() + "}:" + requestId;
    }

    private String getRequestQueueName(Class<?> remoteInterface) {
        return "{" + this.name + ":" + remoteInterface.getName() + "}";
    }

    private Codec getCodec() {
        if (this.codec != null) {
            return this.codec;
        }
        return this.redisson.getConfig().getCodec();
    }

    protected byte[] encode(Object obj) {
        try {
            return this.getCodec().getValueEncoder().encode(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private <T> void subscribe(final Class<T> remoteInterface, final RBlockingQueue<RemoteServiceRequest> requestQueue, final Executor executor) {
        Future<RemoteServiceRequest> take = requestQueue.takeAsync();
        take.addListener(new FutureListener<RemoteServiceRequest>(){

            @Override
            public void operationComplete(Future<RemoteServiceRequest> future) throws Exception {
                if (!future.isSuccess()) {
                    if (future.cause() instanceof RedissonShutdownException) {
                        return;
                    }
                    RedissonRemoteService.this.subscribe(remoteInterface, requestQueue, executor);
                    return;
                }
                final RemoteServiceRequest request = future.getNow();
                if (request.getOptions().isAckExpected() && System.currentTimeMillis() - request.getDate() > request.getOptions().getAckTimeoutInMillis()) {
                    log.debug("request: {} has been skipped due to ackTimeout");
                    RedissonRemoteService.this.subscribe(remoteInterface, requestQueue, executor);
                    return;
                }
                final RemoteServiceMethod method = (RemoteServiceMethod)RedissonRemoteService.this.beans.get(new RemoteServiceKey(remoteInterface, request.getMethodName()));
                final String responseName = RedissonRemoteService.this.getResponseQueueName(remoteInterface, request.getRequestId());
                if (request.getOptions().isAckExpected()) {
                    String ackName = RedissonRemoteService.this.getAckName(remoteInterface, request.getRequestId());
                    Future ackClientsFuture = RedissonRemoteService.this.redisson.getScript().evalAsync(responseName, RScript.Mode.READ_WRITE, LongCodec.INSTANCE, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[2]);redis.call('rpush', KEYS[2], ARGV[1]);redis.call('pexpire', KEYS[2], ARGV[2]);return 1;end;return 0;", RScript.ReturnType.BOOLEAN, Arrays.asList(ackName, responseName), RedissonRemoteService.this.encode(new RemoteServiceAck()), request.getOptions().getAckTimeoutInMillis());
                    ackClientsFuture.addListener(new FutureListener<Boolean>(){

                        @Override
                        public void operationComplete(Future<Boolean> future) throws Exception {
                            if (!future.isSuccess()) {
                                log.error("Can't send ack for request: " + request, future.cause());
                                if (future.cause() instanceof RedissonShutdownException) {
                                    return;
                                }
                                RedissonRemoteService.this.subscribe(remoteInterface, requestQueue, executor);
                                return;
                            }
                            if (!future.getNow().booleanValue()) {
                                RedissonRemoteService.this.subscribe(remoteInterface, requestQueue, executor);
                                return;
                            }
                            if (executor != null) {
                                executor.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        RedissonRemoteService.this.invokeMethod(remoteInterface, requestQueue, request, method, responseName, executor);
                                    }
                                });
                            } else {
                                RedissonRemoteService.this.invokeMethod(remoteInterface, requestQueue, request, method, responseName, executor);
                            }
                        }
                    });
                } else if (executor != null) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            RedissonRemoteService.this.invokeMethod(remoteInterface, requestQueue, request, method, responseName, executor);
                        }
                    });
                } else {
                    RedissonRemoteService.this.invokeMethod(remoteInterface, requestQueue, request, method, responseName, executor);
                }
            }
        });
    }

    private <T> void invokeMethod(final Class<T> remoteInterface, final RBlockingQueue<RemoteServiceRequest> requestQueue, final RemoteServiceRequest request, RemoteServiceMethod method, String responseName, final Executor executor) {
        final AtomicReference<RemoteServiceResponse> responseHolder = new AtomicReference<RemoteServiceResponse>();
        try {
            Object result = method.getMethod().invoke(method.getBean(), request.getArgs());
            RemoteServiceResponse response = new RemoteServiceResponse(result);
            responseHolder.set(response);
        }
        catch (Exception e) {
            RemoteServiceResponse response = new RemoteServiceResponse(e.getCause());
            responseHolder.set(response);
            log.error("Can't execute: " + request, e);
        }
        if (request.getOptions().isResultExpected()) {
            Future<List<?>> clientsFuture = this.send(request.getOptions().getExecutionTimeoutInMillis(), responseName, (RRemoteServiceResponse)responseHolder.get());
            clientsFuture.addListener(new FutureListener<List<?>>(){

                @Override
                public void operationComplete(Future<List<?>> future) throws Exception {
                    if (!future.isSuccess()) {
                        log.error("Can't send response: " + responseHolder.get() + " for request: " + request, future.cause());
                        if (future.cause() instanceof RedissonShutdownException) {
                            return;
                        }
                    }
                    RedissonRemoteService.this.subscribe(remoteInterface, requestQueue, executor);
                }
            });
        } else {
            this.subscribe(remoteInterface, requestQueue, executor);
        }
    }

    @Override
    public <T> T get(Class<T> remoteInterface) {
        return this.get(remoteInterface, RemoteInvocationOptions.defaults());
    }

    @Override
    public <T> T get(Class<T> remoteInterface, long executionTimeout, TimeUnit executionTimeUnit) {
        return this.get(remoteInterface, RemoteInvocationOptions.defaults().expectResultWithin(executionTimeout, executionTimeUnit));
    }

    @Override
    public <T> T get(Class<T> remoteInterface, long executionTimeout, TimeUnit executionTimeUnit, long ackTimeout, TimeUnit ackTimeUnit) {
        return this.get(remoteInterface, RemoteInvocationOptions.defaults().expectAckWithin(ackTimeout, ackTimeUnit).expectResultWithin(executionTimeout, executionTimeUnit));
    }

    @Override
    public <T> T get(Class<T> remoteInterface, RemoteInvocationOptions options) {
        for (Annotation annotation : remoteInterface.getAnnotations()) {
            if (annotation.annotationType() != RRemoteAsync.class) continue;
            Class<?> syncInterface = ((RRemoteAsync)annotation).value();
            for (Method m : remoteInterface.getMethods()) {
                try {
                    syncInterface.getMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Method '" + m.getName() + "' with params '" + Arrays.toString(m.getParameterTypes()) + "' isn't defined in " + syncInterface);
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException(e);
                }
                if (m.getReturnType().getClass().isInstance(Future.class)) continue;
                throw new IllegalArgumentException(m.getReturnType().getClass() + " isn't allowed as return type");
            }
            return this.async(remoteInterface, options, syncInterface);
        }
        return this.sync(remoteInterface, options);
    }

    private <T> T async(Class<T> remoteInterface, RemoteInvocationOptions options, final Class<?> syncInterface) {
        final RemoteInvocationOptions optionsCopy = new RemoteInvocationOptions(options);
        final String toString = this.getClass().getSimpleName() + "-" + remoteInterface.getSimpleName() + "-proxy-" + this.generateRequestId();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("toString")) {
                    return toString;
                }
                if (method.getName().equals("equals")) {
                    return proxy == args[0];
                }
                if (method.getName().equals("hashCode")) {
                    return toString.hashCode();
                }
                if (!(optionsCopy.isResultExpected() || method.getReturnType().equals(Void.class) || method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(Future.class))) {
                    throw new IllegalArgumentException("The noResult option only supports void return value");
                }
                String requestId = RedissonRemoteService.this.generateRequestId();
                final String requestQueueName = RedissonRemoteService.this.getRequestQueueName(syncInterface);
                final String responseName = RedissonRemoteService.this.getResponseQueueName(syncInterface, requestId);
                final String ackName = RedissonRemoteService.this.getAckName(syncInterface, requestId);
                final RBlockingQueue<RemoteServiceRequest> requestQueue = RedissonRemoteService.this.redisson.getBlockingQueue(requestQueueName, RedissonRemoteService.this.getCodec());
                final RemoteServiceRequest request = new RemoteServiceRequest(requestId, method.getName(), args, optionsCopy, System.currentTimeMillis());
                final RemotePromise<Object> result = new RemotePromise<Object>(ImmediateEventExecutor.INSTANCE.newPromise()){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        if (optionsCopy.isAckExpected()) {
                            Future future = RedissonRemoteService.this.redisson.getScript().evalAsync(responseName, RScript.Mode.READ_WRITE, LongCodec.INSTANCE, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[2]);redis.call('lrem', KEYS[3], 1, ARGV[1]);redis.call('pexpire', KEYS[2], ARGV[2]);return 1;end;return 0;", RScript.ReturnType.BOOLEAN, Arrays.asList(ackName, responseName, requestQueueName), RedissonRemoteService.this.encode(request), request.getOptions().getAckTimeoutInMillis());
                            return (Boolean)RedissonRemoteService.this.commandExecutor.get(future);
                        }
                        return requestQueue.remove(request);
                    }
                };
                Future<Boolean> addFuture = RedissonRemoteService.this.addAsync(requestQueue, request, result);
                addFuture.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

                    @Override
                    public void operationComplete(Future<Boolean> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        final RBlockingQueue responseQueue = optionsCopy.isAckExpected() || optionsCopy.isResultExpected() ? RedissonRemoteService.this.redisson.getBlockingQueue(responseName, RedissonRemoteService.this.getCodec()) : null;
                        if (optionsCopy.isAckExpected()) {
                            Future<RemoteServiceAck> ackFuture = responseQueue.pollAsync(optionsCopy.getAckTimeoutInMillis(), TimeUnit.MILLISECONDS);
                            ackFuture.addListener(new FutureListener<RemoteServiceAck>(){

                                @Override
                                public void operationComplete(Future<RemoteServiceAck> future) throws Exception {
                                    if (!future.isSuccess()) {
                                        result.tryFailure(future.cause());
                                        return;
                                    }
                                    RemoteServiceAck ack = future.getNow();
                                    if (ack == null) {
                                        Future ackFutureAttempt = RedissonRemoteService.this.tryPollAckAgainAsync(optionsCopy, responseQueue, ackName);
                                        ackFutureAttempt.addListener(new FutureListener<RemoteServiceAck>(){

                                            @Override
                                            public void operationComplete(Future<RemoteServiceAck> future) throws Exception {
                                                if (!future.isSuccess()) {
                                                    result.tryFailure(future.cause());
                                                    return;
                                                }
                                                if (future.getNow() == null) {
                                                    RemoteServiceAckTimeoutException ex = new RemoteServiceAckTimeoutException("No ACK response after " + optionsCopy.getAckTimeoutInMillis() + "ms for request: " + request);
                                                    result.tryFailure(ex);
                                                    return;
                                                }
                                                RedissonRemoteService.this.invokeAsync(optionsCopy, result, request, responseQueue, ackName);
                                            }
                                        });
                                    } else {
                                        RedissonRemoteService.this.invokeAsync(optionsCopy, result, request, responseQueue);
                                    }
                                }
                            });
                        } else {
                            RedissonRemoteService.this.invokeAsync(optionsCopy, result, request, responseQueue);
                        }
                    }
                });
                return result;
            }
        };
        return (T)Proxy.newProxyInstance(remoteInterface.getClassLoader(), new Class[]{remoteInterface}, handler);
    }

    private void invokeAsync(final RemoteInvocationOptions optionsCopy, final Promise<Object> result, final RemoteServiceRequest request, final RBlockingQueue<? extends RRemoteServiceResponse> responseQueue, String ackName) {
        Future<Boolean> deleteFuture = this.redisson.getBucket(ackName).deleteAsync();
        deleteFuture.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                RedissonRemoteService.this.invokeAsync(optionsCopy, result, request, responseQueue);
            }
        });
    }

    private void invokeAsync(final RemoteInvocationOptions optionsCopy, final Promise<Object> result, final RemoteServiceRequest request, RBlockingQueue<? extends RRemoteServiceResponse> responseQueue) {
        if (optionsCopy.isResultExpected()) {
            Future<RemoteServiceResponse> responseFuture = responseQueue.pollAsync(optionsCopy.getExecutionTimeoutInMillis(), TimeUnit.MILLISECONDS);
            responseFuture.addListener(new FutureListener<RemoteServiceResponse>(){

                @Override
                public void operationComplete(Future<RemoteServiceResponse> future) throws Exception {
                    if (!future.isSuccess()) {
                        result.tryFailure(future.cause());
                        return;
                    }
                    if (future.getNow() == null) {
                        RemoteServiceTimeoutException e = new RemoteServiceTimeoutException("No response after " + optionsCopy.getExecutionTimeoutInMillis() + "ms for request: " + request);
                        result.tryFailure(e);
                        return;
                    }
                    if (future.getNow().getError() != null) {
                        result.tryFailure(future.getNow().getError());
                        return;
                    }
                    result.trySuccess(future.getNow().getResult());
                }
            });
        }
    }

    private <T> T sync(final Class<T> remoteInterface, RemoteInvocationOptions options) {
        String interfaceName = remoteInterface.getName();
        final RemoteInvocationOptions optionsCopy = new RemoteInvocationOptions(options);
        final String toString = this.getClass().getSimpleName() + "-" + remoteInterface.getSimpleName() + "-proxy-" + this.generateRequestId();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("toString")) {
                    return toString;
                }
                if (method.getName().equals("equals")) {
                    return proxy == args[0];
                }
                if (method.getName().equals("hashCode")) {
                    return toString.hashCode();
                }
                if (!(optionsCopy.isResultExpected() || method.getReturnType().equals(Void.class) || method.getReturnType().equals(Void.TYPE))) {
                    throw new IllegalArgumentException("The noResult option only supports void return value");
                }
                String requestId = RedissonRemoteService.this.generateRequestId();
                String requestQueueName = RedissonRemoteService.this.getRequestQueueName(remoteInterface);
                RBlockingQueue requestQueue = RedissonRemoteService.this.redisson.getBlockingQueue(requestQueueName, RedissonRemoteService.this.getCodec());
                RemoteServiceRequest request = new RemoteServiceRequest(requestId, method.getName(), args, optionsCopy, System.currentTimeMillis());
                requestQueue.add(request);
                RBlockingQueue responseQueue = null;
                if (optionsCopy.isAckExpected() || optionsCopy.isResultExpected()) {
                    String responseName = RedissonRemoteService.this.getResponseQueueName(remoteInterface, requestId);
                    responseQueue = RedissonRemoteService.this.redisson.getBlockingQueue(responseName, RedissonRemoteService.this.getCodec());
                }
                if (optionsCopy.isAckExpected()) {
                    String ackName = RedissonRemoteService.this.getAckName(remoteInterface, requestId);
                    RemoteServiceAck ack = (RemoteServiceAck)responseQueue.poll(optionsCopy.getAckTimeoutInMillis(), TimeUnit.MILLISECONDS);
                    if (ack == null && (ack = RedissonRemoteService.this.tryPollAckAgain(optionsCopy, responseQueue, ackName)) == null) {
                        throw new RemoteServiceAckTimeoutException("No ACK response after " + optionsCopy.getAckTimeoutInMillis() + "ms for request: " + request);
                    }
                    RedissonRemoteService.this.redisson.getBucket(ackName).delete();
                }
                if (optionsCopy.isResultExpected()) {
                    RemoteServiceResponse response = (RemoteServiceResponse)responseQueue.poll(optionsCopy.getExecutionTimeoutInMillis(), TimeUnit.MILLISECONDS);
                    if (response == null) {
                        throw new RemoteServiceTimeoutException("No response after " + optionsCopy.getExecutionTimeoutInMillis() + "ms for request: " + request);
                    }
                    if (response.getError() != null) {
                        throw response.getError();
                    }
                    return response.getResult();
                }
                return null;
            }
        };
        return (T)Proxy.newProxyInstance(remoteInterface.getClassLoader(), new Class[]{remoteInterface}, handler);
    }

    private RemoteServiceAck tryPollAckAgain(RemoteInvocationOptions optionsCopy, RBlockingQueue<? extends RRemoteServiceResponse> responseQueue, String ackName) throws InterruptedException {
        Future ackClientsFuture = this.redisson.getScript().evalAsync(ackName, RScript.Mode.READ_WRITE, LongCodec.INSTANCE, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[1]);return 0;end;redis.call('del', KEYS[1]);return 1;", RScript.ReturnType.BOOLEAN, Arrays.asList(ackName), optionsCopy.getAckTimeoutInMillis());
        ackClientsFuture.sync();
        if (((Boolean)ackClientsFuture.getNow()).booleanValue()) {
            return (RemoteServiceAck)responseQueue.poll();
        }
        return null;
    }

    private Future<RemoteServiceAck> tryPollAckAgainAsync(RemoteInvocationOptions optionsCopy, final RBlockingQueue<? extends RRemoteServiceResponse> responseQueue, String ackName) throws InterruptedException {
        final Promise<RemoteServiceAck> promise = ImmediateEventExecutor.INSTANCE.newPromise();
        Future ackClientsFuture = this.redisson.getScript().evalAsync(ackName, RScript.Mode.READ_WRITE, LongCodec.INSTANCE, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[1]);return 0;end;redis.call('del', KEYS[1]);return 1;", RScript.ReturnType.BOOLEAN, Arrays.asList(ackName), optionsCopy.getAckTimeoutInMillis());
        ackClientsFuture.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.setFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    Future<RemoteServiceAck> pollFuture = responseQueue.pollAsync();
                    pollFuture.addListener(new FutureListener<RemoteServiceAck>(){

                        @Override
                        public void operationComplete(Future<RemoteServiceAck> future) throws Exception {
                            if (!future.isSuccess()) {
                                promise.setFailure(future.cause());
                                return;
                            }
                            promise.setSuccess(future.getNow());
                        }
                    });
                } else {
                    promise.setSuccess(null);
                }
            }
        });
        return promise;
    }

    private String generateRequestId() {
        byte[] id = new byte[16];
        ThreadLocalRandom.current().nextBytes(id);
        return ByteBufUtil.hexDump(id);
    }

    private <T extends RRemoteServiceResponse> Future<List<?>> send(long timeout, String responseName, T response) {
        RBatch batch = this.redisson.createBatch();
        RBlockingQueueAsync<T> queue = batch.getBlockingQueue(responseName, this.getCodec());
        queue.putAsync(response);
        queue.expireAsync(timeout, TimeUnit.MILLISECONDS);
        return batch.executeAsync();
    }

    protected Future<Boolean> addAsync(RBlockingQueue<RemoteServiceRequest> requestQueue, RemoteServiceRequest request, RemotePromise<Object> result) {
        Future<Boolean> future = requestQueue.addAsync(request);
        result.setAddFuture(future);
        return future;
    }
}

