/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.liveobject.annotation.REntity;

public class RedissonReference {
    private String type;
    private String keyName;
    private String codec;

    public RedissonReference() {
    }

    public RedissonReference(Class type, String keyName) {
        this(type, keyName, null);
    }

    public RedissonReference(Class type, String keyName, Codec codec) {
        if (!type.isAnnotationPresent(REntity.class) && !RObject.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Class reference has to be a type of either RObject or RLiveObject");
        }
        this.type = type.getName();
        this.keyName = keyName;
        this.codec = codec != null ? codec.getClass().getCanonicalName() : null;
    }

    public boolean isDefaultCodec() {
        return this.codec == null;
    }

    public Class<?> getType() throws Exception {
        return Class.forName(this.type);
    }

    public String getTypeName() {
        return this.type;
    }

    public void setType(Class<?> type) {
        if (!type.isAnnotationPresent(REntity.class) && !RObject.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Class reference has to be a type of either RObject or RLiveObject");
        }
        this.type = type.getCanonicalName();
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Class<? extends Codec> getCodecType() throws Exception {
        return this.codec == null ? null : Class.forName(this.codec);
    }

    public String getCodecName() {
        return this.codec;
    }

    public void setCodecType(Class<? extends Codec> codec) {
        this.codec = codec.getCanonicalName();
    }
}

