/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.NoSuchElementException;
import org.redisson.RedissonList;
import org.redisson.api.RQueue;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonQueue<V>
extends RedissonList<V>
implements RQueue<V> {
    protected RedissonQueue(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    protected RedissonQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    @Override
    public boolean offer(V e) {
        return this.get(this.offerAsync(e));
    }

    @Override
    public Future<Boolean> offerAsync(V e) {
        return this.addAsync(e);
    }

    @Override
    public V getFirst() {
        Object value = this.getValue(0);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V removeFirst() {
        V value = this.poll();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V remove() {
        return this.removeFirst();
    }

    @Override
    public Future<V> pollAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LPOP, this.getName());
    }

    @Override
    public V poll() {
        return this.get(this.pollAsync());
    }

    @Override
    public V element() {
        return this.getFirst();
    }

    @Override
    public Future<V> peekAsync() {
        return this.getAsync(0);
    }

    @Override
    public V peek() {
        return this.getValue(0);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName) {
        return this.get(this.pollLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public Future<V> pollLastAndOfferFirstToAsync(String queueName) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.RPOPLPUSH, this.getName(), queueName);
    }

    @Override
    public V pollLastAndOfferFirstTo(RQueue<V> queue) {
        return this.pollLastAndOfferFirstTo(queue.getName());
    }
}

