/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.Collections;
import java.util.List;
import org.redisson.PubSubPatternMessageListener;
import org.redisson.PubSubPatternStatusListener;
import org.redisson.api.PatternMessageListener;
import org.redisson.api.PatternStatusListener;
import org.redisson.api.RPatternTopic;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandExecutor;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.pubsub.AsyncSemaphore;

public class RedissonPatternTopic<M>
implements RPatternTopic<M> {
    final CommandExecutor commandExecutor;
    private final String name;
    private final Codec codec;

    protected RedissonPatternTopic(CommandExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    protected RedissonPatternTopic(Codec codec, CommandExecutor commandExecutor, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.codec = codec;
    }

    @Override
    public int addListener(PatternStatusListener listener) {
        return this.addListener(new PubSubPatternStatusListener(listener, this.name));
    }

    @Override
    public int addListener(PatternMessageListener<M> listener) {
        PubSubPatternMessageListener<M> pubSubListener = new PubSubPatternMessageListener<M>(listener, this.name);
        return this.addListener(pubSubListener);
    }

    @Override
    private int addListener(RedisPubSubListener<?> pubSubListener) {
        Future<PubSubConnectionEntry> future = this.commandExecutor.getConnectionManager().psubscribe(this.name, this.codec, pubSubListener);
        future.syncUninterruptibly();
        return System.identityHashCode(pubSubListener);
    }

    @Override
    public void removeListener(int listenerId) {
        AsyncSemaphore semaphore = this.commandExecutor.getConnectionManager().getSemaphore(this.name);
        semaphore.acquireUninterruptibly();
        PubSubConnectionEntry entry = this.commandExecutor.getConnectionManager().getPubSubEntry(this.name);
        if (entry == null) {
            semaphore.release();
            return;
        }
        entry.removeListener(this.name, listenerId);
        if (!entry.hasListeners(this.name)) {
            this.commandExecutor.getConnectionManager().punsubscribe(this.name, semaphore);
        } else {
            semaphore.release();
        }
    }

    @Override
    public List<String> getPatternNames() {
        return Collections.singletonList(this.name);
    }
}

