/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

abstract class RedissonObject
implements RObject {
    final CommandAsyncExecutor commandExecutor;
    private final String name;
    final Codec codec;

    public RedissonObject(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        this.codec = codec;
        this.name = name;
        this.commandExecutor = commandExecutor;
    }

    public RedissonObject(CommandAsyncExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    protected boolean await(Future<?> future, long timeout, TimeUnit timeoutUnit) throws InterruptedException {
        return this.commandExecutor.await(future, timeout, timeoutUnit);
    }

    protected <V> V get(Future<V> future) {
        return this.commandExecutor.get(future);
    }

    protected <V> Promise<V> newPromise() {
        return this.commandExecutor.getConnectionManager().newPromise();
    }

    protected <V> Future<V> newSucceededFuture(V result) {
        return this.commandExecutor.getConnectionManager().newSucceededFuture(result);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void rename(String newName) {
        this.get(this.renameAsync(newName));
    }

    @Override
    public Future<Void> renameAsync(String newName) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.RENAME, this.getName(), newName);
    }

    @Override
    public void migrate(String host, int port, int database) {
        this.get(this.migrateAsync(host, port, database));
    }

    @Override
    public Future<Void> migrateAsync(String host, int port, int database) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.MIGRATE, host, port, this.getName(), database);
    }

    @Override
    public boolean move(int database) {
        return this.get(this.moveAsync(database));
    }

    @Override
    public Future<Boolean> moveAsync(int database) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.MOVE, this.getName(), database);
    }

    @Override
    public boolean renamenx(String newName) {
        return this.get(this.renamenxAsync(newName));
    }

    @Override
    public Future<Boolean> renamenxAsync(String newName) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.RENAMENX, this.getName(), newName);
    }

    @Override
    public boolean delete() {
        return this.get(this.deleteAsync());
    }

    @Override
    public Future<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_BOOL, this.getName());
    }

    @Override
    public boolean isExists() {
        return this.get(this.isExistsAsync());
    }

    @Override
    public Future<Boolean> isExistsAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.EXISTS, this.getName());
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    protected byte[] encode(Object value) {
        try {
            return this.codec.getValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

