/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentMap;
import jodd.bean.BeanCopy;
import jodd.bean.BeanUtil;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.FieldProxy;
import net.bytebuddy.matcher.ElementMatchers;
import org.redisson.RedissonClient;
import org.redisson.api.RLiveObject;
import org.redisson.api.RLiveObjectService;
import org.redisson.api.RObject;
import org.redisson.liveobject.LiveObjectTemplate;
import org.redisson.liveobject.annotation.REntity;
import org.redisson.liveobject.annotation.RId;
import org.redisson.liveobject.core.AccessorInterceptor;
import org.redisson.liveobject.core.LiveObjectInterceptor;
import org.redisson.liveobject.misc.Introspectior;
import org.redisson.liveobject.provider.CodecProvider;
import org.redisson.liveobject.provider.ResolverProvider;
import org.redisson.liveobject.resolver.Resolver;

public class RedissonLiveObjectService
implements RLiveObjectService {
    private final ConcurrentMap<Class<?>, Class<?>> classCache;
    private final RedissonClient redisson;
    private final CodecProvider codecProvider;
    private final ResolverProvider resolverProvider;

    public RedissonLiveObjectService(RedissonClient redisson, ConcurrentMap<Class<?>, Class<?>> classCache, CodecProvider codecProvider, ResolverProvider resolverProvider) {
        this.redisson = redisson;
        this.classCache = classCache;
        this.codecProvider = codecProvider;
        this.resolverProvider = resolverProvider;
    }

    @Override
    public <T> T create(Class<T> entityClass) {
        try {
            Class<T> proxyClass = this.getProxyClass(entityClass);
            String idFieldName = this.getRIdFieldName(entityClass);
            RId annotation = entityClass.getDeclaredField(idFieldName).getAnnotation(RId.class);
            Resolver resolver = this.resolverProvider.getResolver(entityClass, annotation.generator(), annotation);
            Object id = resolver.resolve(entityClass, annotation, idFieldName, this.redisson);
            T proxied = this.instantiateLiveObject(proxyClass, id);
            return this.asLiveObject(proxied).isExists() ? null : (T)proxied;
        }
        catch (Exception ex) {
            this.unregisterClass(entityClass);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public <T, K> T get(Class<T> entityClass, K id) {
        try {
            T proxied = this.instantiateLiveObject(this.getProxyClass(entityClass), id);
            return (T)(this.asLiveObject(proxied).isExists() ? proxied : null);
        }
        catch (Exception ex) {
            this.unregisterClass(entityClass);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public <T, K> T getOrCreate(Class<T> entityClass, K id) {
        try {
            return this.instantiateLiveObject(this.getProxyClass(entityClass), id);
        }
        catch (Exception ex) {
            this.unregisterClass(entityClass);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public <T> T attach(T detachedObject) {
        this.validateDetached(detachedObject);
        Class<?> entityClass = detachedObject.getClass();
        try {
            Class<?> proxyClass = this.getProxyClass(entityClass);
            return (T)this.instantiateLiveObject(proxyClass, BeanUtil.pojo.getSimpleProperty(detachedObject, this.getRIdFieldName(detachedObject.getClass())));
        }
        catch (Exception ex) {
            this.unregisterClass(entityClass);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public <T> T merge(T detachedObject) {
        T attachedObject = this.attach(detachedObject);
        this.copy(detachedObject, attachedObject);
        return attachedObject;
    }

    @Override
    public <T> T persist(T detachedObject) {
        T attachedObject = this.attach(detachedObject);
        if (!this.asLiveObject(attachedObject).isExists()) {
            this.copy(detachedObject, attachedObject);
            return attachedObject;
        }
        throw new IllegalStateException("This REntity already exists.");
    }

    @Override
    public <T> T detach(T attachedObject) {
        this.validateAttached(attachedObject);
        try {
            Object detached = this.instantiateDetachedObject(attachedObject.getClass().getSuperclass(), this.asLiveObject(attachedObject).getLiveObjectId());
            BeanCopy.beans(attachedObject, detached).declared(false, true).copy();
            return (T)detached;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public <T> void delete(T attachedObject) {
        this.validateAttached(attachedObject);
        this.asLiveObject(attachedObject).delete();
    }

    @Override
    public <T, K> void delete(Class<T> entityClass, K id) {
        this.asLiveObject(this.get(entityClass, id)).delete();
    }

    @Override
    public <T> RLiveObject asLiveObject(T instance) {
        return (RLiveObject)instance;
    }

    @Override
    public <T> boolean isLiveObject(T instance) {
        return instance instanceof RLiveObject;
    }

    @Override
    public <T> boolean isExists(T instance) {
        return instance instanceof RLiveObject && this.asLiveObject(instance).isExists();
    }

    @Override
    public void registerClass(Class cls) {
        if (!this.classCache.containsKey(cls)) {
            this.validateClass(cls);
            this.registerClassInternal(cls);
        }
    }

    @Override
    public void unregisterClass(Class cls) {
        this.classCache.remove(cls.isAssignableFrom(RLiveObject.class) ? cls.getSuperclass() : cls);
    }

    @Override
    public boolean isClassRegistered(Class cls) {
        return this.classCache.containsKey(cls) || this.classCache.containsValue(cls);
    }

    private <T> void copy(T detachedObject, T attachedObject) {
        String idFieldName = this.getRIdFieldName(detachedObject.getClass());
        ((BeanCopy)((BeanCopy)BeanCopy.beans(detachedObject, attachedObject).ignoreNulls(true)).exclude(idFieldName)).copy();
    }

    private String getRIdFieldName(Class cls) {
        return ((FieldDescription.InDefinedShape)Introspectior.getFieldsWithAnnotation(cls, RId.class).getOnly()).getName();
    }

    private <T, K> T instantiateLiveObject(Class<T> proxyClass, K id) throws Exception {
        T instance = this.instantiate(proxyClass, id);
        this.asLiveObject(instance).setLiveObjectId(id);
        return instance;
    }

    private <T, K> T instantiateDetachedObject(Class<T> cls, K id) throws Exception {
        T instance = this.instantiate(cls, id);
        if (BeanUtil.pojo.getSimpleProperty(instance, this.getRIdFieldName(cls)) == null) {
            BeanUtil.pojo.setSimpleProperty(instance, this.getRIdFieldName(cls), id);
        }
        return instance;
    }

    private <T, K> T instantiate(Class<T> cls, K id) throws Exception {
        try {
            return cls.newInstance();
        }
        catch (Exception exception) {
            for (Constructor<?> ctor : this.classCache.containsKey(cls) ? cls.getConstructors() : cls.getDeclaredConstructors()) {
                if (ctor.getParameterTypes().length != 1 || !ctor.getParameterTypes()[0].isAssignableFrom(id.getClass())) continue;
                return (T)ctor.newInstance(id);
            }
            throw new NoSuchMethodException("Unable to find constructor matching only the RId field type [" + id.getClass().getCanonicalName() + "].");
        }
    }

    private <T> Class<? extends T> getProxyClass(Class<T> entityClass) {
        this.registerClass(entityClass);
        return (Class)this.classCache.get(entityClass);
    }

    private <T> void validateClass(Class<T> entityClass) {
        if (entityClass.isAnonymousClass() || entityClass.isLocalClass()) {
            throw new IllegalArgumentException(entityClass.getName() + " is not publically accessable.");
        }
        if (!entityClass.isAnnotationPresent(REntity.class)) {
            throw new IllegalArgumentException("REntity annotation is missing from class type declaration.");
        }
        FieldList<FieldDescription.InDefinedShape> fieldsWithRIdAnnotation = Introspectior.getFieldsWithAnnotation(entityClass, RId.class);
        if (fieldsWithRIdAnnotation.size() == 0) {
            throw new IllegalArgumentException("RId annotation is missing from class field declaration.");
        }
        if (fieldsWithRIdAnnotation.size() > 1) {
            throw new IllegalArgumentException("Only one field with RId annotation is allowed in class field declaration.");
        }
        FieldDescription.InDefinedShape idFieldDescription = (FieldDescription.InDefinedShape)fieldsWithRIdAnnotation.getOnly();
        String idFieldName = idFieldDescription.getName();
        Field idField = null;
        try {
            idField = entityClass.getDeclaredField(idFieldName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (idField.getType().isAnnotationPresent(REntity.class)) {
            throw new IllegalArgumentException("Field with RId annotation cannot be a type of which class is annotated with REntity.");
        }
        if (idField.getType().isAssignableFrom(RObject.class)) {
            throw new IllegalArgumentException("Field with RId annotation cannot be a type of RObject");
        }
    }

    private <T> void validateDetached(T detachedObject) {
        if (detachedObject instanceof RLiveObject) {
            throw new IllegalArgumentException("The object supplied is already a RLiveObject");
        }
    }

    private <T> void validateAttached(T attachedObject) {
        if (!(attachedObject instanceof RLiveObject)) {
            throw new IllegalArgumentException("The object supplied is must be a RLiveObject");
        }
    }

    private <T> void registerClassInternal(Class<T> entityClass) {
        DynamicType.Builder<T> builder = new ByteBuddy().subclass(entityClass);
        for (FieldDescription.InDefinedShape field : Introspectior.getTypeDescription(LiveObjectTemplate.class).getDeclaredFields()) {
            builder = builder.define(field);
        }
        Class proxied = builder.method(ElementMatchers.isDeclaredBy(Introspectior.getTypeDescription(RLiveObject.class)).and(ElementMatchers.isGetter().or(ElementMatchers.isSetter()).or(ElementMatchers.named("isPhantom")).or(ElementMatchers.named("delete")))).intercept(MethodDelegation.to(new LiveObjectInterceptor(this.redisson, this.codecProvider, entityClass, this.getRIdFieldName(entityClass))).appendParameterBinder(FieldProxy.Binder.install(LiveObjectInterceptor.Getter.class, LiveObjectInterceptor.Setter.class))).implement(new Type[]{RLiveObject.class}).method(ElementMatchers.not(ElementMatchers.isDeclaredBy(Object.class)).and(ElementMatchers.not(ElementMatchers.isDeclaredBy(RLiveObject.class))).and(ElementMatchers.isGetter().or(ElementMatchers.isSetter())).and(ElementMatchers.isPublic())).intercept(MethodDelegation.to(new AccessorInterceptor(this.redisson, this.codecProvider, this.resolverProvider))).make().load(this.getClass().getClassLoader(), ClassLoadingStrategy.Default.WRAPPER).getLoaded();
        this.classCache.putIfAbsent(entityClass, proxied);
    }
}

