/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Collection;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.api.RLexSortedSet;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonLexSortedSet
extends RedissonScoredSortedSet<String>
implements RLexSortedSet {
    public RedissonLexSortedSet(CommandAsyncExecutor commandExecutor, String name) {
        super(StringCodec.INSTANCE, commandExecutor, name);
    }

    @Override
    public int removeRange(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        return this.removeRangeByLex(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public int removeRangeByLex(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        return this.get(this.removeRangeAsync(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public int removeRangeHead(String toElement, boolean toInclusive) {
        return this.removeRangeHeadByLex(toElement, toInclusive);
    }

    @Override
    public int removeRangeHeadByLex(String toElement, boolean toInclusive) {
        return this.get(this.removeRangeHeadAsync(toElement, toInclusive));
    }

    @Override
    public Future<Integer> removeRangeHeadAsync(String toElement, boolean toInclusive) {
        return this.removeRangeHeadByLexAsync(toElement, toInclusive);
    }

    @Override
    public Future<Integer> removeRangeHeadByLexAsync(String toElement, boolean toInclusive) {
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZREMRANGEBYLEX, this.getName(), "-", toValue);
    }

    @Override
    public int removeRangeTail(String fromElement, boolean fromInclusive) {
        return this.removeRangeTailByLex(fromElement, fromInclusive);
    }

    @Override
    public int removeRangeTailByLex(String fromElement, boolean fromInclusive) {
        return this.get(this.removeRangeTailAsync(fromElement, fromInclusive));
    }

    @Override
    public Future<Integer> removeRangeTailAsync(String fromElement, boolean fromInclusive) {
        return this.removeRangeTailByLexAsync(fromElement, fromInclusive);
    }

    @Override
    public Future<Integer> removeRangeTailByLexAsync(String fromElement, boolean fromInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZREMRANGEBYLEX, this.getName(), fromValue, "+");
    }

    @Override
    public Future<Integer> removeRangeAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        return this.removeRangeByLexAsync(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public Future<Integer> removeRangeByLexAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZREMRANGEBYLEX, this.getName(), fromValue, toValue);
    }

    @Override
    public Collection<String> range(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        return this.lexRange(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public Collection<String> lexRange(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        return this.get(this.rangeAsync(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public Collection<String> rangeHead(String toElement, boolean toInclusive) {
        return this.lexRangeHead(toElement, toInclusive);
    }

    @Override
    public Collection<String> lexRangeHead(String toElement, boolean toInclusive) {
        return this.get(this.rangeHeadAsync(toElement, toInclusive));
    }

    @Override
    public Future<Collection<String>> rangeHeadAsync(String toElement, boolean toInclusive) {
        return this.lexRangeHeadAsync(toElement, toInclusive);
    }

    @Override
    public Future<Collection<String>> lexRangeHeadAsync(String toElement, boolean toInclusive) {
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), "-", toValue);
    }

    @Override
    public Collection<String> rangeTail(String fromElement, boolean fromInclusive) {
        return this.lexRangeTail(fromElement, fromInclusive);
    }

    @Override
    public Collection<String> lexRangeTail(String fromElement, boolean fromInclusive) {
        return this.get(this.rangeTailAsync(fromElement, fromInclusive));
    }

    @Override
    public Future<Collection<String>> rangeTailAsync(String fromElement, boolean fromInclusive) {
        return this.lexRangeTailAsync(fromElement, fromInclusive);
    }

    @Override
    public Future<Collection<String>> lexRangeTailAsync(String fromElement, boolean fromInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), fromValue, "+");
    }

    @Override
    public Future<Collection<String>> rangeAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        return this.lexRangeAsync(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public Future<Collection<String>> lexRangeAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), fromValue, toValue);
    }

    @Override
    public Collection<String> range(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive, int offset, int count) {
        return this.lexRange(fromElement, fromInclusive, toElement, toInclusive, offset, count);
    }

    @Override
    public Collection<String> lexRange(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive, int offset, int count) {
        return this.get(this.rangeAsync(fromElement, fromInclusive, toElement, toInclusive, offset, count));
    }

    @Override
    public Collection<String> rangeHead(String toElement, boolean toInclusive, int offset, int count) {
        return this.lexRangeHead(toElement, toInclusive, offset, count);
    }

    @Override
    public Collection<String> lexRangeHead(String toElement, boolean toInclusive, int offset, int count) {
        return this.get(this.rangeHeadAsync(toElement, toInclusive, offset, count));
    }

    @Override
    public Future<Collection<String>> rangeHeadAsync(String toElement, boolean toInclusive, int offset, int count) {
        return this.lexRangeHeadAsync(toElement, toInclusive, offset, count);
    }

    @Override
    public Future<Collection<String>> lexRangeHeadAsync(String toElement, boolean toInclusive, int offset, int count) {
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), "-", toValue, "LIMIT", offset, count);
    }

    @Override
    public Collection<String> rangeTail(String fromElement, boolean fromInclusive, int offset, int count) {
        return this.lexRangeTail(fromElement, fromInclusive, offset, count);
    }

    @Override
    public Collection<String> lexRangeTail(String fromElement, boolean fromInclusive, int offset, int count) {
        return this.get(this.rangeTailAsync(fromElement, fromInclusive, offset, count));
    }

    @Override
    public Future<Collection<String>> rangeTailAsync(String fromElement, boolean fromInclusive, int offset, int count) {
        return this.lexRangeTailAsync(fromElement, fromInclusive, offset, count);
    }

    @Override
    public Future<Collection<String>> lexRangeTailAsync(String fromElement, boolean fromInclusive, int offset, int count) {
        String fromValue = this.value(fromElement, fromInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), fromValue, "+", "LIMIT", offset, count);
    }

    @Override
    public Future<Collection<String>> rangeAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive, int offset, int count) {
        return this.lexRangeAsync(fromElement, fromInclusive, toElement, toInclusive, offset, count);
    }

    @Override
    public Future<Collection<String>> lexRangeAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive, int offset, int count) {
        String fromValue = this.value(fromElement, fromInclusive);
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZRANGEBYLEX, this.getName(), fromValue, toValue, "LIMIT", offset, count);
    }

    @Override
    public int countTail(String fromElement, boolean fromInclusive) {
        return this.lexCountTail(fromElement, fromInclusive);
    }

    @Override
    public int lexCountTail(String fromElement, boolean fromInclusive) {
        return this.get(this.countTailAsync(fromElement, fromInclusive));
    }

    @Override
    public Future<Integer> countTailAsync(String fromElement, boolean fromInclusive) {
        return this.lexCountTailAsync(fromElement, fromInclusive);
    }

    @Override
    public Future<Integer> lexCountTailAsync(String fromElement, boolean fromInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZLEXCOUNT, this.getName(), fromValue, "+");
    }

    @Override
    public int countHead(String toElement, boolean toInclusive) {
        return this.lexCountHead(toElement, toInclusive);
    }

    @Override
    public int lexCountHead(String toElement, boolean toInclusive) {
        return this.get(this.countHeadAsync(toElement, toInclusive));
    }

    @Override
    public Future<Integer> countHeadAsync(String toElement, boolean toInclusive) {
        return this.lexCountHeadAsync(toElement, toInclusive);
    }

    @Override
    public Future<Integer> lexCountHeadAsync(String toElement, boolean toInclusive) {
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZLEXCOUNT, this.getName(), "-", toValue);
    }

    @Override
    public int count(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        return this.lexCount(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public int lexCount(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        return this.get(this.countAsync(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public Future<Integer> countAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        return this.lexCountAsync(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public Future<Integer> lexCountAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        String fromValue = this.value(fromElement, fromInclusive);
        String toValue = this.value(toElement, toInclusive);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZLEXCOUNT, this.getName(), fromValue, toValue);
    }

    private String value(String fromElement, boolean fromInclusive) {
        String fromValue = fromElement.toString();
        fromValue = fromInclusive ? "[" + fromValue : "(" + fromValue;
        return fromValue;
    }

    @Override
    public Future<Boolean> addAsync(String e) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZADD_BOOL_RAW, this.getName(), 0, e);
    }

    @Override
    public Future<Boolean> addAllAsync(Collection<? extends String> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        ArrayList<Object> params = new ArrayList<Object>(2 * c.size());
        for (String string : c) {
            params.add(0);
            params.add(string);
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZADD_BOOL_RAW, this.getName(), params.toArray());
    }

    @Override
    public boolean add(String e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        return this.get(this.addAllAsync(c));
    }

    @Override
    public Collection<String> range(int startIndex, int endIndex) {
        return this.valueRange(startIndex, endIndex);
    }

    @Override
    public Future<Collection<String>> rangeAsync(int startIndex, int endIndex) {
        return this.valueRangeAsync(startIndex, endIndex);
    }
}

