/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonQueue;
import org.redisson.RedissonQueueSemaphore;
import org.redisson.RedissonSemaphore;
import org.redisson.api.RBoundedBlockingQueue;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.connection.decoder.ListDrainToDecoder;
import org.redisson.misc.PromiseDelegator;
import org.redisson.pubsub.SemaphorePubSub;

public class RedissonBoundedBlockingQueue<V>
extends RedissonQueue<V>
implements RBoundedBlockingQueue<V> {
    private final CommandExecutor commandExecutor;
    private final SemaphorePubSub semaphorePubSub;

    protected RedissonBoundedBlockingQueue(SemaphorePubSub semaphorePubSub, CommandExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.semaphorePubSub = semaphorePubSub;
        this.commandExecutor = commandExecutor;
    }

    protected RedissonBoundedBlockingQueue(SemaphorePubSub semaphorePubSub, Codec codec, CommandExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.semaphorePubSub = semaphorePubSub;
        this.commandExecutor = commandExecutor;
    }

    private String getSemaphoreName() {
        if (this.getName().contains("{")) {
            return "redisson_bqs:" + this.getName();
        }
        return "redisson_bqs:{" + this.getName() + "}";
    }

    @Override
    public Future<Boolean> addAsync(V e) {
        final Promise<Boolean> result = this.commandExecutor.getConnectionManager().newPromise();
        Future<Boolean> future = this.offerAsync(e);
        future.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                if (!future.getNow().booleanValue()) {
                    result.tryFailure(new IllegalStateException("Queue is full"));
                    return;
                }
                result.trySuccess(future.getNow());
            }
        });
        return result;
    }

    @Override
    public Future<Void> putAsync(V e) {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.acquireAsync();
    }

    private RedissonQueueSemaphore createSemaphore(V e) {
        RedissonQueueSemaphore semaphore = new RedissonQueueSemaphore(this.commandExecutor, this.getSemaphoreName(), this.semaphorePubSub);
        semaphore.setQueueName(this.getName());
        semaphore.setValue(e);
        return semaphore;
    }

    @Override
    public void put(V e) throws InterruptedException {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        semaphore.acquire();
    }

    @Override
    public Future<Boolean> offerAsync(V e) {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.tryAcquireAsync();
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.tryAcquire(timeout, unit);
    }

    @Override
    public Future<Boolean> offerAsync(V e, long timeout, TimeUnit unit) {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.tryAcquireAsync(timeout, unit);
    }

    @Override
    public Future<V> takeAsync() {
        Future takeFuture = this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, this.getName(), 0);
        return this.wrapTakeFuture(takeFuture);
    }

    private Promise<V> wrapTakeFuture(final Future<V> takeFuture) {
        final PromiseDelegator result = new PromiseDelegator<V>(this.commandExecutor.getConnectionManager().newPromise()){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return takeFuture.cancel(mayInterruptIfRunning);
            }
        };
        takeFuture.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    result.setFailure(future.cause());
                    return;
                }
                RedissonBoundedBlockingQueue.this.createSemaphore(null).releaseAsync().addListener((GenericFutureListener<Future<Void>>)new FutureListener<Void>(){

                    @Override
                    public void operationComplete(Future<Void> future) throws Exception {
                        result.setSuccess(takeFuture.getNow());
                    }
                });
            }
        });
        return result;
    }

    @Override
    public Future<Boolean> removeAsync(Object o) {
        return this.removeAllAsync(Collections.singleton(o));
    }

    @Override
    public Future<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN_WITH_VALUES_6, "local count = 0; for i = 1, #ARGV, 1 do if redis.call('lrem', KEYS[1], 0, ARGV[i]) == 1 then count = count + 1; end; end; if count > 0 then local value = redis.call('incrby', KEYS[2], count); redis.call('publish', KEYS[3], value); return 1;end;return 0 ", Arrays.asList(this.getName(), this.getSemaphoreName(), channelName), c.toArray());
    }

    @Override
    public Future<V> pollAsync() {
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local res = redis.call('lpop', KEYS[1]);if res ~= false then local value = redis.call('incrby', KEYS[2], ARGV[1]); redis.call('publish', KEYS[3], value); end;return res;", Arrays.asList(this.getName(), this.getSemaphoreName(), channelName), 1);
    }

    @Override
    public V take() throws InterruptedException {
        return this.get(this.takeAsync());
    }

    @Override
    public Future<V> pollAsync(long timeout, TimeUnit unit) {
        Future takeFuture = this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, this.getName(), unit.toSeconds(timeout));
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.get(this.pollAsync(timeout, unit));
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        return this.get(this.pollFromAnyAsync(timeout, unit, queueNames));
    }

    @Override
    public Future<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        ArrayList<Object> params = new ArrayList<Object>(queueNames.length + 1);
        params.add(this.getName());
        for (String name : queueNames) {
            params.add(name);
        }
        params.add(unit.toSeconds(timeout));
        Future takeFuture = this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, params.toArray());
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public Future<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        Future takeFuture = this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BRPOPLPUSH, this.getName(), queueName, unit.toSeconds(timeout));
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        return this.get(this.pollLastAndOfferFirstToAsync(queueName, timeout, unit));
    }

    @Override
    public int remainingCapacity() {
        return this.createSemaphore(null).availablePermits();
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        return this.get(this.drainToAsync(c));
    }

    @Override
    public Future<Integer> drainToAsync(Collection<? super V> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local vals = redis.call('lrange', KEYS[1], 0, -1); redis.call('del', KEYS[1]); if #vals > 0 then local value = redis.call('incrby', KEYS[2], #vals); redis.call('publish', KEYS[3], value); end; return vals", Arrays.asList(this.getName(), this.getSemaphoreName(), channelName), new Object[0]);
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        if (maxElements <= 0) {
            return 0;
        }
        return this.get(this.drainToAsync(c, maxElements));
    }

    @Override
    public Future<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local elemNum = math.min(ARGV[1], redis.call('llen', KEYS[1])) - 1;local vals = redis.call('lrange', KEYS[1], 0, elemNum); redis.call('ltrim', KEYS[1], elemNum + 1, -1); if #vals > 0 then local value = redis.call('incrby', KEYS[2], #vals); redis.call('publish', KEYS[3], value); end; return vals", Arrays.asList(this.getName(), this.getSemaphoreName(), channelName), maxElements);
    }

    @Override
    public Future<Boolean> trySetCapacityAsync(int capacity) {
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value == false) then redis.call('set', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.getSemaphoreName(), channelName), capacity);
    }

    @Override
    public boolean trySetCapacity(int capacity) {
        return this.get(this.trySetCapacityAsync(capacity));
    }

    @Override
    public Future<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_OBJECTS, this.getName(), this.getSemaphoreName());
    }

    @Override
    public Future<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('pexpire', KEYS[2], ARGV[1]); return redis.call('pexpire', KEYS[1], ARGV[1]); ", Arrays.asList(this.getName(), this.getSemaphoreName()), timeUnit.toMillis(timeToLive));
    }

    @Override
    public Future<Boolean> expireAtAsync(long timestamp) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('pexpireat', KEYS[2], ARGV[1]); return redis.call('pexpireat', KEYS[1], ARGV[1]); ", Arrays.asList(this.getName(), this.getSemaphoreName()), timestamp);
    }

    @Override
    public Future<Boolean> clearExpireAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('persist', KEYS[2]); return redis.call('persist', KEYS[1]); ", Arrays.asList(this.getName(), this.getSemaphoreName()), new Object[0]);
    }

    @Override
    public Future<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        RedissonQueueSemaphore semaphore = new RedissonQueueSemaphore(this.commandExecutor, this.getSemaphoreName(), this.semaphorePubSub);
        semaphore.setQueueName(this.getName());
        semaphore.setValues(c);
        return semaphore.tryAcquireAsync();
    }
}

