/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.shape.Line;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;
import org.redfx.strange.Qubit;
import org.redfx.strange.Result;
import org.redfx.strange.Step;
import org.redfx.strange.local.SimpleQuantumExecutionEnvironment;
import org.redfx.strange.ui.render.BoardOverlay;
import org.redfx.strangefx.simulator.RenderModel;
import org.redfx.strangefx.ui.GateSymbol;
import org.redfx.strangefx.ui.QubitFlow;

public class QubitBoard
extends Group {
    public static final int WIRE_HEIGHT = 77;
    private final RenderModel model;
    private ObservableList<QubitFlow> wires = FXCollections.observableArrayList();
    private final int nQubits;
    private Line[] line;

    public QubitBoard(RenderModel model) {
        int i;
        this.model = model;
        this.nQubits = model.getNQubits();
        this.line = new Line[this.nQubits];
        for (i = 0; i < this.nQubits; ++i) {
            this.line[i] = new Line();
            this.line[i].setTranslateY((double)(77 * i + 38));
            this.line[i].getStyleClass().add((Object)"wire");
            this.getChildren().add((Object)this.line[i]);
        }
        this.wires.addListener(o -> model.refreshRequest().set(true));
        model.stepsProperty().addListener(observable -> {
            this.processCircuit((ArrayList)model.stepsProperty().get());
            this.renderCircuit();
        });
        for (i = 0; i < this.nQubits; ++i) {
            this.appendQubit();
            QubitFlow q = (QubitFlow)((Object)this.wires.get(i));
            q.setTranslateY(i * 77);
            this.getChildren().add((Object)q);
            this.line[i].endXProperty().bind((ObservableValue)q.widthProperty());
        }
    }

    public void addOverlay(BoardOverlay overlay) {
        this.getChildren().add((Object)overlay);
    }

    public ObservableList<QubitFlow> getWires() {
        return this.wires;
    }

    public void appendQubit() {
        QubitFlow flow = new QubitFlow(this.wires.size(), this.model);
        this.wires.add((Object)flow);
    }

    public void clear() {
        this.wires.forEach(QubitFlow::clear);
        this.wires.removeIf(qb -> qb.getIndex() > this.nQubits - 1);
    }

    private void renderCircuit() {
        this.clear();
        for (Step step : this.model.getSteps()) {
            List gates = step.getGates();
            boolean[] gotit = new boolean[this.nQubits];
            for (Gate gate : gates) {
                int qb = gate.getMainQubitIndex();
                System.err.println("qb = " + qb);
                gotit[qb] = true;
                QubitFlow wire = (QubitFlow)((Object)this.wires.get(qb));
                wire.setMinWidth(480.0);
                System.err.println("Calling addGate");
                GateSymbol gateSymbol = wire.addGate(gate);
            }
        }
    }

    public List<QubitFlow> getQubitFlows() {
        return this.wires;
    }

    private void processCircuit(ArrayList<Step> steps) {
        System.err.println("Process circuit with " + this.wires.size() + " qubits and " + steps.size() + " steps.");
        Program p = new Program(this.wires.size(), new Step[0]);
        for (Step step : steps) {
            System.err.println("Step: " + step);
            p.addStep(step);
        }
        SimpleQuantumExecutionEnvironment qee = new SimpleQuantumExecutionEnvironment();
        Consumer<Result> resultConsumer = t -> Platform.runLater(() -> {
            Qubit[] qubits = t.getQubits();
            ObservableList<Double> endStates = this.model.getEndStates();
            for (int i = 0; i < this.wires.size(); ++i) {
                if (endStates.size() > i) {
                    endStates.set(i, (Object)qubits[i].getProbability());
                    continue;
                }
                endStates.add(i, (Object)qubits[i].getProbability());
            }
        });
        qee.runProgram(p, resultConsumer);
    }

    public void redraw() {
        this.wires.forEach(w -> w.redraw());
    }
}

