/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.ui;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import org.redfx.strange.Gate;
import org.redfx.strange.gate.Hadamard;
import org.redfx.strange.gate.Identity;
import org.redfx.strange.gate.X;
import org.redfx.strange.gate.Y;
import org.redfx.strange.gate.Z;
import org.redfx.strange.simulator.local.LocalSimulator;
import org.redfx.strangefx.simulator.RenderModel;
import org.redfx.strangefx.ui.GateSymbol;
import org.redfx.strangefx.ui.PartialGate;
import org.redfx.strangefx.ui.QubitBoard;

public class Main
extends Application {
    private final RenderModel model = new RenderModel();

    public static void main(String[] args) {
        System.out.println("hello, strange");
        Main.launch((String[])new String[0]);
    }

    public void start(Stage stage) throws Exception {
        LocalSimulator sim = new LocalSimulator(this.model);
        this.model.setNQubits(2);
        QubitBoard board = new QubitBoard(this.model);
        HBox toolbarFiller = new HBox();
        HBox.setHgrow((Node)toolbarFiller, (Priority)Priority.ALWAYS);
        ImageView logo = new ImageView("/strangelogo.png");
        logo.setPreserveRatio(true);
        logo.setFitWidth(100.0);
        ToolBar toolbar = new ToolBar(new Node[]{this.createButton("Append Qubit", (EventHandler<ActionEvent>)((EventHandler)e -> board.appendQubit())), this.createButton("Clear All", (EventHandler<ActionEvent>)((EventHandler)e -> board.clear())), new Separator(), GateSymbol.of((Gate)new Identity(0), false), GateSymbol.of((Gate)new X(0), false), GateSymbol.of((Gate)new Y(0), false), GateSymbol.of((Gate)new Z(0), false), GateSymbol.of((Gate)new Hadamard(0), false), new Separator(), GateSymbol.of((Gate)new PartialGate(PartialGate.ControlQubit.ON)), toolbarFiller, logo});
        this.model.refreshRequest().set(true);
        ScrollPane scroller = new ScrollPane((Node)board);
        scroller.setPannable(true);
        scroller.setFitToWidth(true);
        BorderPane borderPane = new BorderPane();
        borderPane.setTop((Node)toolbar);
        borderPane.setCenter((Node)scroller);
        Scene scene = new Scene((Parent)borderPane, 800.0, 600.0);
        scene.getStylesheets().add((Object)Main.class.getResource("/styles.css").toExternalForm());
        stage.setScene(scene);
        stage.show();
    }

    private Button createButton(String tooltip, EventHandler<ActionEvent> eventHandler) {
        Button button = new Button(tooltip);
        button.setOnAction(eventHandler);
        if (tooltip != null && !tooltip.trim().isEmpty()) {
            Tooltip t = new Tooltip(tooltip);
            button.setTooltip(t);
        }
        return button;
    }
}

