/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import org.redfx.strange.Complex;
import org.redfx.strange.gate.SingleQubitGate;

public class Rotation
extends SingleQubitGate {
    protected Complex[][] matrix;
    protected final double thetav;
    private final Axes axis;

    public Rotation(double theta, Axes axis, int idx) {
        super(idx);
        this.thetav = theta;
        this.axis = axis;
        switch (axis) {
            case XAxis: {
                this.matrix = new Complex[][]{{new Complex(Math.cos(theta / 2.0), 0.0), new Complex(0.0, -Math.sin(theta / 2.0))}, {new Complex(0.0, -Math.sin(theta / 2.0)), new Complex(Math.cos(theta / 2.0), 0.0)}};
                break;
            }
            case YAxis: {
                this.matrix = new Complex[][]{{new Complex(Math.cos(theta / 2.0), 0.0), new Complex(-Math.sin(theta / 2.0), 0.0)}, {new Complex(Math.sin(theta / 2.0), 0.0), new Complex(Math.cos(theta / 2.0))}};
                break;
            }
            case ZAxis: {
                this.matrix = new Complex[][]{{new Complex(Math.cos(theta / 2.0), -1.0 * Math.sin(theta / 2.0)), Complex.ZERO}, {Complex.ZERO, new Complex(Math.cos(theta / 2.0), -1.0 * Math.sin(theta / 2.0))}};
            }
        }
    }

    @Override
    public Complex[][] getMatrix() {
        return this.matrix;
    }

    @Override
    public void setInverse(boolean v) {
        super.setInverse(v);
        this.matrix = Complex.conjugateTranspose(this.matrix);
    }

    @Override
    public String getCaption() {
        return "Rotation of " + this.axis.name() + " with angle " + this.thetav;
    }

    public static enum Axes {
        XAxis,
        YAxis,
        ZAxis;

    }
}

