/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import org.redfx.strange.Block;
import org.redfx.strange.BlockGate;
import org.redfx.strange.ControlledBlockGate;
import org.redfx.strange.Step;
import org.redfx.strange.gate.AddInteger;
import org.redfx.strange.gate.Cnot;
import org.redfx.strange.gate.X;

public class AddIntegerModulus
extends BlockGate<AddIntegerModulus> {
    Block block;

    public AddIntegerModulus(int x0, int x1, int a, int N) {
        int n = x1 - x0 + 1;
        if (N >= 1 << n) {
            throw new IllegalArgumentException("AddIntegerModules with n = " + n + " but modulus is bigger than max: " + N);
        }
        this.setIndex(x0);
        x1 -= x0;
        x0 = 0;
        this.block = this.createBlock(x0, x1, a, N);
        this.setBlock(this.block);
    }

    public Block createBlock(int x0, int x1, int a, int N) {
        Block answer = new Block("AddIntegerModulus", x1 - x0 + 2);
        int n = x1 - x0;
        int dim = n + 1;
        AddInteger add = new AddInteger(x0, x1, a);
        answer.addStep(new Step(add));
        AddInteger min = (AddInteger)new AddInteger(x0, x1, N).inverse();
        answer.addStep(new Step(min));
        answer.addStep(new Step(new Cnot(x1, dim)));
        AddInteger addN = new AddInteger(x0, x1, N);
        ControlledBlockGate cbg = new ControlledBlockGate(addN, x0, dim);
        answer.addStep(new Step(cbg));
        AddInteger add2 = (AddInteger)new AddInteger(x0, x1, a).inverse();
        answer.addStep(new Step(add2));
        answer.addStep(new Step(new X(dim - 1)));
        answer.addStep(new Step(new Cnot(x1, dim)));
        answer.addStep(new Step(new X(dim - 1)));
        AddInteger add3 = new AddInteger(x0, x1, a);
        answer.addStep(new Step(add3));
        return answer;
    }
}

