/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.redfx.strange.Block;
import org.redfx.strange.BlockGate;
import org.redfx.strange.Complex;
import org.redfx.strange.QuantumExecutionEnvironment;
import org.redfx.strange.gate.PermutationGate;
import org.redfx.strange.local.Computations;

public class ControlledBlockGate<T>
extends BlockGate {
    private int control;
    private int size;
    private int high = -1;
    private int haq = -1;
    int low = 0;
    private Complex[][] matrix = null;

    protected ControlledBlockGate() {
    }

    public ControlledBlockGate(BlockGate bg, int idx, int control) {
        this(bg.getBlock(), idx, control);
    }

    public ControlledBlockGate(Block block, int idx, int control) {
        super(block, idx);
        this.control = control;
        this.haq = control > idx ? idx + block.getNQubits() : idx + block.getNQubits() - 1;
    }

    @Override
    public List<Integer> getAffectedQubitIndexes() {
        ArrayList<Integer> answer = new ArrayList<Integer>(super.getAffectedQubitIndexes());
        answer.add(this.control);
        return answer;
    }

    @Override
    public int getHighestAffectedQubitIndex() {
        if (this.high < 0) {
            this.calculateHighLow();
        }
        return this.haq;
    }

    @Override
    public String getCaption() {
        return "CB";
    }

    @Override
    public String getName() {
        return "CBlockGate";
    }

    @Override
    public String getGroup() {
        return "CBlockGroup";
    }

    public int getControlQubit() {
        return this.control;
    }

    public void calculateHighLow() {
        this.high = this.control;
        int gap = this.control - this.idx;
        int bs = this.block.getNQubits();
        this.low = 0;
        if (this.control > this.idx) {
            this.low = this.idx;
            if (gap < bs) {
                throw new IllegalArgumentException("Can't have control at " + this.control + " for gate with size " + bs + " starting at " + this.idx);
            }
            if (gap > bs) {
                this.high = this.control;
            }
        } else {
            this.low = this.control;
            this.high = this.idx + bs - 1;
        }
        this.size = this.high - this.low + 1;
    }

    public int getLow() {
        return this.low;
    }

    public void correctHigh(int h) {
        this.high = h;
    }

    @Override
    public Complex[][] getMatrix() {
        return this.getMatrix(null);
    }

    @Override
    public Complex[][] getMatrix(QuantumExecutionEnvironment qee) {
        if (this.matrix == null) {
            int low = 0;
            this.high = this.control;
            this.size = super.getSize() + 1;
            int gap = this.control - this.idx;
            LinkedList<PermutationGate> perm = new LinkedList<PermutationGate>();
            int bs = this.block.getNQubits();
            if (this.control > this.idx) {
                if (gap < bs) {
                    throw new IllegalArgumentException("Can't have control at " + this.control + " for gate with size " + bs + " starting at " + this.idx);
                }
                low = this.idx;
                if (gap > bs) {
                    this.high = this.control;
                    this.size = this.high - low + 1;
                    PermutationGate pg = new PermutationGate(this.control - low, this.control - low - gap + bs, this.size);
                    perm.add(pg);
                }
            } else {
                low = this.control;
                this.high = this.idx + bs - 1;
                this.size = this.high - low + 1;
                for (int i = 0; i < this.size - 1; ++i) {
                    PermutationGate pg = new PermutationGate(i, i + 1, this.size);
                    perm.add(0, pg);
                }
            }
            Complex[][] part = this.block.getMatrix(qee);
            int dim = part.length;
            this.matrix = Computations.createIdentity(2 * dim);
            for (int i = 0; i < dim; ++i) {
                for (int j = 0; j < dim; ++j) {
                    this.matrix[i + dim][j + dim] = part[i][j];
                }
            }
        } else {
            System.err.println("Matrix was cached");
        }
        return this.matrix;
    }

    @Override
    public boolean hasOptimization() {
        return true;
    }

    @Override
    public Complex[] applyOptimize(Complex[] v) {
        int size = v.length;
        Complex[] answer = new Complex[size];
        int dim = size / 2;
        Complex[] oldv = new Complex[dim];
        for (int i = 0; i < dim; ++i) {
            oldv[i] = v[i + dim];
        }
        Complex[] p2 = this.block.applyOptimize(oldv, this.inverse);
        for (int i = 0; i < dim; ++i) {
            answer[i] = v[i];
            answer[dim + i] = p2[i];
        }
        return answer;
    }

    @Override
    public int getSize() {
        return this.block.getNQubits() + 1;
    }

    @Override
    public String toString() {
        return "ControlledGate for " + super.toString();
    }
}

