/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import java.util.Collections;
import java.util.List;
import org.redfx.strange.Complex;
import org.redfx.strange.Gate;

public abstract class SingleQubitGate
implements Gate {
    private int idx;
    private boolean inverse;

    public SingleQubitGate() {
    }

    public SingleQubitGate(int idx) {
        this.idx = idx;
    }

    @Override
    public int getMainQubitIndex() {
        return this.idx;
    }

    @Override
    public void setMainQubitIndex(int idx) {
        this.idx = idx;
    }

    @Override
    public void setAdditionalQubit(int idx, int cnt) {
        throw new RuntimeException("A SingleQubitGate can not have additional qubits");
    }

    @Override
    public List<Integer> getAffectedQubitIndexes() {
        return Collections.singletonList(this.idx);
    }

    @Override
    public int getHighestAffectedQubitIndex() {
        return this.idx;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getCaption() {
        return this.getName();
    }

    @Override
    public String getGroup() {
        return "SingleQubit";
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public abstract Complex[][] getMatrix();

    @Override
    public void setInverse(boolean v) {
        this.inverse = v;
    }

    public String toString() {
        return "Gate with index " + this.idx + " and caption " + this.getCaption();
    }
}

