/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import java.util.HashMap;
import org.redfx.strange.Block;
import org.redfx.strange.BlockGate;
import org.redfx.strange.Step;
import org.redfx.strange.gate.Fourier;
import org.redfx.strange.gate.InvFourier;
import org.redfx.strange.gate.R;

public class AddInteger
extends BlockGate<AddInteger> {
    Block block;
    static HashMap<Integer, Block> cache = new HashMap();

    public AddInteger(int x0, int x1, int num) {
        this.setIndex(x0);
        x1 -= x0;
        x0 = 0;
        int hash = 1000000 * x0 + 10000 * x1 + num;
        this.block = cache.get(hash);
        if (this.block == null) {
            this.block = this.createBlock(x0, x1, num);
        }
        this.setBlock(this.block);
    }

    public Block createBlock(int x0, int x1, int num) {
        int m = x1 - x0 + 1;
        Block answer = new Block("AddInteger ", m);
        answer.addStep(new Step(new Fourier(m, 0)));
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m - i; ++j) {
                int cr0 = m - j - i - 1;
                if ((num >> cr0 & 1) != 1) continue;
                Step s = new Step(new R(2, 1 + j, i));
                answer.addStep(s);
            }
        }
        answer.addStep(new Step(new InvFourier(m, 0)));
        return answer;
    }
}

