/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.tck;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.reactivestreams.tck.SubscriberWhiteboxVerification;
import org.reactivestreams.tck.TestEnvironment;
import org.reactivestreams.tck.WithHelperPublisher;
import org.reactivestreams.tck.support.Optional;
import org.reactivestreams.tck.support.SubscriberBlackboxVerificationRules;
import org.reactivestreams.tck.support.TestException;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class SubscriberBlackboxVerification<T>
extends WithHelperPublisher<T>
implements SubscriberBlackboxVerificationRules {
    protected final TestEnvironment env;
    private ExecutorService publisherExecutor;

    protected SubscriberBlackboxVerification(TestEnvironment env) {
        this.env = env;
    }

    public abstract Subscriber<T> createSubscriber();

    @BeforeClass
    public void startPublisherExecutorService() {
        this.publisherExecutor = Executors.newFixedThreadPool(4);
    }

    @AfterClass
    public void shutdownPublisherExecutorService() {
        if (this.publisherExecutor != null) {
            this.publisherExecutor.shutdown();
        }
    }

    @Override
    public ExecutorService publisherExecutorService() {
        return this.publisherExecutor;
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.env.clearAsyncErrors();
    }

    @Override
    @Test
    public void required_spec201_blackbox_mustSignalDemandViaSubscriptionRequest() throws Throwable {
        this.blackboxSubscriberTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws InterruptedException {
                long n = stage.expectRequest();
                int i = 0;
                while ((long)i < n) {
                    stage.signalNext();
                    ++i;
                }
            }
        });
    }

    @Override
    @Test
    public void untested_spec202_blackbox_shouldAsynchronouslyDispatch() throws Exception {
        this.notVerified();
    }

    @Override
    @Test
    public void required_spec203_blackbox_mustNotCallMethodsOnSubscriptionOrPublisherInOnComplete() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                Subscription subs = new Subscription(){

                    public void request(long n) {
                        Optional<StackTraceElement> onCompleteStackTraceElement = SubscriberBlackboxVerification.this.env.findCallerMethodInStackTrace("onComplete");
                        if (onCompleteStackTraceElement.isDefined()) {
                            StackTraceElement stackElem = onCompleteStackTraceElement.get();
                            SubscriberBlackboxVerification.this.env.flop(String.format("Subscription::request MUST NOT be called from Subscriber::onComplete (Rule 2.3)! (Caller: %s::%s line %d)", stackElem.getClassName(), stackElem.getMethodName(), stackElem.getLineNumber()));
                        }
                    }

                    public void cancel() {
                        Optional<StackTraceElement> onCompleteStackElement = SubscriberBlackboxVerification.this.env.findCallerMethodInStackTrace("onComplete");
                        if (onCompleteStackElement.isDefined()) {
                            StackTraceElement stackElem = onCompleteStackElement.get();
                            SubscriberBlackboxVerification.this.env.flop(String.format("Subscription::cancel MUST NOT be called from Subscriber::onComplete (Rule 2.3)! (Caller: %s::%s line %d)", stackElem.getClassName(), stackElem.getMethodName(), stackElem.getLineNumber()));
                        }
                    }
                };
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                sub.onSubscribe(subs);
                sub.onComplete();
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Override
    @Test
    public void required_spec203_blackbox_mustNotCallMethodsOnSubscriptionOrPublisherInOnError() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                Subscription subs = new Subscription(){

                    public void request(long n) {
                        Throwable thr = new Throwable();
                        for (StackTraceElement stackElem : thr.getStackTrace()) {
                            if (!stackElem.getMethodName().equals("onError")) continue;
                            SubscriberBlackboxVerification.this.env.flop(String.format("Subscription::request MUST NOT be called from Subscriber::onError (Rule 2.3)! (Caller: %s::%s line %d)", stackElem.getClassName(), stackElem.getMethodName(), stackElem.getLineNumber()));
                        }
                    }

                    public void cancel() {
                        Throwable thr = new Throwable();
                        for (StackTraceElement stackElem : thr.getStackTrace()) {
                            if (!stackElem.getMethodName().equals("onError")) continue;
                            SubscriberBlackboxVerification.this.env.flop(String.format("Subscription::cancel MUST NOT be called from Subscriber::onError (Rule 2.3)! (Caller: %s::%s line %d)", stackElem.getClassName(), stackElem.getMethodName(), stackElem.getLineNumber()));
                        }
                    }
                };
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                sub.onSubscribe(subs);
                sub.onError((Throwable)new TestException());
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Override
    @Test
    public void untested_spec204_blackbox_mustConsiderTheSubscriptionAsCancelledInAfterRecievingOnCompleteOrOnError() throws Exception {
        this.notVerified();
    }

    @Override
    @Test
    public void required_spec205_blackbox_mustCallSubscriptionCancelIfItAlreadyHasAnSubscriptionAndReceivesAnotherOnSubscribeSignal() throws Exception {
        new BlackboxTestStage(this.env){
            {
                final TestEnvironment.Latch secondSubscriptionCancelled = new TestEnvironment.Latch(this.env);
                this.sub().onSubscribe(new Subscription(){

                    public void request(long elements) {
                        env.flop(String.format("Subscriber %s illegally called `subscription.request(%s)`!", this.sub(), elements));
                    }

                    public void cancel() {
                        secondSubscriptionCancelled.close();
                    }

                    public String toString() {
                        return "SecondSubscription(should get cancelled)";
                    }
                });
                secondSubscriptionCancelled.expectClose("Expected SecondSubscription given to subscriber to be cancelled, but `Subscription.cancel()` was not called.");
                this.env.verifyNoAsyncErrors();
            }
        };
    }

    @Override
    @Test
    public void untested_spec206_blackbox_mustCallSubscriptionCancelIfItIsNoLongerValid() throws Exception {
        this.notVerified();
    }

    @Override
    @Test
    public void untested_spec207_blackbox_mustEnsureAllCallsOnItsSubscriptionTakePlaceFromTheSameThreadOrTakeCareOfSynchronization() throws Exception {
        this.notVerified();
    }

    @Override
    @Test
    public void untested_spec208_blackbox_mustBePreparedToReceiveOnNextSignalsAfterHavingCalledSubscriptionCancel() throws Throwable {
        this.notVerified();
    }

    @Override
    @Test
    public void required_spec209_blackbox_mustBePreparedToReceiveAnOnCompleteSignalWithPrecedingRequestCall() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                Publisher pub = new Publisher<T>(){

                    public void subscribe(final Subscriber<? super T> s) {
                        s.onSubscribe(new Subscription(){
                            private boolean completed = false;

                            public void request(long n) {
                                if (!this.completed) {
                                    this.completed = true;
                                    s.onComplete();
                                }
                            }

                            public void cancel() {
                            }
                        });
                    }
                };
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                SubscriberWhiteboxVerification.BlackboxSubscriberProxy probe = stage.createBlackboxSubscriberProxy(SubscriberBlackboxVerification.this.env, sub);
                pub.subscribe(probe);
                probe.expectCompletion();
                probe.expectNone();
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Override
    @Test
    public void required_spec209_blackbox_mustBePreparedToReceiveAnOnCompleteSignalWithoutPrecedingRequestCall() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                Publisher pub = new Publisher<T>(){

                    public void subscribe(Subscriber<? super T> s) {
                        s.onComplete();
                    }
                };
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                SubscriberWhiteboxVerification.BlackboxSubscriberProxy probe = stage.createBlackboxSubscriberProxy(SubscriberBlackboxVerification.this.env, sub);
                pub.subscribe(probe);
                probe.expectCompletion();
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Override
    @Test
    public void required_spec210_blackbox_mustBePreparedToReceiveAnOnErrorSignalWithPrecedingRequestCall() throws Throwable {
        this.blackboxSubscriberTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                stage.sub().onError((Throwable)new TestException());
                stage.subProxy().expectError(Throwable.class);
            }
        });
    }

    @Override
    @Test
    public void untested_spec211_blackbox_mustMakeSureThatAllCallsOnItsMethodsHappenBeforeTheProcessingOfTheRespectiveEvents() throws Exception {
        this.notVerified();
    }

    @Override
    @Test
    public void untested_spec212_blackbox_mustNotCallOnSubscribeMoreThanOnceBasedOnObjectEquality() throws Throwable {
        this.notVerified();
    }

    @Override
    @Test
    public void untested_spec213_blackbox_failingOnSignalInvocation() throws Exception {
        this.notVerified();
    }

    @Override
    @Test
    public void required_spec213_blackbox_onSubscribe_mustThrowNullPointerExceptionWhenParametersAreNull() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                boolean gotNPE = false;
                try {
                    sub.onSubscribe(null);
                }
                catch (NullPointerException expected) {
                    gotNPE = true;
                }
                Assert.assertTrue((boolean)gotNPE, (String)"onSubscribe(null) did not throw NullPointerException");
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Override
    @Test
    public void required_spec213_blackbox_onNext_mustThrowNullPointerExceptionWhenParametersAreNull() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                Subscription subscription = new Subscription(){

                    public void request(long elements) {
                    }

                    public void cancel() {
                    }
                };
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                boolean gotNPE = false;
                sub.onSubscribe(subscription);
                try {
                    sub.onNext(null);
                }
                catch (NullPointerException expected) {
                    gotNPE = true;
                }
                Assert.assertTrue((boolean)gotNPE, (String)"onNext(null) did not throw NullPointerException");
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Override
    @Test
    public void required_spec213_blackbox_onError_mustThrowNullPointerExceptionWhenParametersAreNull() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                Subscription subscription = new Subscription(){

                    public void request(long elements) {
                    }

                    public void cancel() {
                    }
                };
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                boolean gotNPE = false;
                sub.onSubscribe(subscription);
                try {
                    sub.onError(null);
                }
                catch (NullPointerException expected) {
                    gotNPE = true;
                }
                Assert.assertTrue((boolean)gotNPE, (String)"onError(null) did not throw NullPointerException");
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Override
    @Test
    public void untested_spec301_blackbox_mustNotBeCalledOutsideSubscriberContext() throws Exception {
        this.notVerified();
    }

    @Override
    @Test
    public void required_spec308_blackbox_requestMustRegisterGivenNumberElementsToBeProduced() throws Throwable {
        this.notVerified();
    }

    @Override
    @Test
    public void untested_spec310_blackbox_requestMaySynchronouslyCallOnNextOnSubscriber() throws Exception {
        this.notVerified();
    }

    @Override
    @Test
    public void untested_spec311_blackbox_requestMaySynchronouslyCallOnCompleteOrOnError() throws Exception {
        this.notVerified();
    }

    @Override
    @Test
    public void untested_spec314_blackbox_cancelMayCauseThePublisherToShutdownIfNoOtherSubscriptionExists() throws Exception {
        this.notVerified();
    }

    @Override
    @Test
    public void untested_spec315_blackbox_cancelMustNotThrowExceptionAndMustSignalOnError() throws Exception {
        this.notVerified();
    }

    @Override
    @Test
    public void untested_spec316_blackbox_requestMustNotThrowExceptionAndMustOnErrorTheSubscriber() throws Exception {
        this.notVerified();
    }

    public void blackboxSubscriberTest(BlackboxTestStageTestRun body) throws Throwable {
        BlackboxTestStage stage = new BlackboxTestStage(this.env, true);
        body.run(stage);
    }

    public void blackboxSubscriberWithoutSetupTest(BlackboxTestStageTestRun body) throws Throwable {
        BlackboxTestStage stage = new BlackboxTestStage(this.env, false);
        body.run(stage);
    }

    public void notVerified() {
        throw new SkipException("Not verified using this TCK.");
    }

    public class BlackboxTestStage
    extends TestEnvironment.ManualPublisher<T> {
        public Publisher<T> pub;
        public TestEnvironment.ManualSubscriber<T> tees;
        public T lastT;
        private Optional<SubscriberWhiteboxVerification.BlackboxSubscriberProxy<T>> subProxy;

        public BlackboxTestStage(TestEnvironment env) throws InterruptedException {
            this(env, true);
        }

        public BlackboxTestStage(TestEnvironment env, boolean runDefaultInit) throws InterruptedException {
            super(env);
            this.lastT = null;
            this.subProxy = Optional.empty();
            if (runDefaultInit) {
                this.pub = this.createHelperPublisher(Long.MAX_VALUE);
                this.tees = env.newManualSubscriber(this.pub);
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                this.subProxy = Optional.of(this.createBlackboxSubscriberProxy(env, sub));
                this.subscribe(this.subProxy.get());
            }
        }

        public Subscriber<? super T> sub() {
            return (Subscriber)this.subscriber.value();
        }

        public SubscriberWhiteboxVerification.BlackboxSubscriberProxy<T> subProxy() {
            return this.subProxy.get();
        }

        public Publisher<T> createHelperPublisher(long elements) {
            return SubscriberBlackboxVerification.this.createHelperPublisher(elements);
        }

        public SubscriberWhiteboxVerification.BlackboxSubscriberProxy<T> createBlackboxSubscriberProxy(TestEnvironment env, Subscriber<T> sub) {
            return new SubscriberWhiteboxVerification.BlackboxSubscriberProxy(env, sub);
        }

        public T signalNext() throws InterruptedException {
            Object element = this.nextT();
            this.sendNext(element);
            return element;
        }

        public T nextT() throws InterruptedException {
            this.lastT = this.tees.requestNextElement();
            return this.lastT;
        }
    }

    abstract class BlackboxTestStageTestRun {
        BlackboxTestStageTestRun() {
        }

        public abstract void run(BlackboxTestStage var1) throws Throwable;
    }
}

