/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.tck;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.reactivestreams.tck.TestEnvironment;
import org.reactivestreams.tck.support.Optional;
import org.reactivestreams.tck.support.TestException;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class SubscriberWhiteboxVerification<T> {
    private final TestEnvironment env;

    protected SubscriberWhiteboxVerification(TestEnvironment env) {
        this.env = env;
    }

    public abstract Subscriber<T> createSubscriber(WhiteboxSubscriberProbe<T> var1);

    public abstract Publisher<T> createHelperPublisher(long var1);

    public long maxOnNextSignalsInTest() {
        return 100L;
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.env.clearAsyncErrors();
    }

    @Test
    public void exerciseWhiteboxHappyPath() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage stage) throws InterruptedException {
                stage.puppet().triggerRequest(1L);
                stage.puppet().triggerRequest(1L);
                long receivedRequests = stage.expectRequest();
                stage.signalNext();
                stage.probe.expectNext(stage.lastT);
                stage.puppet().triggerRequest(1L);
                if (receivedRequests == 1L) {
                    stage.expectRequest();
                }
                stage.signalNext();
                stage.probe.expectNext(stage.lastT);
                stage.puppet().signalCancel();
                stage.expectCancelling();
                stage.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec201_mustSignalDemandViaSubscriptionRequest() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage stage) throws InterruptedException {
                stage.puppet().triggerRequest(1L);
                stage.expectRequest();
                stage.signalNext();
            }
        });
    }

    @Test
    public void spec202_shouldAsynchronouslyDispatch() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec203_mustNotCallMethodsOnSubscriptionOrPublisherInOnComplete() throws Throwable {
        this.subscriberTestWithoutSetup(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage stage) throws Throwable {
                Subscription subs = new Subscription(){

                    public void request(long n) {
                        Optional<StackTraceElement> onCompleteStackTraceElement = SubscriberWhiteboxVerification.this.env.findCallerMethodInStackTrace("onComplete");
                        if (onCompleteStackTraceElement.isDefined()) {
                            StackTraceElement stackElem = onCompleteStackTraceElement.get();
                            SubscriberWhiteboxVerification.this.env.flop(String.format("Subscription::request MUST NOT be called from Subscriber::onComplete (Rule 2.3)! (Caller: %s::%s line %d)", stackElem.getClassName(), stackElem.getMethodName(), stackElem.getLineNumber()));
                        }
                    }

                    public void cancel() {
                        Optional<StackTraceElement> onCompleteStackElement = SubscriberWhiteboxVerification.this.env.findCallerMethodInStackTrace("onComplete");
                        if (onCompleteStackElement.isDefined()) {
                            StackTraceElement stackElem = onCompleteStackElement.get();
                            SubscriberWhiteboxVerification.this.env.flop(String.format("Subscription::cancel MUST NOT be called from Subscriber::onComplete (Rule 2.3)! (Caller: %s::%s line %d)", stackElem.getClassName(), stackElem.getMethodName(), stackElem.getLineNumber()));
                        }
                    }
                };
                stage.probe = stage.createWhiteboxSubscriberProbe(SubscriberWhiteboxVerification.this.env);
                Subscriber sub = SubscriberWhiteboxVerification.this.createSubscriber(stage.probe);
                sub.onSubscribe(subs);
                sub.onComplete();
                SubscriberWhiteboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec203_mustNotCallMethodsOnSubscriptionOrPublisherInOnError() throws Throwable {
        this.subscriberTestWithoutSetup(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage stage) throws Throwable {
                Subscription subs = new Subscription(){

                    public void request(long n) {
                        Throwable thr = new Throwable();
                        for (StackTraceElement stackElem : thr.getStackTrace()) {
                            if (!stackElem.getMethodName().equals("onError")) continue;
                            SubscriberWhiteboxVerification.this.env.flop(String.format("Subscription::request MUST NOT be called from Subscriber::onError (Rule 2.3)! (Caller: %s::%s line %d)", stackElem.getClassName(), stackElem.getMethodName(), stackElem.getLineNumber()));
                        }
                    }

                    public void cancel() {
                        Throwable thr = new Throwable();
                        for (StackTraceElement stackElem : thr.getStackTrace()) {
                            if (!stackElem.getMethodName().equals("onError")) continue;
                            SubscriberWhiteboxVerification.this.env.flop(String.format("Subscription::cancel MUST NOT be called from Subscriber::onError (Rule 2.3)! (Caller: %s::%s line %d)", stackElem.getClassName(), stackElem.getMethodName(), stackElem.getLineNumber()));
                        }
                    }
                };
                stage.probe = stage.createWhiteboxSubscriberProbe(SubscriberWhiteboxVerification.this.env);
                Subscriber sub = SubscriberWhiteboxVerification.this.createSubscriber(stage.probe);
                sub.onSubscribe(subs);
                sub.onError((Throwable)new TestException());
                SubscriberWhiteboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec204_mustConsiderTheSubscriptionAsCancelledInAfterRecievingOnCompleteOrOnError() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec205_mustCallSubscriptionCancelIfItAlreadyHasAnSubscriptionAndReceivesAnotherOnSubscribeSignal() throws Exception {
        new WhiteboxTestStage(this.env){
            {
                final TestEnvironment.Latch secondSubscriptionCancelled = new TestEnvironment.Latch(this.env);
                this.sub().onSubscribe(new Subscription(){

                    public void request(long elements) {
                        env.flop(String.format("Subscriber %s illegally called `subscription.request(%s)`", this.sub(), elements));
                    }

                    public void cancel() {
                        secondSubscriptionCancelled.close();
                    }

                    public String toString() {
                        return "SecondSubscription(should get cancelled)";
                    }
                });
                secondSubscriptionCancelled.expectClose("Expected 2nd Subscription given to subscriber to be cancelled, but `Subscription.cancel()` was not called.");
                this.env.verifyNoAsyncErrors();
            }
        };
    }

    @Test
    public void spec206_mustCallSubscriptionCancelIfItIsNoLongerValid() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec207_mustEnsureAllCallsOnItsSubscriptionTakePlaceFromTheSameThreadOrTakeCareOfSynchronization() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec208_mustBePreparedToReceiveOnNextSignalsAfterHavingCalledSubscriptionCancel() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage stage) throws InterruptedException {
                stage.puppet().triggerRequest(1L);
                stage.puppet().signalCancel();
                stage.signalNext();
                stage.puppet().triggerRequest(1L);
                stage.puppet().triggerRequest(1L);
                stage.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec209_mustBePreparedToReceiveAnOnCompleteSignalWithPrecedingRequestCall() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage stage) throws InterruptedException {
                stage.puppet().triggerRequest(1L);
                stage.sendCompletion();
                stage.probe.expectCompletion();
                stage.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec209_mustBePreparedToReceiveAnOnCompleteSignalWithoutPrecedingRequestCall() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage stage) throws InterruptedException {
                stage.sendCompletion();
                stage.probe.expectCompletion();
                stage.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec210_mustBePreparedToReceiveAnOnErrorSignalWithPrecedingRequestCall() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage stage) throws InterruptedException {
                stage.puppet().triggerRequest(1L);
                stage.puppet().triggerRequest(1L);
                TestException ex = new TestException();
                stage.sendError(ex);
                stage.probe.expectError(ex);
                SubscriberWhiteboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec210_mustBePreparedToReceiveAnOnErrorSignalWithoutPrecedingRequestCall() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage stage) throws InterruptedException {
                TestException ex = new TestException();
                stage.sendError(ex);
                stage.probe.expectError(ex);
                SubscriberWhiteboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec211_mustMakeSureThatAllCallsOnItsMethodsHappenBeforeTheProcessingOfTheRespectiveEvents() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec212_mustNotCallOnSubscribeMoreThanOnceBasedOnObjectEquality_specViolation() throws Throwable {
        this.optionalSubscriberTestWithoutSetup(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage stage) throws Exception {
                stage.pub = stage.createHelperPublisher(1L);
                stage.tees = new TestEnvironment.ManualSubscriberWithSubscriptionSupport(SubscriberWhiteboxVerification.this.env);
                SubscriberWhiteboxVerification.this.env.subscribe(stage.pub, stage.tees);
                stage.tees.expectNone();
                stage.pub.subscribe(stage.tees);
                stage.tees.expectError(Exception.class, "Should not allow subscribing the same instance multiple times, see Reactive Streams Specification Rule 2.12");
            }
        });
    }

    @Test
    public void spec213_failingOnSignalInvocation() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec301_mustNotBeCalledOutsideSubscriberContext() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec308_requestMustRegisterGivenNumberElementsToBeProduced() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage stage) throws InterruptedException {
                stage.puppet().triggerRequest(2L);
                stage.probe.expectNext(stage.signalNext());
                stage.probe.expectNext(stage.signalNext());
                stage.probe.expectNone();
                stage.puppet().triggerRequest(3L);
                stage.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec310_requestMaySynchronouslyCallOnNextOnSubscriber() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec311_requestMaySynchronouslyCallOnCompleteOrOnError() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec314_cancelMayCauseThePublisherToShutdownIfNoOtherSubscriptionExists() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec315_cancelMustNotThrowExceptionAndMustSignalOnError() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec316_requestMustNotThrowExceptionAndMustOnErrorTheSubscriber() throws Exception {
        this.notVerified();
    }

    public void subscriberTest(TestStageTestRun body) throws Throwable {
        WhiteboxTestStage stage = new WhiteboxTestStage(this.env, true);
        body.run(stage);
    }

    public void subscriberTestWithoutSetup(TestStageTestRun body) throws Throwable {
        WhiteboxTestStage stage = new WhiteboxTestStage(this.env, false);
        body.run(stage);
    }

    public void optionalSubscriberTestWithoutSetup(TestStageTestRun body) throws Throwable {
        try {
            this.subscriberTestWithoutSetup(body);
        }
        catch (Exception ex) {
            this.notVerified("Skipped because tested publisher does NOT implement this OPTIONAL requirement.");
        }
    }

    public void notVerified() {
        throw new SkipException("Not verified using this TCK.");
    }

    public void notVerified(String msg) {
        throw new SkipException(msg);
    }

    public static interface SubscriberPuppet {
        public void triggerRequest(long var1);

        public void signalCancel();
    }

    public static interface SubscriberProbe<T> {
        public void registerOnNext(T var1);

        public void registerOnComplete();

        public void registerOnError(Throwable var1);
    }

    public static interface SubscriberPuppeteer {
        public void registerOnSubscribe(SubscriberPuppet var1);
    }

    public static class WhiteboxSubscriberProbe<T>
    extends BlackboxProbe<T>
    implements SubscriberPuppeteer {
        protected TestEnvironment.Promise<SubscriberPuppet> puppet;

        public WhiteboxSubscriberProbe(TestEnvironment env, TestEnvironment.Promise<Subscriber<? super T>> subscriber) {
            super(env, subscriber);
            this.puppet = new TestEnvironment.Promise(env);
        }

        private SubscriberPuppet puppet() {
            return this.puppet.value();
        }

        @Override
        public void registerOnSubscribe(SubscriberPuppet p) {
            if (!this.puppet.isCompleted()) {
                this.puppet.complete(p);
            } else {
                this.env.flop(String.format("Subscriber %s illegally accepted a second Subscription", this.sub()));
            }
        }
    }

    public static class BlackboxProbe<T>
    implements SubscriberProbe<T> {
        protected final TestEnvironment env;
        protected final TestEnvironment.Promise<Subscriber<? super T>> subscriber;
        protected final TestEnvironment.Receptacle<T> elements;
        protected final TestEnvironment.Promise<Throwable> error;

        public BlackboxProbe(TestEnvironment env, TestEnvironment.Promise<Subscriber<? super T>> subscriber) {
            this.env = env;
            this.subscriber = subscriber;
            this.elements = new TestEnvironment.Receptacle(env);
            this.error = new TestEnvironment.Promise(env);
        }

        @Override
        public void registerOnNext(T element) {
            this.elements.add(element);
        }

        @Override
        public void registerOnComplete() {
            try {
                this.elements.complete();
            }
            catch (IllegalStateException ex) {
                this.env.flop("subscriber::onComplete was called a second time, which is illegal according to Rule 1.7");
            }
        }

        @Override
        public void registerOnError(Throwable cause) {
            try {
                this.error.complete(cause);
            }
            catch (IllegalStateException ex) {
                this.env.flop("subscriber::onError was called a second time, which is illegal according to Rule 1.7");
            }
        }

        public T expectNext() throws InterruptedException {
            return this.elements.next(this.env.defaultTimeoutMillis(), String.format("Subscriber %s did not call `registerOnNext(_)`", this.sub()));
        }

        public void expectNext(T expected) throws InterruptedException {
            this.expectNext(expected, this.env.defaultTimeoutMillis());
        }

        public void expectNext(T expected, long timeoutMillis) throws InterruptedException {
            T received = this.elements.next(timeoutMillis, String.format("Subscriber %s did not call `registerOnNext(%s)`", this.sub(), expected));
            if (!received.equals(expected)) {
                this.env.flop(String.format("Subscriber %s called `registerOnNext(%s)` rather than `registerOnNext(%s)`", this.sub(), received, expected));
            }
        }

        public Subscriber<? super T> sub() {
            return this.subscriber.value();
        }

        public void expectCompletion() throws InterruptedException {
            this.expectCompletion(this.env.defaultTimeoutMillis());
        }

        public void expectCompletion(long timeoutMillis) throws InterruptedException {
            this.expectCompletion(timeoutMillis, String.format("Subscriber %s did not call `registerOnComplete()`", this.sub()));
        }

        public void expectCompletion(long timeoutMillis, String msg) throws InterruptedException {
            this.elements.expectCompletion(timeoutMillis, msg);
        }

        public <E extends Throwable> void expectErrorWithMessage(Class<E> expected, String requiredMessagePart) throws InterruptedException {
            E err = this.expectError(expected);
            String message = ((Throwable)err).getMessage();
            Assert.assertTrue((boolean)message.contains(requiredMessagePart), (String)String.format("Got expected exception %s but missing message [%s], was: %s", err.getClass(), requiredMessagePart, expected));
        }

        public <E extends Throwable> E expectError(Class<E> expected) throws InterruptedException {
            return this.expectError(expected, this.env.defaultTimeoutMillis());
        }

        public <E extends Throwable> E expectError(Class<E> expected, long timeoutMillis) throws InterruptedException {
            this.error.expectCompletion(timeoutMillis, String.format("Subscriber %s did not call `registerOnError(%s)`", this.sub(), expected));
            if (this.error.value() == null) {
                return (E)((Throwable)this.env.flopAndFail(String.format("Subscriber %s did not call `registerOnError(%s)`", this.sub(), expected)));
            }
            if (expected.isInstance(this.error.value())) {
                return (E)this.error.value();
            }
            return (E)((Throwable)this.env.flopAndFail(String.format("Subscriber %s called `registerOnError(%s)` rather than `registerOnError(%s)`", this.sub(), this.error.value(), expected)));
        }

        public void expectError(Throwable expected) throws InterruptedException {
            this.expectError(expected, this.env.defaultTimeoutMillis());
        }

        public void expectError(Throwable expected, long timeoutMillis) throws InterruptedException {
            this.error.expectCompletion(timeoutMillis, String.format("Subscriber %s did not call `registerOnError(%s)`", this.sub(), expected));
            if (this.error.value() != expected) {
                this.env.flop(String.format("Subscriber %s called `registerOnError(%s)` rather than `registerOnError(%s)`", this.sub(), this.error.value(), expected));
            }
        }

        public void expectNone() throws InterruptedException {
            this.expectNone(this.env.defaultTimeoutMillis());
        }

        public void expectNone(long withinMillis) throws InterruptedException {
            this.elements.expectNone(withinMillis, "Expected nothing");
        }
    }

    public static class BlackboxSubscriberProxy<T>
    extends BlackboxProbe<T>
    implements Subscriber<T> {
        public BlackboxSubscriberProxy(TestEnvironment env, Subscriber<T> subscriber) {
            super(env, TestEnvironment.Promise.completed(env, subscriber));
        }

        public void onSubscribe(Subscription s) {
            this.sub().onSubscribe(s);
        }

        public void onNext(T t) {
            this.registerOnNext(t);
            this.sub().onNext(t);
        }

        public void onError(Throwable cause) {
            this.registerOnError(cause);
            this.sub().onError(cause);
        }

        public void onComplete() {
            this.registerOnComplete();
            this.sub().onComplete();
        }
    }

    public class WhiteboxTestStage
    extends TestEnvironment.ManualPublisher<T> {
        public Publisher<T> pub;
        public TestEnvironment.ManualSubscriber<T> tees;
        public WhiteboxSubscriberProbe<T> probe;
        public T lastT;

        public WhiteboxTestStage(TestEnvironment env) throws InterruptedException {
            this(env, true);
        }

        public WhiteboxTestStage(TestEnvironment env, boolean runDefaultInit) throws InterruptedException {
            super(env);
            this.lastT = null;
            if (runDefaultInit) {
                this.pub = this.createHelperPublisher(Long.MAX_VALUE);
                this.tees = env.newManualSubscriber(this.pub);
                this.probe = new WhiteboxSubscriberProbe(env, this.subscriber);
                this.subscribe(SubscriberWhiteboxVerification.this.createSubscriber(this.probe));
                this.probe.puppet.expectCompletion(env.defaultTimeoutMillis(), String.format("Subscriber %s did not `registerOnSubscribe`", this.sub()));
            }
        }

        public Subscriber<? super T> sub() {
            return (Subscriber)this.subscriber.value();
        }

        public SubscriberPuppet puppet() {
            return this.probe.puppet();
        }

        public WhiteboxSubscriberProbe<T> probe() {
            return this.probe;
        }

        public Publisher<T> createHelperPublisher(long elements) {
            return SubscriberWhiteboxVerification.this.createHelperPublisher(elements);
        }

        public WhiteboxSubscriberProbe<T> createWhiteboxSubscriberProbe(TestEnvironment env) {
            return new WhiteboxSubscriberProbe(env, this.subscriber);
        }

        public T signalNext() throws InterruptedException {
            Object element = this.nextT();
            this.sendNext(element);
            return element;
        }

        public T nextT() throws InterruptedException {
            this.lastT = this.tees.requestNextElement();
            return this.lastT;
        }

        public void verifyNoAsyncErrors() {
            this.env.verifyNoAsyncErrors();
        }
    }

    abstract class TestStageTestRun {
        TestStageTestRun() {
        }

        public abstract void run(WhiteboxTestStage var1) throws Throwable;
    }
}

