/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.tck;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.reactivestreams.tck.SubscriberWhiteboxVerification;
import org.reactivestreams.tck.TestEnvironment;
import org.reactivestreams.tck.support.Optional;
import org.reactivestreams.tck.support.TestException;
import org.testng.SkipException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class SubscriberBlackboxVerification<T> {
    private final TestEnvironment env;

    protected SubscriberBlackboxVerification(TestEnvironment env) {
        this.env = env;
    }

    public abstract Subscriber<T> createSubscriber();

    public abstract Publisher<T> createHelperPublisher(long var1);

    @BeforeMethod
    public void setUp() throws Exception {
        this.env.clearAsyncErrors();
    }

    @Test
    public void spec201_blackbox_mustSignalDemandViaSubscriptionRequest() throws Throwable {
        this.blackboxSubscriberTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws InterruptedException {
                long n = stage.expectRequest();
                int i = 0;
                while ((long)i < n) {
                    stage.signalNext();
                    ++i;
                }
            }
        });
    }

    @Test
    public void spec202_blackbox_shouldAsynchronouslyDispatch() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec203_blackbox_mustNotCallMethodsOnSubscriptionOrPublisherInOnComplete() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                Subscription subs = new Subscription(){

                    public void request(long n) {
                        Optional<StackTraceElement> onCompleteStackTraceElement = SubscriberBlackboxVerification.this.env.findCallerMethodInStackTrace("onComplete");
                        if (onCompleteStackTraceElement.isDefined()) {
                            StackTraceElement stackElem = onCompleteStackTraceElement.get();
                            SubscriberBlackboxVerification.this.env.flop(String.format("Subscription::request MUST NOT be called from Subscriber::onComplete (Rule 2.3)! (Caller: %s::%s line %d)", stackElem.getClassName(), stackElem.getMethodName(), stackElem.getLineNumber()));
                        }
                    }

                    public void cancel() {
                        Optional<StackTraceElement> onCompleteStackElement = SubscriberBlackboxVerification.this.env.findCallerMethodInStackTrace("onComplete");
                        if (onCompleteStackElement.isDefined()) {
                            StackTraceElement stackElem = onCompleteStackElement.get();
                            SubscriberBlackboxVerification.this.env.flop(String.format("Subscription::cancel MUST NOT be called from Subscriber::onComplete (Rule 2.3)! (Caller: %s::%s line %d)", stackElem.getClassName(), stackElem.getMethodName(), stackElem.getLineNumber()));
                        }
                    }
                };
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                sub.onSubscribe(subs);
                sub.onComplete();
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec203_blackbox_mustNotCallMethodsOnSubscriptionOrPublisherInOnError() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                Subscription subs = new Subscription(){

                    public void request(long n) {
                        Throwable thr = new Throwable();
                        for (StackTraceElement stackElem : thr.getStackTrace()) {
                            if (!stackElem.getMethodName().equals("onError")) continue;
                            SubscriberBlackboxVerification.this.env.flop(String.format("Subscription::request MUST NOT be called from Subscriber::onError (Rule 2.3)! (Caller: %s::%s line %d)", stackElem.getClassName(), stackElem.getMethodName(), stackElem.getLineNumber()));
                        }
                    }

                    public void cancel() {
                        Throwable thr = new Throwable();
                        for (StackTraceElement stackElem : thr.getStackTrace()) {
                            if (!stackElem.getMethodName().equals("onError")) continue;
                            SubscriberBlackboxVerification.this.env.flop(String.format("Subscription::cancel MUST NOT be called from Subscriber::onError (Rule 2.3)! (Caller: %s::%s line %d)", stackElem.getClassName(), stackElem.getMethodName(), stackElem.getLineNumber()));
                        }
                    }
                };
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                sub.onSubscribe(subs);
                sub.onError((Throwable)new TestException());
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec204_blackbox_mustConsiderTheSubscriptionAsCancelledInAfterRecievingOnCompleteOrOnError() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec205_blackbox_mustCallSubscriptionCancelIfItAlreadyHasAnSubscriptionAndReceivesAnotherOnSubscribeSignal() throws Exception {
        new BlackboxTestStage(this.env){
            {
                final TestEnvironment.Latch secondSubscriptionCancelled = new TestEnvironment.Latch(this.env);
                this.sub().onSubscribe(new Subscription(){

                    public void request(long elements) {
                        env.flop(String.format("Subscriber %s illegally called `subscription.request(%s)`!", this.sub(), elements));
                    }

                    public void cancel() {
                        secondSubscriptionCancelled.close();
                    }

                    public String toString() {
                        return "SecondSubscription(should get cancelled)";
                    }
                });
                secondSubscriptionCancelled.expectClose("Expected SecondSubscription given to subscriber to be cancelled, but `Subscription.cancel()` was not called.");
                this.env.verifyNoAsyncErrors();
            }
        };
    }

    @Test
    public void spec206_blackbox_mustCallSubscriptionCancelIfItIsNoLongerValid() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec207_blackbox_mustEnsureAllCallsOnItsSubscriptionTakePlaceFromTheSameThreadOrTakeCareOfSynchronization() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec208_blackbox_mustBePreparedToReceiveOnNextSignalsAfterHavingCalledSubscriptionCancel() throws Throwable {
        this.notVerified();
    }

    @Test
    public void spec209_blackbox_mustBePreparedToReceiveAnOnCompleteSignalWithPrecedingRequestCall() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                Publisher pub = SubscriberBlackboxVerification.this.createHelperPublisher(0L);
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                SubscriberWhiteboxVerification.BlackboxSubscriberProxy probe = stage.createBlackboxSubscriberProxy(SubscriberBlackboxVerification.this.env, sub);
                pub.subscribe(probe);
                probe.expectCompletion();
                probe.expectNone();
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec209_blackbox_mustBePreparedToReceiveAnOnCompleteSignalWithoutPrecedingRequestCall() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                Publisher pub = new Publisher<T>(){

                    public void subscribe(Subscriber<? super T> s) {
                        s.onComplete();
                    }
                };
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                SubscriberWhiteboxVerification.BlackboxSubscriberProxy probe = stage.createBlackboxSubscriberProxy(SubscriberBlackboxVerification.this.env, sub);
                pub.subscribe(probe);
                probe.expectCompletion();
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec210_blackbox_mustBePreparedToReceiveAnOnErrorSignalWithPrecedingRequestCall() throws Throwable {
        this.blackboxSubscriberTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage stage) throws Throwable {
                stage.sub().onError((Throwable)new TestException());
                stage.subProxy().expectError(Throwable.class);
            }
        });
    }

    @Test
    public void spec211_blackbox_mustMakeSureThatAllCallsOnItsMethodsHappenBeforeTheProcessingOfTheRespectiveEvents() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec212_blackbox_mustNotCallOnSubscribeMoreThanOnceBasedOnObjectEquality() throws Throwable {
        this.notVerified();
    }

    @Test
    public void spec213_blackbox_failingOnSignalInvocation() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec301_blackbox_mustNotBeCalledOutsideSubscriberContext() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec308_blackbox_requestMustRegisterGivenNumberElementsToBeProduced() throws Throwable {
        this.notVerified();
    }

    @Test
    public void spec310_blackbox_requestMaySynchronouslyCallOnNextOnSubscriber() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec311_blackbox_requestMaySynchronouslyCallOnCompleteOrOnError() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec314_blackbox_cancelMayCauseThePublisherToShutdownIfNoOtherSubscriptionExists() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec315_blackbox_cancelMustNotThrowExceptionAndMustSignalOnError() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec316_blackbox_requestMustNotThrowExceptionAndMustOnErrorTheSubscriber() throws Exception {
        this.notVerified();
    }

    public void blackboxSubscriberTest(BlackboxTestStageTestRun body) throws Throwable {
        BlackboxTestStage stage = new BlackboxTestStage(this.env, true);
        body.run(stage);
    }

    public void blackboxSubscriberWithoutSetupTest(BlackboxTestStageTestRun body) throws Throwable {
        BlackboxTestStage stage = new BlackboxTestStage(this.env, false);
        body.run(stage);
    }

    public void notVerified() {
        throw new SkipException("Not verified using this TCK.");
    }

    public class BlackboxTestStage
    extends TestEnvironment.ManualPublisher<T> {
        public Publisher<T> pub;
        public TestEnvironment.ManualSubscriber<T> tees;
        public T lastT;
        private Optional<SubscriberWhiteboxVerification.BlackboxSubscriberProxy<T>> subProxy;

        public BlackboxTestStage(TestEnvironment env) throws InterruptedException {
            this(env, true);
        }

        public BlackboxTestStage(TestEnvironment env, boolean runDefaultInit) throws InterruptedException {
            super(env);
            this.lastT = null;
            this.subProxy = Optional.empty();
            if (runDefaultInit) {
                this.pub = this.createHelperPublisher(Long.MAX_VALUE);
                this.tees = env.newManualSubscriber(this.pub);
                Subscriber sub = SubscriberBlackboxVerification.this.createSubscriber();
                this.subProxy = Optional.of(this.createBlackboxSubscriberProxy(env, sub));
                this.subscribe(this.subProxy.get());
            }
        }

        public Subscriber<? super T> sub() {
            return (Subscriber)this.subscriber.value();
        }

        public SubscriberWhiteboxVerification.BlackboxSubscriberProxy<T> subProxy() {
            return this.subProxy.get();
        }

        public Publisher<T> createHelperPublisher(long elements) {
            return SubscriberBlackboxVerification.this.createHelperPublisher(elements);
        }

        public SubscriberWhiteboxVerification.BlackboxSubscriberProxy<T> createBlackboxSubscriberProxy(TestEnvironment env, Subscriber<T> sub) {
            return new SubscriberWhiteboxVerification.BlackboxSubscriberProxy(env, sub);
        }

        public T signalNext() throws InterruptedException {
            Object element = this.nextT();
            this.sendNext(element);
            return element;
        }

        public T nextT() throws InterruptedException {
            this.lastT = this.tees.requestNextElement();
            return this.lastT;
        }
    }

    abstract class BlackboxTestStageTestRun {
        BlackboxTestStageTestRun() {
        }

        public abstract void run(BlackboxTestStage var1) throws Throwable;
    }
}

