/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.tck;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.reactivestreams.tck.support.Optional;
import org.testng.Assert;

public class TestEnvironment {
    public static final int TEST_BUFFER_SIZE = 16;
    private final long defaultTimeoutMillis;
    private final boolean printlnDebug;
    private CopyOnWriteArrayList<Throwable> asyncErrors = new CopyOnWriteArrayList();

    public TestEnvironment(long defaultTimeoutMillis, boolean printlnDebug) {
        this.defaultTimeoutMillis = defaultTimeoutMillis;
        this.printlnDebug = printlnDebug;
    }

    public TestEnvironment(long defaultTimeoutMillis) {
        this(defaultTimeoutMillis, false);
    }

    public long defaultTimeoutMillis() {
        return this.defaultTimeoutMillis;
    }

    public void flop(String msg) {
        try {
            Assert.fail((String)msg);
        }
        catch (Throwable t) {
            this.asyncErrors.add(t);
        }
    }

    public void flop(Throwable thr, String msg) {
        try {
            Assert.fail((String)msg, (Throwable)thr);
        }
        catch (Throwable t) {
            this.asyncErrors.add(thr);
        }
    }

    public <T extends Throwable> void expectThrowingOfWithMessage(Class<T> clazz, String requiredMessagePart, Runnable block) throws Throwable {
        String errorMsg = String.format("Expected [%s] to be thrown", clazz);
        try {
            block.run();
            throw new AssertionError((Object)("Expected " + clazz.getCanonicalName() + ", yet no exception was thrown!"));
        }
        catch (Throwable e) {
            if (!clazz.isInstance(e)) {
                String msg = errorMsg + " but was: " + e;
                this.flop(e, msg);
                throw new AssertionError((Object)msg);
            }
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.contains(requiredMessagePart), (String)String.format("Got expected exception [%s] but missing message part [%s], was: %s", e.getClass(), requiredMessagePart, message));
            return;
        }
    }

    public <T extends Throwable> void assertAsyncErrorWithMessage(Class<T> clazz, String requiredMessagePart) throws Throwable {
        this.assertErrorWithMessage(this.dropAsyncError(), clazz, requiredMessagePart);
    }

    public <T extends Throwable> void assertErrorWithMessage(Throwable err, Class<T> clazz, String requiredMessagePart) throws Throwable {
        Assert.assertNotNull((Object)err, (String)("Expected " + clazz.getCanonicalName() + " exception but got null!"));
        Assert.assertTrue((boolean)clazz.isInstance(err), (String)("Expected " + clazz.getCanonicalName() + " exception but got " + err.getClass().getCanonicalName() + "!"));
        String message = err.getMessage();
        Assert.assertTrue((boolean)message.contains(requiredMessagePart), (String)String.format("Got expected exception [%s] but missing message part [%s], was: %s", err.getClass(), requiredMessagePart, message));
    }

    public <T> void subscribe(Publisher<T> pub, TestSubscriber<T> sub) throws InterruptedException {
        this.subscribe(pub, sub, this.defaultTimeoutMillis);
    }

    public <T> void subscribe(Publisher<T> pub, TestSubscriber<T> sub, long timeoutMillis) throws InterruptedException {
        pub.subscribe(sub);
        sub.subscription.expectCompletion(timeoutMillis, String.format("Could not subscribe %s to Publisher %s", sub, pub));
        this.verifyNoAsyncErrors();
    }

    public <T> ManualSubscriber<T> newBlackholeSubscriber(Publisher<T> pub) throws InterruptedException {
        BlackholeSubscriberWithSubscriptionSupport sub = new BlackholeSubscriberWithSubscriptionSupport(this);
        this.subscribe(pub, sub, this.defaultTimeoutMillis());
        return sub;
    }

    public <T> ManualSubscriber<T> newManualSubscriber(Publisher<T> pub) throws InterruptedException {
        return this.newManualSubscriber(pub, this.defaultTimeoutMillis());
    }

    public <T> ManualSubscriber<T> newManualSubscriber(Publisher<T> pub, long timeoutMillis) throws InterruptedException {
        ManualSubscriberWithSubscriptionSupport sub = new ManualSubscriberWithSubscriptionSupport(this);
        this.subscribe(pub, sub, timeoutMillis);
        return sub;
    }

    public void clearAsyncErrors() {
        this.asyncErrors.clear();
    }

    public Throwable dropAsyncError() {
        try {
            return this.asyncErrors.remove(0);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public void verifyNoAsyncErrors(long delay) {
        try {
            Thread.sleep(delay);
            this.verifyNoAsyncErrors();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void verifyNoAsyncErrors() {
        for (Throwable e : this.asyncErrors) {
            if (e instanceof AssertionError) {
                throw (AssertionError)((Object)e);
            }
            Assert.fail((String)("Async error during test execution: " + e.getMessage()), (Throwable)e);
        }
    }

    public void debug(String msg) {
        if (this.printlnDebug) {
            System.out.println("[TCK-DEBUG] " + msg);
        }
    }

    public static class Receptacle<T> {
        final int QUEUE_SIZE = 32;
        private final TestEnvironment env;
        private final ArrayBlockingQueue<Optional<T>> abq = new ArrayBlockingQueue(32);
        private final Latch completedLatch;

        Receptacle(TestEnvironment env) {
            this.env = env;
            this.completedLatch = new Latch(env);
        }

        public void add(T value) {
            this.completedLatch.assertOpen(String.format("Unexpected element %s received after stream completed", value));
            this.abq.add(Optional.of(value));
        }

        public void complete() {
            this.completedLatch.assertOpen("Unexpected additional complete signal received!");
            this.completedLatch.close();
            this.abq.add(Optional.empty());
        }

        public T next(long timeoutMillis, String errorMsg) throws InterruptedException {
            Optional<T> value = this.abq.poll(timeoutMillis, TimeUnit.MILLISECONDS);
            if (value == null) {
                this.env.flop(String.format("%s within %d ms", errorMsg, timeoutMillis));
            } else {
                if (value.isDefined()) {
                    return value.get();
                }
                this.env.flop("Expected element but got end-of-stream");
            }
            return null;
        }

        public Optional<T> nextOrEndOfStream(long timeoutMillis, String errorMsg) throws InterruptedException {
            Optional<T> value = this.abq.poll(timeoutMillis, TimeUnit.MILLISECONDS);
            if (value == null) {
                this.env.flop(String.format("%s within %d ms", errorMsg, timeoutMillis));
            }
            return value;
        }

        public List<T> nextN(long elements, long timeoutMillis, String errorMsg) throws InterruptedException {
            LinkedList<T> result = new LinkedList<T>();
            long deadline = System.currentTimeMillis() + timeoutMillis;
            for (long remaining = elements; remaining > 0L; --remaining) {
                long remainingMillis = deadline - System.currentTimeMillis();
                result.add(this.next(remainingMillis, errorMsg));
            }
            return result;
        }

        public void expectCompletion(long timeoutMillis, String errorMsg) throws InterruptedException {
            Optional<T> value = this.abq.poll(timeoutMillis, TimeUnit.MILLISECONDS);
            if (value == null) {
                this.env.flop(String.format("%s within %d ms", errorMsg, timeoutMillis));
            } else if (value.isDefined()) {
                this.env.flop("Expected end-of-stream but got " + value.get());
            }
        }

        public <E extends Throwable> E expectError(Class<E> clazz, long timeoutMillis, String errorMsg) throws Exception {
            Thread.sleep(timeoutMillis);
            if (this.env.asyncErrors.isEmpty()) {
                this.env.flop(String.format("%s within %d ms", errorMsg, timeoutMillis));
            } else {
                Throwable thrown = (Throwable)this.env.asyncErrors.remove(0);
                if (clazz.isInstance(thrown)) {
                    return (E)thrown;
                }
                this.env.flop(String.format("%s within %d ms; Got %s but expected %s", errorMsg, timeoutMillis, thrown.getClass().getCanonicalName(), clazz.getCanonicalName()));
            }
            return null;
        }

        public void expectError(long timeoutMillis, String errorMsg) throws Exception {
            Thread.sleep(timeoutMillis);
            if (this.env.asyncErrors.isEmpty()) {
                this.env.flop(String.format("%s within %d ms", errorMsg, timeoutMillis));
            } else {
                this.env.asyncErrors.remove(0);
            }
        }

        public void expectNone(long withinMillis, String errorMsgPrefix) throws InterruptedException {
            Thread.sleep(withinMillis);
            Optional<T> value = this.abq.poll();
            if (value != null) {
                if (value.isDefined()) {
                    this.env.flop(errorMsgPrefix + value.get());
                } else {
                    this.env.flop("Expected no element but got end-of-stream");
                }
            }
        }
    }

    public static class Promise<T> {
        private final TestEnvironment env;
        private ArrayBlockingQueue<T> abq = new ArrayBlockingQueue(1);
        private volatile T _value = null;

        public static <T> Promise<T> completed(TestEnvironment env, T value) {
            Promise<T> promise = new Promise<T>(env);
            promise.completeImmediatly(value);
            return promise;
        }

        public Promise(TestEnvironment env) {
            this.env = env;
        }

        public T value() {
            if (this.isCompleted()) {
                return this._value;
            }
            this.env.flop("Cannot access promise value before completion");
            return null;
        }

        public boolean isCompleted() {
            return this._value != null;
        }

        public void complete(T value) {
            this.abq.add(value);
        }

        public void completeImmediatly(T value) {
            this.complete(value);
            this._value = value;
        }

        public void expectCompletion(long timeoutMillis, String errorMsg) throws InterruptedException {
            if (!this.isCompleted()) {
                T val = this.abq.poll(timeoutMillis, TimeUnit.MILLISECONDS);
                if (val == null) {
                    this.env.flop(String.format("%s within %d ms", errorMsg, timeoutMillis));
                } else {
                    this._value = val;
                }
            }
        }
    }

    public static class Latch {
        private final TestEnvironment env;
        private volatile CountDownLatch countDownLatch = new CountDownLatch(1);

        public Latch(TestEnvironment env) {
            this.env = env;
        }

        public void reOpen() {
            this.countDownLatch = new CountDownLatch(1);
        }

        public boolean isClosed() {
            return this.countDownLatch.getCount() == 0L;
        }

        public void close() {
            this.countDownLatch.countDown();
        }

        public void assertClosed(String openErrorMsg) {
            if (!this.isClosed()) {
                this.env.flop(openErrorMsg);
            }
        }

        public void assertOpen(String closedErrorMsg) {
            if (this.isClosed()) {
                this.env.flop(closedErrorMsg);
            }
        }

        public void expectClose(String notClosedErrorMsg) throws InterruptedException {
            this.expectClose(this.env.defaultTimeoutMillis(), notClosedErrorMsg);
        }

        public void expectClose(long timeoutMillis, String notClosedErrorMsg) throws InterruptedException {
            this.countDownLatch.await(timeoutMillis, TimeUnit.MILLISECONDS);
            if (this.countDownLatch.getCount() > 0L) {
                this.env.flop(String.format("%s within %d ms", notClosedErrorMsg, timeoutMillis));
            }
        }
    }

    public static class ManualPublisher<T>
    implements Publisher<T> {
        protected final TestEnvironment env;
        protected long pendingDemand = 0L;
        protected Promise<Subscriber<? super T>> subscriber;
        protected final Receptacle<Long> requests;
        protected final Latch cancelled;

        public ManualPublisher(TestEnvironment env) {
            this.env = env;
            this.requests = new Receptacle(env);
            this.cancelled = new Latch(env);
            this.subscriber = new Promise(this.env);
        }

        public void subscribe(Subscriber<? super T> s) {
            if (!this.subscriber.isCompleted()) {
                this.subscriber.completeImmediatly(s);
                Subscription subs = new Subscription(){

                    public void request(long elements) {
                        ManualPublisher.this.requests.add(elements);
                    }

                    public void cancel() {
                        ManualPublisher.this.cancelled.close();
                    }
                };
                s.onSubscribe(subs);
            } else {
                this.env.flop("TestPublisher doesn't support more than one Subscriber");
            }
        }

        public void sendNext(T element) {
            if (this.subscriber.isCompleted()) {
                this.subscriber.value().onNext(element);
            } else {
                this.env.flop("Cannot sendNext before having a Subscriber");
            }
        }

        public void sendCompletion() {
            if (this.subscriber.isCompleted()) {
                this.subscriber.value().onComplete();
            } else {
                this.env.flop("Cannot sendCompletion before having a Subscriber");
            }
        }

        public void sendError(Throwable cause) {
            if (this.subscriber.isCompleted()) {
                this.subscriber.value().onError(cause);
            } else {
                this.env.flop("Cannot sendError before having a Subscriber");
            }
        }

        public long expectRequest() throws InterruptedException {
            return this.expectRequest(this.env.defaultTimeoutMillis());
        }

        public long expectRequest(long timeoutMillis) throws InterruptedException {
            long requested = this.requests.next(timeoutMillis, "Did not receive expected `request` call");
            if (requested <= 0L) {
                this.env.flop(String.format("Requests cannot be zero or negative but received request(%s)", requested));
                return 0L;
            }
            this.pendingDemand += requested;
            return requested;
        }

        public void expectExactRequest(long expected) throws InterruptedException {
            this.expectExactRequest(expected, this.env.defaultTimeoutMillis());
        }

        public void expectExactRequest(long expected, long timeoutMillis) throws InterruptedException {
            long requested = this.expectRequest(timeoutMillis);
            if (requested != expected) {
                this.env.flop(String.format("Received `request(%d)` on upstream but expected `request(%d)`", requested, expected));
            }
            this.pendingDemand += requested;
        }

        public void expectNoRequest() throws InterruptedException {
            this.expectNoRequest(this.env.defaultTimeoutMillis());
        }

        public void expectNoRequest(long timeoutMillis) throws InterruptedException {
            this.requests.expectNone(timeoutMillis, "Received an unexpected call to: request: ");
        }

        public void expectCancelling() throws InterruptedException {
            this.expectCancelling(this.env.defaultTimeoutMillis());
        }

        public void expectCancelling(long timeoutMillis) throws InterruptedException {
            this.cancelled.expectClose(timeoutMillis, "Did not receive expected cancelling of upstream subscription");
        }
    }

    public static class TestSubscriber<T>
    implements Subscriber<T> {
        final Promise<Subscription> subscription;
        protected final TestEnvironment env;

        public TestSubscriber(TestEnvironment env) {
            this.env = env;
            this.subscription = new Promise(env);
        }

        public void onError(Throwable cause) {
            this.env.flop(cause, String.format("Unexpected Subscriber::onError(%s)", cause));
        }

        public void onComplete() {
            this.env.flop("Unexpected Subscriber::onComplete()");
        }

        public void onNext(T element) {
            this.env.flop(String.format("Unexpected Subscriber::onNext(%s)", element));
        }

        public void onSubscribe(Subscription subscription) {
            this.env.flop(String.format("Unexpected Subscriber::onSubscribe(%s)", subscription));
        }

        public void cancel() {
            if (this.subscription.isCompleted()) {
                this.subscription.value().cancel();
            } else {
                this.env.flop("Cannot cancel a subscription before having received it");
            }
        }
    }

    public static class BlackholeSubscriberWithSubscriptionSupport<T>
    extends ManualSubscriberWithSubscriptionSupport<T> {
        public BlackholeSubscriberWithSubscriptionSupport(TestEnvironment env) {
            super(env);
        }

        @Override
        public void onNext(T element) {
            this.env.debug(this + "::onNext(" + element + ")");
            if (!this.subscription.isCompleted()) {
                this.env.flop("Subscriber::onNext(" + element + ") called before Subscriber::onSubscribe");
            }
        }

        @Override
        public T nextElement(long timeoutMillis, String errorMsg) throws InterruptedException {
            throw new RuntimeException("Can not expect elements from BlackholeSubscriber, use ManualSubscriber instead!");
        }

        @Override
        public List<T> nextElements(long elements, long timeoutMillis, String errorMsg) throws InterruptedException {
            throw new RuntimeException("Can not expect elements from BlackholeSubscriber, use ManualSubscriber instead!");
        }
    }

    public static class ManualSubscriberWithSubscriptionSupport<T>
    extends ManualSubscriber<T> {
        public ManualSubscriberWithSubscriptionSupport(TestEnvironment env) {
            super(env);
        }

        @Override
        public void onNext(T element) {
            this.env.debug(this + "::onNext(" + element + ")");
            if (this.subscription.isCompleted()) {
                super.onNext(element);
            } else {
                this.env.flop("Subscriber::onNext(" + element + ") called before Subscriber::onSubscribe");
            }
        }

        @Override
        public void onComplete() {
            this.env.debug(this + "::onComplete()");
            if (this.subscription.isCompleted()) {
                super.onComplete();
            } else {
                this.env.flop("Subscriber::onComplete() called before Subscriber::onSubscribe");
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.env.debug(this + "::onSubscribe(" + s + ")");
            if (!this.subscription.isCompleted()) {
                this.subscription.complete(s);
            } else {
                this.env.flop("Subscriber::onSubscribe called on an already-subscribed Subscriber");
            }
        }

        @Override
        public void onError(Throwable cause) {
            this.env.debug(this + "::onError(" + cause + ")");
            if (this.subscription.isCompleted()) {
                super.onError(cause);
            } else {
                this.env.flop(cause, "Subscriber::onError(" + cause + ") called before Subscriber::onSubscribe");
            }
        }
    }

    public static class ManualSubscriber<T>
    extends TestSubscriber<T> {
        Receptacle<T> received;

        public ManualSubscriber(TestEnvironment env) {
            super(env);
            this.received = new Receptacle(this.env);
        }

        @Override
        public void onNext(T element) {
            this.received.add(element);
        }

        @Override
        public void onComplete() {
            this.received.complete();
        }

        public void request(long elements) {
            ((Subscription)this.subscription.value()).request(elements);
        }

        public T requestNextElement() throws InterruptedException {
            return this.requestNextElement(this.env.defaultTimeoutMillis());
        }

        public T requestNextElement(long timeoutMillis) throws InterruptedException {
            return this.requestNextElement(timeoutMillis, "Did not receive expected element");
        }

        public T requestNextElement(String errorMsg) throws InterruptedException {
            return this.requestNextElement(this.env.defaultTimeoutMillis(), errorMsg);
        }

        public T requestNextElement(long timeoutMillis, String errorMsg) throws InterruptedException {
            this.request(1L);
            return this.nextElement(timeoutMillis, errorMsg);
        }

        public Optional<T> requestNextElementOrEndOfStream(String errorMsg) throws InterruptedException {
            return this.requestNextElementOrEndOfStream(this.env.defaultTimeoutMillis(), errorMsg);
        }

        public Optional<T> requestNextElementOrEndOfStream(long timeoutMillis) throws InterruptedException {
            return this.requestNextElementOrEndOfStream(timeoutMillis, "Did not receive expected stream completion");
        }

        public Optional<T> requestNextElementOrEndOfStream(long timeoutMillis, String errorMsg) throws InterruptedException {
            this.request(1L);
            return this.nextElementOrEndOfStream(timeoutMillis, errorMsg);
        }

        public void requestEndOfStream() throws InterruptedException {
            this.requestEndOfStream(this.env.defaultTimeoutMillis(), "Did not receive expected stream completion");
        }

        public void requestEndOfStream(long timeoutMillis) throws InterruptedException {
            this.requestEndOfStream(timeoutMillis, "Did not receive expected stream completion");
        }

        public void requestEndOfStream(String errorMsg) throws InterruptedException {
            this.requestEndOfStream(this.env.defaultTimeoutMillis(), errorMsg);
        }

        public void requestEndOfStream(long timeoutMillis, String errorMsg) throws InterruptedException {
            this.request(1L);
            this.expectCompletion(timeoutMillis, errorMsg);
        }

        public List<T> requestNextElements(long elements) throws InterruptedException {
            this.request(elements);
            return this.nextElements(elements, this.env.defaultTimeoutMillis());
        }

        public List<T> requestNextElements(long elements, long timeoutMillis) throws InterruptedException {
            this.request(elements);
            return this.nextElements(elements, timeoutMillis, String.format("Did not receive %d expected elements", elements));
        }

        public List<T> requestNextElements(long elements, long timeoutMillis, String errorMsg) throws InterruptedException {
            this.request(elements);
            return this.nextElements(elements, timeoutMillis, errorMsg);
        }

        public T nextElement() throws InterruptedException {
            return this.nextElement(this.env.defaultTimeoutMillis());
        }

        public T nextElement(long timeoutMillis) throws InterruptedException {
            return this.nextElement(timeoutMillis, "Did not receive expected element");
        }

        public T nextElement(String errorMsg) throws InterruptedException {
            return this.nextElement(this.env.defaultTimeoutMillis(), errorMsg);
        }

        public T nextElement(long timeoutMillis, String errorMsg) throws InterruptedException {
            return this.received.next(timeoutMillis, errorMsg);
        }

        public Optional<T> nextElementOrEndOfStream() throws InterruptedException {
            return this.nextElementOrEndOfStream(this.env.defaultTimeoutMillis(), "Did not receive expected stream completion");
        }

        public Optional<T> nextElementOrEndOfStream(long timeoutMillis) throws InterruptedException {
            return this.nextElementOrEndOfStream(timeoutMillis, "Did not receive expected stream completion");
        }

        public Optional<T> nextElementOrEndOfStream(long timeoutMillis, String errorMsg) throws InterruptedException {
            return this.received.nextOrEndOfStream(timeoutMillis, errorMsg);
        }

        public List<T> nextElements(long elements) throws InterruptedException {
            return this.nextElements(elements, this.env.defaultTimeoutMillis(), "Did not receive expected element or completion");
        }

        public List<T> nextElements(long elements, String errorMsg) throws InterruptedException {
            return this.nextElements(elements, this.env.defaultTimeoutMillis(), errorMsg);
        }

        public List<T> nextElements(long elements, long timeoutMillis) throws InterruptedException {
            return this.nextElements(elements, timeoutMillis, "Did not receive expected element or completion");
        }

        public List<T> nextElements(long elements, long timeoutMillis, String errorMsg) throws InterruptedException {
            return this.received.nextN(elements, timeoutMillis, errorMsg);
        }

        public void expectNext(T expected) throws InterruptedException {
            this.expectNext(expected, this.env.defaultTimeoutMillis());
        }

        public void expectNext(T expected, long timeoutMillis) throws InterruptedException {
            T received = this.nextElement(timeoutMillis, "Did not receive expected element on downstream");
            if (!received.equals(expected)) {
                this.env.flop(String.format("Expected element %s on downstream but received %s", expected, received));
            }
        }

        public void expectCompletion() throws InterruptedException {
            this.expectCompletion(this.env.defaultTimeoutMillis(), "Did not receive expected stream completion");
        }

        public void expectCompletion(long timeoutMillis) throws InterruptedException {
            this.expectCompletion(timeoutMillis, "Did not receive expected stream completion");
        }

        public void expectCompletion(String errorMsg) throws InterruptedException {
            this.expectCompletion(this.env.defaultTimeoutMillis(), errorMsg);
        }

        public void expectCompletion(long timeoutMillis, String errorMsg) throws InterruptedException {
            this.received.expectCompletion(timeoutMillis, errorMsg);
        }

        public <E extends Throwable> void expectErrorWithMessage(Class<E> expected, String requiredMessagePart) throws Exception {
            E err = this.expectError(expected);
            String message = ((Throwable)err).getMessage();
            Assert.assertTrue((boolean)message.contains(requiredMessagePart), (String)String.format("Got expected exception [%s] but missing message part [%s], was: %s", err.getClass(), requiredMessagePart, ((Throwable)err).getMessage()));
        }

        public <E extends Throwable> E expectError(Class<E> expected) throws Exception {
            return this.expectError(expected, this.env.defaultTimeoutMillis(), "Expected onError");
        }

        public <E extends Throwable> E expectError(Class<E> expected, long timeoutMillis) throws Exception {
            return this.expectError(expected, timeoutMillis, "Expected onError");
        }

        public <E extends Throwable> E expectError(Class<E> expected, String errorMsg) throws Exception {
            return this.expectError(expected, this.env.defaultTimeoutMillis(), errorMsg);
        }

        public <E extends Throwable> E expectError(Class<E> expected, long timeoutMillis, String errorMsg) throws Exception {
            return this.received.expectError(expected, timeoutMillis, errorMsg);
        }

        public void expectNone() throws InterruptedException {
            this.expectNone(this.env.defaultTimeoutMillis());
        }

        public void expectNone(String errMsgPrefix) throws InterruptedException {
            this.expectNone(this.env.defaultTimeoutMillis(), errMsgPrefix);
        }

        public void expectNone(long withinMillis) throws InterruptedException {
            this.expectNone(withinMillis, "Did not expect an element but got ");
        }

        public void expectNone(long withinMillis, String errMsgPrefix) throws InterruptedException {
            this.received.expectNone(withinMillis, errMsgPrefix);
        }
    }
}

