/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.tck;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.reactivestreams.tck.support.NonFatal;
import org.reactivestreams.tck.support.Optional;
import org.testng.Assert;

public class TestEnvironment {
    public static final int TEST_BUFFER_SIZE = 16;
    private final long defaultTimeoutMillis;
    private final boolean printlnDebug;
    private CopyOnWriteArrayList<Throwable> asyncErrors = new CopyOnWriteArrayList();

    public TestEnvironment(long l, boolean bl) {
        this.defaultTimeoutMillis = l;
        this.printlnDebug = bl;
    }

    public TestEnvironment(long l) {
        this(l, false);
    }

    public long defaultTimeoutMillis() {
        return this.defaultTimeoutMillis;
    }

    public void flop(String string) {
        try {
            Assert.fail((String)string);
        }
        catch (Throwable throwable) {
            this.asyncErrors.add(throwable);
        }
    }

    public void flop(Throwable throwable, String string) {
        try {
            Assert.fail((String)string);
        }
        catch (Throwable throwable2) {
            this.asyncErrors.add(throwable);
        }
    }

    public <T extends Throwable> Throwable expectThrowingOf(Class<T> clazz, String string, Runnable runnable) throws Throwable {
        try {
            runnable.run();
            this.flop(string);
        }
        catch (Throwable throwable) {
            if (clazz.isInstance(throwable)) {
                return throwable;
            }
            if (NonFatal.isNonFatal(throwable)) {
                this.flop(string + " but was: " + throwable);
            }
            throw throwable;
        }
        return null;
    }

    public <T extends Throwable> void expectThrowingOfWithMessage(Class<T> clazz, String string, Runnable runnable) throws Throwable {
        Throwable throwable = this.expectThrowingOf(clazz, String.format("Expected [%s] to be thrown", clazz), runnable);
        String string2 = throwable.getMessage();
        Assert.assertTrue((boolean)string2.contains(string), (String)String.format("Got expected exception [%s] but missing message part [%s], was: %s", throwable.getClass(), string, string2));
    }

    public <T extends Throwable> void assertAsyncErrorWithMessage(Class<T> clazz, String string) throws Throwable {
        Throwable throwable = this.dropAsyncError();
        Assert.assertNotNull((Object)throwable, (String)("Expected " + clazz.getCanonicalName() + " exception but got null!"));
        Assert.assertTrue((boolean)clazz.isInstance(throwable), (String)("Expected " + clazz.getCanonicalName() + " exception but got " + throwable.getClass().getCanonicalName() + "!"));
        String string2 = throwable.getMessage();
        Assert.assertTrue((boolean)string2.contains(string), (String)String.format("Got expected exception [%s] but missing message part [%s], was: %s", throwable.getClass(), string, string2));
    }

    public <T> void subscribe(Publisher<T> publisher, TestSubscriber<T> testSubscriber) throws InterruptedException {
        this.subscribe(publisher, testSubscriber, this.defaultTimeoutMillis);
    }

    public <T> void subscribe(Publisher<T> publisher, TestSubscriber<T> testSubscriber, long l) throws InterruptedException {
        publisher.subscribe(testSubscriber);
        testSubscriber.subscription.expectCompletion(l, String.format("Could not subscribe %s to Publisher %s", testSubscriber, publisher));
        this.verifyNoAsyncErrors();
    }

    public <T> ManualSubscriber<T> newBlackholeSubscriber(Publisher<T> publisher) throws InterruptedException {
        BlackholeSubscriberWithSubscriptionSupport blackholeSubscriberWithSubscriptionSupport = new BlackholeSubscriberWithSubscriptionSupport(this);
        this.subscribe(publisher, blackholeSubscriberWithSubscriptionSupport, this.defaultTimeoutMillis());
        return blackholeSubscriberWithSubscriptionSupport;
    }

    public <T> ManualSubscriber<T> newManualSubscriber(Publisher<T> publisher) throws InterruptedException {
        return this.newManualSubscriber(publisher, this.defaultTimeoutMillis());
    }

    public <T> ManualSubscriber<T> newManualSubscriber(Publisher<T> publisher, long l) throws InterruptedException {
        ManualSubscriberWithSubscriptionSupport manualSubscriberWithSubscriptionSupport = new ManualSubscriberWithSubscriptionSupport(this);
        this.subscribe(publisher, manualSubscriberWithSubscriptionSupport, l);
        return manualSubscriberWithSubscriptionSupport;
    }

    public void clearAsyncErrors() {
        this.asyncErrors.clear();
    }

    public Throwable dropAsyncError() {
        try {
            return this.asyncErrors.remove(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void verifyNoAsyncErrors(long l) {
        try {
            Thread.sleep(l);
            this.verifyNoAsyncErrors();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public void verifyNoAsyncErrors() {
        for (Throwable throwable : this.asyncErrors) {
            if (throwable instanceof AssertionError) {
                throw (AssertionError)((Object)throwable);
            }
            Assert.fail((String)("Async error during test execution: " + throwable));
        }
    }

    public void debug(String string) {
        if (this.printlnDebug) {
            System.out.println("[TCK-DEBUG] " + string);
        }
    }

    public static class Receptacle<T> {
        final int QUEUE_SIZE = 32;
        private final TestEnvironment env;
        private final ArrayBlockingQueue<Optional<T>> abq = new ArrayBlockingQueue(32);
        private final Latch completedLatch;

        Receptacle(TestEnvironment testEnvironment) {
            this.env = testEnvironment;
            this.completedLatch = new Latch(testEnvironment);
        }

        public void add(T t) {
            this.completedLatch.assertOpen(String.format("Unexpected element %s received after stream completed", t));
            this.abq.add(Optional.of(t));
        }

        public void complete() {
            this.completedLatch.assertOpen("Unexpected additional complete signal received!");
            this.completedLatch.close();
            this.abq.add(Optional.empty());
        }

        public T next(long l, String string) throws InterruptedException {
            Optional<T> optional = this.abq.poll(l, TimeUnit.MILLISECONDS);
            if (optional == null) {
                this.env.flop(String.format("%s within %d ms", string, l));
            } else {
                if (optional.isDefined()) {
                    return optional.get();
                }
                this.env.flop("Expected element but got end-of-stream");
            }
            return null;
        }

        public Optional<T> nextOrEndOfStream(long l, String string) throws InterruptedException {
            Optional<T> optional = this.abq.poll(l, TimeUnit.MILLISECONDS);
            if (optional == null) {
                this.env.flop(String.format("%s within %d ms", string, l));
            }
            return optional;
        }

        public List<T> nextN(long l, long l2, String string) throws InterruptedException {
            LinkedList<T> linkedList = new LinkedList<T>();
            long l3 = System.currentTimeMillis() + l2;
            for (long i = l; i > 0L; --i) {
                long l4 = l3 - System.currentTimeMillis();
                linkedList.add(this.next(l4, string));
            }
            return linkedList;
        }

        public void expectCompletion(long l, String string) throws InterruptedException {
            Optional<T> optional = this.abq.poll(l, TimeUnit.MILLISECONDS);
            if (optional == null) {
                this.env.flop(String.format("%s within %d ms", string, l));
            } else if (optional.isDefined()) {
                this.env.flop("Expected end-of-stream but got " + optional.get());
            }
        }

        public <E extends Throwable> E expectError(Class<E> clazz, long l, String string) throws Exception {
            Thread.sleep(l);
            if (this.env.asyncErrors.isEmpty()) {
                this.env.flop(String.format("%s within %d ms", string, l));
            } else {
                Throwable throwable = (Throwable)this.env.asyncErrors.remove(0);
                if (clazz.isInstance(throwable)) {
                    return (E)throwable;
                }
                this.env.flop(String.format("%s within %d ms; Got %s but expected %s", string, l, throwable.getClass().getCanonicalName(), clazz.getCanonicalName()));
            }
            return null;
        }

        public void expectError(long l, String string) throws Exception {
            Thread.sleep(l);
            if (this.env.asyncErrors.isEmpty()) {
                this.env.flop(String.format("%s within %d ms", string, l));
            } else {
                this.env.asyncErrors.remove(0);
            }
        }

        public void expectNone(long l, String string) throws InterruptedException {
            Thread.sleep(l);
            Optional<T> optional = this.abq.poll();
            if (optional != null) {
                if (optional.isDefined()) {
                    this.env.flop(string + optional.get());
                } else {
                    this.env.flop("Expected no element but got end-of-stream");
                }
            }
        }
    }

    public static class Promise<T> {
        private final TestEnvironment env;
        private ArrayBlockingQueue<T> abq = new ArrayBlockingQueue(1);
        private volatile T _value = null;

        public static <T> Promise<T> completed(TestEnvironment testEnvironment, T t) {
            Promise<T> promise = new Promise<T>(testEnvironment);
            promise.completeImmediatly(t);
            return promise;
        }

        public Promise(TestEnvironment testEnvironment) {
            this.env = testEnvironment;
        }

        public T value() {
            if (this.isCompleted()) {
                return this._value;
            }
            this.env.flop("Cannot access promise value before completion");
            return null;
        }

        public boolean isCompleted() {
            return this._value != null;
        }

        public void complete(T t) {
            this.abq.add(t);
        }

        public void completeImmediatly(T t) {
            this.complete(t);
            this._value = t;
        }

        public void expectCompletion(long l, String string) throws InterruptedException {
            if (!this.isCompleted()) {
                T t = this.abq.poll(l, TimeUnit.MILLISECONDS);
                if (t == null) {
                    this.env.flop(String.format("%s within %d ms", string, l));
                } else {
                    this._value = t;
                }
            }
        }
    }

    public static class Latch {
        private final TestEnvironment env;
        private volatile CountDownLatch countDownLatch = new CountDownLatch(1);

        public Latch(TestEnvironment testEnvironment) {
            this.env = testEnvironment;
        }

        public void reOpen() {
            this.countDownLatch = new CountDownLatch(1);
        }

        public boolean isClosed() {
            return this.countDownLatch.getCount() == 0L;
        }

        public void close() {
            this.countDownLatch.countDown();
        }

        public void assertClosed(String string) {
            if (!this.isClosed()) {
                this.env.flop(string);
            }
        }

        public void assertOpen(String string) {
            if (this.isClosed()) {
                this.env.flop(string);
            }
        }

        public void expectClose(String string) throws InterruptedException {
            this.expectClose(this.env.defaultTimeoutMillis(), string);
        }

        public void expectClose(long l, String string) throws InterruptedException {
            this.countDownLatch.await(l, TimeUnit.MILLISECONDS);
            if (this.countDownLatch.getCount() > 0L) {
                this.env.flop(String.format("%s within %d ms", string, l));
            }
        }
    }

    public static class ManualPublisher<T>
    implements Publisher<T> {
        protected final TestEnvironment env;
        protected long pendingDemand = 0L;
        protected Promise<Subscriber<? super T>> subscriber;
        protected final Receptacle<Long> requests;
        protected final Latch cancelled;

        public ManualPublisher(TestEnvironment testEnvironment) {
            this.env = testEnvironment;
            this.requests = new Receptacle(testEnvironment);
            this.cancelled = new Latch(testEnvironment);
            this.subscriber = new Promise(this.env);
        }

        public void subscribe(Subscriber<? super T> subscriber) {
            if (!this.subscriber.isCompleted()) {
                this.subscriber.completeImmediatly(subscriber);
                Subscription subscription = new Subscription(){

                    public void request(long l) {
                        ManualPublisher.this.requests.add(l);
                    }

                    public void cancel() {
                        ManualPublisher.this.cancelled.close();
                    }
                };
                subscriber.onSubscribe(subscription);
            } else {
                this.env.flop("TestPublisher doesn't support more than one Subscriber");
            }
        }

        public void sendNext(T t) {
            if (this.subscriber.isCompleted()) {
                this.subscriber.value().onNext(t);
            } else {
                this.env.flop("Cannot sendNext before having a Subscriber");
            }
        }

        public void sendCompletion() {
            if (this.subscriber.isCompleted()) {
                this.subscriber.value().onComplete();
            } else {
                this.env.flop("Cannot sendCompletion before having a Subscriber");
            }
        }

        public void sendError(Throwable throwable) {
            if (this.subscriber.isCompleted()) {
                this.subscriber.value().onError(throwable);
            } else {
                this.env.flop("Cannot sendError before having a Subscriber");
            }
        }

        public long expectRequest() throws InterruptedException {
            return this.expectRequest(this.env.defaultTimeoutMillis());
        }

        public long expectRequest(long l) throws InterruptedException {
            long l2 = this.requests.next(l, "Did not receive expected `request` call");
            if (l2 <= 0L) {
                this.env.flop(String.format("Requests cannot be zero or negative but received request(%s)", l2));
                return 0L;
            }
            this.pendingDemand += l2;
            return l2;
        }

        public void expectExactRequest(long l) throws InterruptedException {
            this.expectExactRequest(l, this.env.defaultTimeoutMillis());
        }

        public void expectExactRequest(long l, long l2) throws InterruptedException {
            long l3 = this.expectRequest(l2);
            if (l3 != l) {
                this.env.flop(String.format("Received `request(%d)` on upstream but expected `request(%d)`", l3, l));
            }
            this.pendingDemand += l3;
        }

        public void expectNoRequest() throws InterruptedException {
            this.expectNoRequest(this.env.defaultTimeoutMillis());
        }

        public void expectNoRequest(long l) throws InterruptedException {
            this.requests.expectNone(l, "Received an unexpected call to: request: ");
        }

        public void expectCancelling() throws InterruptedException {
            this.expectCancelling(this.env.defaultTimeoutMillis());
        }

        public void expectCancelling(long l) throws InterruptedException {
            this.cancelled.expectClose(l, "Did not receive expected cancelling of upstream subscription");
        }
    }

    public static class TestSubscriber<T>
    implements Subscriber<T> {
        final Promise<Subscription> subscription;
        protected final TestEnvironment env;

        public TestSubscriber(TestEnvironment testEnvironment) {
            this.env = testEnvironment;
            this.subscription = new Promise(testEnvironment);
        }

        public void onError(Throwable throwable) {
            this.env.flop(throwable, String.format("Unexpected Subscriber::onError(%s)", throwable));
        }

        public void onComplete() {
            this.env.flop("Unexpected Subscriber::onComplete()");
        }

        public void onNext(T t) {
            this.env.flop(String.format("Unexpected Subscriber::onNext(%s)", t));
        }

        public void onSubscribe(Subscription subscription) {
            this.env.flop(String.format("Unexpected Subscriber::onSubscribe(%s)", subscription));
        }

        public void cancel() {
            if (this.subscription.isCompleted()) {
                this.subscription.value().cancel();
            } else {
                this.env.flop("Cannot cancel a subscription before having received it");
            }
        }
    }

    public static class BlackholeSubscriberWithSubscriptionSupport<T>
    extends ManualSubscriberWithSubscriptionSupport<T> {
        public BlackholeSubscriberWithSubscriptionSupport(TestEnvironment testEnvironment) {
            super(testEnvironment);
        }

        @Override
        public void onNext(T t) {
            this.env.debug(this + "::onNext(" + t + ")");
            if (!this.subscription.isCompleted()) {
                this.env.flop("Subscriber::onNext(" + t + ") called before Subscriber::onSubscribe");
            }
        }

        @Override
        public T nextElement(long l, String string) throws InterruptedException {
            throw new RuntimeException("Can not expect elements from BlackholeSubscriber, use ManualSubscriber instead!");
        }

        @Override
        public List<T> nextElements(long l, long l2, String string) throws InterruptedException {
            throw new RuntimeException("Can not expect elements from BlackholeSubscriber, use ManualSubscriber instead!");
        }
    }

    public static class ManualSubscriberWithSubscriptionSupport<T>
    extends ManualSubscriber<T> {
        public ManualSubscriberWithSubscriptionSupport(TestEnvironment testEnvironment) {
            super(testEnvironment);
        }

        @Override
        public void onNext(T t) {
            this.env.debug(this + "::onNext(" + t + ")");
            if (this.subscription.isCompleted()) {
                super.onNext(t);
            } else {
                this.env.flop("Subscriber::onNext(" + t + ") called before Subscriber::onSubscribe");
            }
        }

        @Override
        public void onComplete() {
            this.env.debug(this + "::onComplete()");
            if (this.subscription.isCompleted()) {
                super.onComplete();
            } else {
                this.env.flop("Subscriber::onComplete() called before Subscriber::onSubscribe");
            }
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            this.env.debug(this + "::onSubscribe(" + subscription + ")");
            if (!this.subscription.isCompleted()) {
                this.subscription.complete(subscription);
            } else {
                this.env.flop("Subscriber::onSubscribe called on an already-subscribed Subscriber");
            }
        }

        @Override
        public void onError(Throwable throwable) {
            this.env.debug(this + "::onError(" + throwable + ")");
            if (this.subscription.isCompleted()) {
                super.onError(throwable);
            } else {
                this.env.flop(throwable, "Subscriber::onError(" + throwable + ") called before Subscriber::onSubscribe");
            }
        }
    }

    public static class ManualSubscriber<T>
    extends TestSubscriber<T> {
        Receptacle<T> received;

        public ManualSubscriber(TestEnvironment testEnvironment) {
            super(testEnvironment);
            this.received = new Receptacle(this.env);
        }

        @Override
        public void onNext(T t) {
            this.received.add(t);
        }

        @Override
        public void onComplete() {
            this.received.complete();
        }

        public void request(long l) {
            ((Subscription)this.subscription.value()).request(l);
        }

        public T requestNextElement() throws InterruptedException {
            return this.requestNextElement(this.env.defaultTimeoutMillis());
        }

        public T requestNextElement(long l) throws InterruptedException {
            return this.requestNextElement(l, "Did not receive expected element");
        }

        public T requestNextElement(String string) throws InterruptedException {
            return this.requestNextElement(this.env.defaultTimeoutMillis(), string);
        }

        public T requestNextElement(long l, String string) throws InterruptedException {
            this.request(1L);
            return this.nextElement(l, string);
        }

        public Optional<T> requestNextElementOrEndOfStream(String string) throws InterruptedException {
            return this.requestNextElementOrEndOfStream(this.env.defaultTimeoutMillis(), string);
        }

        public Optional<T> requestNextElementOrEndOfStream(long l) throws InterruptedException {
            return this.requestNextElementOrEndOfStream(l, "Did not receive expected stream completion");
        }

        public Optional<T> requestNextElementOrEndOfStream(long l, String string) throws InterruptedException {
            this.request(1L);
            return this.nextElementOrEndOfStream(l, string);
        }

        public void requestEndOfStream() throws InterruptedException {
            this.requestEndOfStream(this.env.defaultTimeoutMillis(), "Did not receive expected stream completion");
        }

        public void requestEndOfStream(long l) throws InterruptedException {
            this.requestEndOfStream(l, "Did not receive expected stream completion");
        }

        public void requestEndOfStream(String string) throws InterruptedException {
            this.requestEndOfStream(this.env.defaultTimeoutMillis(), string);
        }

        public void requestEndOfStream(long l, String string) throws InterruptedException {
            this.request(1L);
            this.expectCompletion(l, string);
        }

        public List<T> requestNextElements(long l) throws InterruptedException {
            this.request(l);
            return this.nextElements(l, this.env.defaultTimeoutMillis());
        }

        public List<T> requestNextElements(long l, long l2) throws InterruptedException {
            this.request(l);
            return this.nextElements(l, l2, String.format("Did not receive %d expected elements", l));
        }

        public List<T> requestNextElements(long l, long l2, String string) throws InterruptedException {
            this.request(l);
            return this.nextElements(l, l2, string);
        }

        public T nextElement() throws InterruptedException {
            return this.nextElement(this.env.defaultTimeoutMillis());
        }

        public T nextElement(long l) throws InterruptedException {
            return this.nextElement(l, "Did not receive expected element");
        }

        public T nextElement(String string) throws InterruptedException {
            return this.nextElement(this.env.defaultTimeoutMillis(), string);
        }

        public T nextElement(long l, String string) throws InterruptedException {
            return this.received.next(l, string);
        }

        public Optional<T> nextElementOrEndOfStream() throws InterruptedException {
            return this.nextElementOrEndOfStream(this.env.defaultTimeoutMillis(), "Did not receive expected stream completion");
        }

        public Optional<T> nextElementOrEndOfStream(long l) throws InterruptedException {
            return this.nextElementOrEndOfStream(l, "Did not receive expected stream completion");
        }

        public Optional<T> nextElementOrEndOfStream(long l, String string) throws InterruptedException {
            return this.received.nextOrEndOfStream(l, string);
        }

        public List<T> nextElements(long l) throws InterruptedException {
            return this.nextElements(l, this.env.defaultTimeoutMillis(), "Did not receive expected element or completion");
        }

        public List<T> nextElements(long l, String string) throws InterruptedException {
            return this.nextElements(l, this.env.defaultTimeoutMillis(), string);
        }

        public List<T> nextElements(long l, long l2) throws InterruptedException {
            return this.nextElements(l, l2, "Did not receive expected element or completion");
        }

        public List<T> nextElements(long l, long l2, String string) throws InterruptedException {
            return this.received.nextN(l, l2, string);
        }

        public void expectNext(T t) throws InterruptedException {
            this.expectNext(t, this.env.defaultTimeoutMillis());
        }

        public void expectNext(T t, long l) throws InterruptedException {
            T t2 = this.nextElement(l, "Did not receive expected element on downstream");
            if (!t2.equals(t)) {
                this.env.flop(String.format("Expected element %s on downstream but received %s", t, t2));
            }
        }

        public void expectCompletion() throws InterruptedException {
            this.expectCompletion(this.env.defaultTimeoutMillis(), "Did not receive expected stream completion");
        }

        public void expectCompletion(long l) throws InterruptedException {
            this.expectCompletion(l, "Did not receive expected stream completion");
        }

        public void expectCompletion(String string) throws InterruptedException {
            this.expectCompletion(this.env.defaultTimeoutMillis(), string);
        }

        public void expectCompletion(long l, String string) throws InterruptedException {
            this.received.expectCompletion(l, string);
        }

        public <E extends Throwable> void expectErrorWithMessage(Class<E> clazz, String string) throws Exception {
            E e = this.expectError(clazz);
            String string2 = ((Throwable)e).getMessage();
            Assert.assertTrue((boolean)string2.contains(string), (String)String.format("Got expected exception [%s] but missing message part [%s], was: %s", e.getClass(), string, ((Throwable)e).getMessage()));
        }

        public <E extends Throwable> E expectError(Class<E> clazz) throws Exception {
            return this.expectError(clazz, this.env.defaultTimeoutMillis(), "Expected onError");
        }

        public <E extends Throwable> E expectError(Class<E> clazz, long l) throws Exception {
            return this.expectError(clazz, l, "Expected onError");
        }

        public <E extends Throwable> E expectError(Class<E> clazz, String string) throws Exception {
            return this.expectError(clazz, this.env.defaultTimeoutMillis(), string);
        }

        public <E extends Throwable> E expectError(Class<E> clazz, long l, String string) throws Exception {
            return this.received.expectError(clazz, l, string);
        }

        public void expectNone() throws InterruptedException {
            this.expectNone(this.env.defaultTimeoutMillis());
        }

        public void expectNone(String string) throws InterruptedException {
            this.expectNone(this.env.defaultTimeoutMillis(), string);
        }

        public void expectNone(long l) throws InterruptedException {
            this.expectNone(l, "Did not expect an element but got ");
        }

        public void expectNone(long l, String string) throws InterruptedException {
            this.received.expectNone(l, string);
        }
    }
}

