/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.tck;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.reactivestreams.tck.TestEnvironment;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class SubscriberWhiteboxVerification<T> {
    private final TestEnvironment env;

    protected SubscriberWhiteboxVerification(TestEnvironment testEnvironment) {
        this.env = testEnvironment;
    }

    public abstract Subscriber<T> createSubscriber(WhiteboxSubscriberProbe<T> var1);

    public abstract Publisher<T> createHelperPublisher(long var1);

    public long maxOnNextSignalsInTest() {
        return 100L;
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.env.clearAsyncErrors();
    }

    @Test
    public void exerciseWhiteboxHappyPath() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage whiteboxTestStage) throws InterruptedException {
                whiteboxTestStage.puppet().triggerRequest(1L);
                whiteboxTestStage.puppet().triggerRequest(1L);
                long l = whiteboxTestStage.expectRequest();
                whiteboxTestStage.signalNext();
                whiteboxTestStage.probe.expectNext(whiteboxTestStage.lastT);
                whiteboxTestStage.puppet().triggerRequest(1L);
                if (l == 1L) {
                    whiteboxTestStage.expectRequest();
                }
                whiteboxTestStage.signalNext();
                whiteboxTestStage.probe.expectNext(whiteboxTestStage.lastT);
                whiteboxTestStage.puppet().signalCancel();
                whiteboxTestStage.expectCancelling();
                whiteboxTestStage.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec201_mustSignalDemandViaSubscriptionRequest() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage whiteboxTestStage) throws InterruptedException {
                whiteboxTestStage.puppet().triggerRequest(1L);
                whiteboxTestStage.expectRequest();
                whiteboxTestStage.signalNext();
            }
        });
    }

    @Test
    public void spec202_shouldAsynchronouslyDispatch() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec203_mustNotCallMethodsOnSubscriptionOrPublisherInOnComplete() throws Throwable {
        this.subscriberTestWithoutSetup(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage whiteboxTestStage) throws Throwable {
                Subscription subscription = new Subscription(){

                    public void request(long l) {
                        Throwable throwable = new Throwable();
                        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                            if (!stackTraceElement.getMethodName().equals("onComplete")) continue;
                            SubscriberWhiteboxVerification.this.env.flop("Subscription::request MUST NOT be called from onComplete!");
                        }
                    }

                    public void cancel() {
                        Throwable throwable = new Throwable();
                        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                            if (!stackTraceElement.getMethodName().equals("onComplete")) continue;
                            SubscriberWhiteboxVerification.this.env.flop("Subscriber::onComplete MUST NOT call Subscription::cancel");
                        }
                    }
                };
                whiteboxTestStage.probe = whiteboxTestStage.createWhiteboxSubscriberProbe(SubscriberWhiteboxVerification.this.env);
                Subscriber subscriber = SubscriberWhiteboxVerification.this.createSubscriber(whiteboxTestStage.probe);
                subscriber.onSubscribe(subscription);
                subscriber.onComplete();
                SubscriberWhiteboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec203_mustNotCallMethodsOnSubscriptionOrPublisherInOnError() throws Throwable {
        this.subscriberTestWithoutSetup(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage whiteboxTestStage) throws Throwable {
                Subscription subscription = new Subscription(){

                    public void request(long l) {
                        Throwable throwable = new Throwable();
                        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                            if (!stackTraceElement.getMethodName().equals("onError")) continue;
                            SubscriberWhiteboxVerification.this.env.flop("Subscriber::onError MUST NOT call Subscription::request!");
                        }
                    }

                    public void cancel() {
                        Throwable throwable = new Throwable();
                        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                            if (!stackTraceElement.getMethodName().equals("onError")) continue;
                            SubscriberWhiteboxVerification.this.env.flop("Subscriber::onError MUST NOT call Subscription::cancel");
                        }
                    }
                };
                whiteboxTestStage.probe = whiteboxTestStage.createWhiteboxSubscriberProbe(SubscriberWhiteboxVerification.this.env);
                Subscriber subscriber = SubscriberWhiteboxVerification.this.createSubscriber(whiteboxTestStage.probe);
                subscriber.onSubscribe(subscription);
                subscriber.onComplete();
                SubscriberWhiteboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec204_mustConsiderTheSubscriptionAsCancelledInAfterRecievingOnCompleteOrOnError() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec205_mustCallSubscriptionCancelIfItAlreadyHasAnSubscriptionAndReceivesAnotherOnSubscribeSignal() throws Exception {
        new WhiteboxTestStage(this.env){
            {
                final TestEnvironment.Latch latch = new TestEnvironment.Latch(this.env);
                this.sub().onSubscribe(new Subscription(){

                    public void request(long l) {
                        env.flop(String.format("Subscriber %s illegally called `subscription.request(%s)`", this.sub(), l));
                    }

                    public void cancel() {
                        latch.close();
                    }

                    public String toString() {
                        return "SecondSubscription(should get cancelled)";
                    }
                });
                latch.expectClose("Expected 2nd Subscription given to subscriber to be cancelled, but `Subscription.cancel()` was not called.");
                this.env.verifyNoAsyncErrors();
            }
        };
    }

    @Test
    public void spec206_mustCallSubscriptionCancelIfItIsNoLongerValid() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec207_mustEnsureAllCallsOnItsSubscriptionTakePlaceFromTheSameThreadOrTakeCareOfSynchronization() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec208_mustBePreparedToReceiveOnNextSignalsAfterHavingCalledSubscriptionCancel() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage whiteboxTestStage) throws InterruptedException {
                whiteboxTestStage.puppet().triggerRequest(1L);
                whiteboxTestStage.puppet().signalCancel();
                whiteboxTestStage.signalNext();
                whiteboxTestStage.puppet().triggerRequest(1L);
                whiteboxTestStage.puppet().triggerRequest(1L);
                whiteboxTestStage.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec209_mustBePreparedToReceiveAnOnCompleteSignalWithPrecedingRequestCall() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage whiteboxTestStage) throws InterruptedException {
                whiteboxTestStage.puppet().triggerRequest(1L);
                whiteboxTestStage.sendCompletion();
                whiteboxTestStage.probe.expectCompletion();
                whiteboxTestStage.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec209_mustBePreparedToReceiveAnOnCompleteSignalWithoutPrecedingRequestCall() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage whiteboxTestStage) throws InterruptedException {
                whiteboxTestStage.sendCompletion();
                whiteboxTestStage.probe.expectCompletion();
                whiteboxTestStage.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec210_mustBePreparedToReceiveAnOnErrorSignalWithPrecedingRequestCall() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage whiteboxTestStage) throws InterruptedException {
                whiteboxTestStage.puppet().triggerRequest(1L);
                whiteboxTestStage.puppet().triggerRequest(1L);
                RuntimeException runtimeException = new RuntimeException("Test exception");
                whiteboxTestStage.sendError(runtimeException);
                whiteboxTestStage.probe.expectError(runtimeException);
                SubscriberWhiteboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec210_mustBePreparedToReceiveAnOnErrorSignalWithoutPrecedingRequestCall() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage whiteboxTestStage) throws InterruptedException {
                RuntimeException runtimeException = new RuntimeException("Test exception");
                whiteboxTestStage.sendError(runtimeException);
                whiteboxTestStage.probe.expectError(runtimeException);
                SubscriberWhiteboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec211_mustMakeSureThatAllCallsOnItsMethodsHappenBeforeTheProcessingOfTheRespectiveEvents() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec212_mustNotCallOnSubscribeMoreThanOnceBasedOnObjectEquality() throws Throwable {
        this.subscriberTestWithoutSetup(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage whiteboxTestStage) throws Exception {
                whiteboxTestStage.pub = whiteboxTestStage.createHelperPublisher(1L);
                whiteboxTestStage.tees = new TestEnvironment.ManualSubscriberWithSubscriptionSupport(SubscriberWhiteboxVerification.this.env);
                SubscriberWhiteboxVerification.this.env.subscribe(whiteboxTestStage.pub, whiteboxTestStage.tees);
                whiteboxTestStage.tees.expectNone();
                whiteboxTestStage.pub.subscribe(whiteboxTestStage.tees);
                whiteboxTestStage.tees.expectError(IllegalStateException.class, "2.12");
            }
        });
    }

    @Test
    public void spec213_failingOnSignalInvocation() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec301_mustNotBeCalledOutsideSubscriberContext() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec308_requestMustRegisterGivenNumberElementsToBeProduced() throws Throwable {
        this.subscriberTest(new TestStageTestRun(){

            @Override
            public void run(WhiteboxTestStage whiteboxTestStage) throws InterruptedException {
                whiteboxTestStage.puppet().triggerRequest(2L);
                whiteboxTestStage.probe.expectNext(whiteboxTestStage.signalNext());
                whiteboxTestStage.probe.expectNext(whiteboxTestStage.signalNext());
                whiteboxTestStage.probe.expectNone();
                whiteboxTestStage.puppet().triggerRequest(3L);
                whiteboxTestStage.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec310_requestMaySynchronouslyCallOnNextOnSubscriber() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec311_requestMaySynchronouslyCallOnCompleteOrOnError() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec314_cancelMayCauseThePublisherToShutdownIfNoOtherSubscriptionExists() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec315_cancelMustNotThrowExceptionAndMustSignalOnError() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec316_requestMustNotThrowExceptionAndMustOnErrorTheSubscriber() throws Exception {
        this.notVerified();
    }

    public void subscriberTest(TestStageTestRun testStageTestRun) throws Throwable {
        WhiteboxTestStage whiteboxTestStage = new WhiteboxTestStage(this.env, true);
        testStageTestRun.run(whiteboxTestStage);
    }

    public void subscriberTestWithoutSetup(TestStageTestRun testStageTestRun) throws Throwable {
        WhiteboxTestStage whiteboxTestStage = new WhiteboxTestStage(this.env, false);
        testStageTestRun.run(whiteboxTestStage);
    }

    public void notVerified() {
        throw new SkipException("Not verified using this TCK.");
    }

    public static interface SubscriberPuppet {
        public void triggerRequest(long var1);

        public void signalCancel();
    }

    public static interface SubscriberProbe<T> {
        public void registerOnNext(T var1);

        public void registerOnComplete();

        public void registerOnError(Throwable var1);
    }

    public static interface SubscriberPuppeteer {
        public void registerOnSubscribe(SubscriberPuppet var1);
    }

    public static class WhiteboxSubscriberProbe<T>
    extends BlackboxProbe<T>
    implements SubscriberPuppeteer {
        protected TestEnvironment.Promise<SubscriberPuppet> puppet;

        public WhiteboxSubscriberProbe(TestEnvironment testEnvironment, TestEnvironment.Promise<Subscriber<? super T>> promise) {
            super(testEnvironment, promise);
            this.puppet = new TestEnvironment.Promise(testEnvironment);
        }

        private SubscriberPuppet puppet() {
            return this.puppet.value();
        }

        @Override
        public void registerOnSubscribe(SubscriberPuppet subscriberPuppet) {
            if (!this.puppet.isCompleted()) {
                this.puppet.complete(subscriberPuppet);
            } else {
                this.env.flop(String.format("Subscriber %s illegally accepted a second Subscription", this.sub()));
            }
        }
    }

    public static class BlackboxProbe<T>
    implements SubscriberProbe<T> {
        protected final TestEnvironment env;
        protected final TestEnvironment.Promise<Subscriber<? super T>> subscriber;
        protected final TestEnvironment.Receptacle<T> elements;
        protected final TestEnvironment.Promise<Throwable> error;

        public BlackboxProbe(TestEnvironment testEnvironment, TestEnvironment.Promise<Subscriber<? super T>> promise) {
            this.env = testEnvironment;
            this.subscriber = promise;
            this.elements = new TestEnvironment.Receptacle(testEnvironment);
            this.error = new TestEnvironment.Promise(testEnvironment);
        }

        @Override
        public void registerOnNext(T t) {
            this.elements.add(t);
        }

        @Override
        public void registerOnComplete() {
            try {
                this.elements.complete();
            }
            catch (IllegalStateException illegalStateException) {
                this.env.flop("subscriber::onComplete was called a second time, which is illegal according to Rule 1.7");
            }
        }

        @Override
        public void registerOnError(Throwable throwable) {
            try {
                this.error.complete(throwable);
            }
            catch (IllegalStateException illegalStateException) {
                this.env.flop("subscriber::onError was called a second time, which is illegal according to Rule 1.7");
            }
        }

        public T expectNext() throws InterruptedException {
            return this.elements.next(this.env.defaultTimeoutMillis(), String.format("Subscriber %s did not call `registerOnNext(_)`", this.sub()));
        }

        public void expectNext(T t) throws InterruptedException {
            this.expectNext(t, this.env.defaultTimeoutMillis());
        }

        public void expectNext(T t, long l) throws InterruptedException {
            T t2 = this.elements.next(l, String.format("Subscriber %s did not call `registerOnNext(%s)`", this.sub(), t));
            if (!t2.equals(t)) {
                this.env.flop(String.format("Subscriber %s called `registerOnNext(%s)` rather than `registerOnNext(%s)`", this.sub(), t2, t));
            }
        }

        public Subscriber<? super T> sub() {
            return this.subscriber.value();
        }

        public void expectCompletion() throws InterruptedException {
            this.expectCompletion(this.env.defaultTimeoutMillis());
        }

        public void expectCompletion(long l) throws InterruptedException {
            this.expectCompletion(l, String.format("Subscriber %s did not call `registerOnComplete()`", this.sub()));
        }

        public void expectCompletion(long l, String string) throws InterruptedException {
            this.elements.expectCompletion(l, string);
        }

        public <E extends Throwable> void expectErrorWithMessage(Class<E> clazz, String string) throws InterruptedException {
            E e = this.expectError(clazz);
            String string2 = ((Throwable)e).getMessage();
            Assert.assertTrue((boolean)string2.contains(string), (String)String.format("Got expected exception %s but missing message [%s], was: %s", e.getClass(), string, clazz));
        }

        public <E extends Throwable> E expectError(Class<E> clazz) throws InterruptedException {
            return this.expectError(clazz, this.env.defaultTimeoutMillis());
        }

        public <E extends Throwable> E expectError(Class<E> clazz, long l) throws InterruptedException {
            this.error.expectCompletion(l, String.format("Subscriber %s did not call `registerOnError(%s)`", this.sub(), clazz));
            if (this.error.value() == null) {
                this.env.flop(String.format("Subscriber %s did not call `registerOnError(%s)`", this.sub(), clazz));
                return null;
            }
            if (clazz.isInstance(this.error.value())) {
                return (E)this.error.value();
            }
            this.env.flop(String.format("Subscriber %s called `registerOnError(%s)` rather than `registerOnError(%s)`", this.sub(), this.error.value(), clazz));
            return null;
        }

        public void expectError(Throwable throwable) throws InterruptedException {
            this.expectError(throwable, this.env.defaultTimeoutMillis());
        }

        public void expectError(Throwable throwable, long l) throws InterruptedException {
            this.error.expectCompletion(l, String.format("Subscriber %s did not call `registerOnError(%s)`", this.sub(), throwable));
            if (this.error.value() != throwable) {
                this.env.flop(String.format("Subscriber %s called `registerOnError(%s)` rather than `registerOnError(%s)`", this.sub(), this.error.value(), throwable));
            }
        }

        public void expectNone() throws InterruptedException {
            this.expectNone(this.env.defaultTimeoutMillis());
        }

        public void expectNone(long l) throws InterruptedException {
            this.elements.expectNone(l, "Expected nothing");
        }
    }

    public static class BlackboxSubscriberProxy<T>
    extends BlackboxProbe<T>
    implements Subscriber<T> {
        public BlackboxSubscriberProxy(TestEnvironment testEnvironment, Subscriber<T> subscriber) {
            super(testEnvironment, TestEnvironment.Promise.completed(testEnvironment, subscriber));
        }

        public void onSubscribe(Subscription subscription) {
            this.sub().onSubscribe(subscription);
        }

        public void onNext(T t) {
            this.registerOnNext(t);
            this.sub().onNext(t);
        }

        public void onError(Throwable throwable) {
            this.registerOnError(throwable);
            this.sub().onError(throwable);
        }

        public void onComplete() {
            this.registerOnComplete();
            this.sub().onComplete();
        }
    }

    public class WhiteboxTestStage
    extends TestEnvironment.ManualPublisher<T> {
        public Publisher<T> pub;
        public TestEnvironment.ManualSubscriber<T> tees;
        public WhiteboxSubscriberProbe<T> probe;
        public T lastT;

        public WhiteboxTestStage(TestEnvironment testEnvironment) throws InterruptedException {
            this(testEnvironment, true);
        }

        public WhiteboxTestStage(TestEnvironment testEnvironment, boolean bl) throws InterruptedException {
            super(testEnvironment);
            this.lastT = null;
            if (bl) {
                this.pub = this.createHelperPublisher(Long.MAX_VALUE);
                this.tees = testEnvironment.newManualSubscriber(this.pub);
                this.probe = new WhiteboxSubscriberProbe(testEnvironment, this.subscriber);
                this.subscribe(SubscriberWhiteboxVerification.this.createSubscriber(this.probe));
                this.probe.puppet.expectCompletion(testEnvironment.defaultTimeoutMillis(), String.format("Subscriber %s did not `registerOnSubscribe`", this.sub()));
            }
        }

        public Subscriber<? super T> sub() {
            return (Subscriber)this.subscriber.value();
        }

        public SubscriberPuppet puppet() {
            return this.probe.puppet();
        }

        public WhiteboxSubscriberProbe<T> probe() {
            return this.probe;
        }

        public Publisher<T> createHelperPublisher(long l) {
            return SubscriberWhiteboxVerification.this.createHelperPublisher(l);
        }

        public WhiteboxSubscriberProbe<T> createWhiteboxSubscriberProbe(TestEnvironment testEnvironment) {
            return new WhiteboxSubscriberProbe(testEnvironment, this.subscriber);
        }

        public T signalNext() throws InterruptedException {
            Object t = this.nextT();
            this.sendNext(t);
            return t;
        }

        public T nextT() throws InterruptedException {
            this.lastT = this.tees.requestNextElement();
            return this.lastT;
        }

        public void verifyNoAsyncErrors() {
            this.env.verifyNoAsyncErrors();
        }
    }

    abstract class TestStageTestRun {
        TestStageTestRun() {
        }

        public abstract void run(WhiteboxTestStage var1) throws Throwable;
    }
}

