/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.tck;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.reactivestreams.tck.SubscriberWhiteboxVerification;
import org.reactivestreams.tck.TestEnvironment;
import org.reactivestreams.tck.support.Optional;
import org.testng.SkipException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class SubscriberBlackboxVerification<T> {
    private final TestEnvironment env;

    protected SubscriberBlackboxVerification(TestEnvironment testEnvironment) {
        this.env = testEnvironment;
    }

    public abstract Subscriber<T> createSubscriber();

    public abstract Publisher<T> createHelperPublisher(long var1);

    @BeforeMethod
    public void setUp() throws Exception {
        this.env.clearAsyncErrors();
    }

    @Test
    public void spec201_blackbox_mustSignalDemandViaSubscriptionRequest() throws Throwable {
        this.blackboxSubscriberTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage blackboxTestStage) throws InterruptedException {
                long l = blackboxTestStage.expectRequest();
                int n = 0;
                while ((long)n < l) {
                    blackboxTestStage.signalNext();
                    ++n;
                }
            }
        });
    }

    @Test
    public void spec202_blackbox_shouldAsynchronouslyDispatch() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec203_blackbox_mustNotCallMethodsOnSubscriptionOrPublisherInOnComplete() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage blackboxTestStage) throws Throwable {
                Subscription subscription = new Subscription(){

                    public void request(long l) {
                        Throwable throwable = new Throwable();
                        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                            if (!stackTraceElement.getMethodName().equals("onComplete")) continue;
                            SubscriberBlackboxVerification.this.env.flop("Subscription::request MUST NOT be called from onComplete!");
                        }
                    }

                    public void cancel() {
                        Throwable throwable = new Throwable();
                        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                            if (!stackTraceElement.getMethodName().equals("onComplete")) continue;
                            SubscriberBlackboxVerification.this.env.flop("Subscriber::onComplete MUST NOT call Subscription::cancel");
                        }
                    }
                };
                Subscriber subscriber = SubscriberBlackboxVerification.this.createSubscriber();
                subscriber.onSubscribe(subscription);
                subscriber.onComplete();
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec203_blackbox_mustNotCallMethodsOnSubscriptionOrPublisherInOnError() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage blackboxTestStage) throws Throwable {
                Subscription subscription = new Subscription(){

                    public void request(long l) {
                        Throwable throwable = new Throwable();
                        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                            if (!stackTraceElement.getMethodName().equals("onError")) continue;
                            SubscriberBlackboxVerification.this.env.flop(String.format("Subscriber::onError MUST NOT call Subscription::request! (Caller: %s::%s line %d)", stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber()));
                        }
                    }

                    public void cancel() {
                        Throwable throwable = new Throwable();
                        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                            if (!stackTraceElement.getMethodName().equals("onError")) continue;
                            SubscriberBlackboxVerification.this.env.flop(String.format("Subscriber::onError MUST NOT call Subscription::cancel! (Caller: %s::%s line %d)", stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber()));
                        }
                    }
                };
                Subscriber subscriber = SubscriberBlackboxVerification.this.createSubscriber();
                subscriber.onSubscribe(subscription);
                subscriber.onError(new Throwable("Boom!"));
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec204_blackbox_mustConsiderTheSubscriptionAsCancelledInAfterRecievingOnCompleteOrOnError() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec205_blackbox_mustCallSubscriptionCancelIfItAlreadyHasAnSubscriptionAndReceivesAnotherOnSubscribeSignal() throws Exception {
        new BlackboxTestStage(this.env){
            {
                final TestEnvironment.Latch latch = new TestEnvironment.Latch(this.env);
                this.sub().onSubscribe(new Subscription(){

                    public void request(long l) {
                        env.flop(String.format("Subscriber %s illegally called `subscription.request(%s)`!", this.sub(), l));
                    }

                    public void cancel() {
                        latch.close();
                    }

                    public String toString() {
                        return "SecondSubscription(should get cancelled)";
                    }
                });
                latch.expectClose("Expected SecondSubscription given to subscriber to be cancelled, but `Subscription.cancel()` was not called.");
                this.env.verifyNoAsyncErrors();
            }
        };
    }

    @Test
    public void spec206_blackbox_mustCallSubscriptionCancelIfItIsNoLongerValid() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec207_blackbox_mustEnsureAllCallsOnItsSubscriptionTakePlaceFromTheSameThreadOrTakeCareOfSynchronization() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec208_blackbox_mustBePreparedToReceiveOnNextSignalsAfterHavingCalledSubscriptionCancel() throws Throwable {
        this.notVerified();
    }

    @Test
    public void spec209_blackbox_mustBePreparedToReceiveAnOnCompleteSignalWithPrecedingRequestCall() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage blackboxTestStage) throws Throwable {
                Publisher publisher = SubscriberBlackboxVerification.this.createHelperPublisher(0L);
                Subscriber subscriber = SubscriberBlackboxVerification.this.createSubscriber();
                SubscriberWhiteboxVerification.BlackboxSubscriberProxy blackboxSubscriberProxy = blackboxTestStage.createBlackboxSubscriberProxy(SubscriberBlackboxVerification.this.env, subscriber);
                publisher.subscribe(blackboxSubscriberProxy);
                blackboxSubscriberProxy.expectCompletion();
                blackboxSubscriberProxy.expectNone();
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec209_blackbox_mustBePreparedToReceiveAnOnCompleteSignalWithoutPrecedingRequestCall() throws Throwable {
        this.blackboxSubscriberWithoutSetupTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage blackboxTestStage) throws Throwable {
                Publisher publisher = new Publisher<T>(){

                    public void subscribe(Subscriber<? super T> subscriber) {
                        subscriber.onComplete();
                    }
                };
                Subscriber subscriber = SubscriberBlackboxVerification.this.createSubscriber();
                SubscriberWhiteboxVerification.BlackboxSubscriberProxy blackboxSubscriberProxy = blackboxTestStage.createBlackboxSubscriberProxy(SubscriberBlackboxVerification.this.env, subscriber);
                publisher.subscribe(blackboxSubscriberProxy);
                blackboxSubscriberProxy.expectCompletion();
                SubscriberBlackboxVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec210_blackbox_mustBePreparedToReceiveAnOnErrorSignalWithPrecedingRequestCall() throws Throwable {
        this.blackboxSubscriberTest(new BlackboxTestStageTestRun(){

            @Override
            public void run(BlackboxTestStage blackboxTestStage) throws Throwable {
                blackboxTestStage.sub().onError(new Throwable("Boom!"));
                blackboxTestStage.subProxy().expectError(Throwable.class);
            }
        });
    }

    @Test
    public void spec211_blackbox_mustMakeSureThatAllCallsOnItsMethodsHappenBeforeTheProcessingOfTheRespectiveEvents() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec212_blackbox_mustNotCallOnSubscribeMoreThanOnceBasedOnObjectEquality() throws Throwable {
        this.notVerified();
    }

    @Test
    public void spec213_blackbox_failingOnSignalInvocation() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec301_blackbox_mustNotBeCalledOutsideSubscriberContext() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec308_blackbox_requestMustRegisterGivenNumberElementsToBeProduced() throws Throwable {
        this.notVerified();
    }

    @Test
    public void spec310_blackbox_requestMaySynchronouslyCallOnNextOnSubscriber() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec311_blackbox_requestMaySynchronouslyCallOnCompleteOrOnError() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec314_blackbox_cancelMayCauseThePublisherToShutdownIfNoOtherSubscriptionExists() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec315_blackbox_cancelMustNotThrowExceptionAndMustSignalOnError() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec316_blackbox_requestMustNotThrowExceptionAndMustOnErrorTheSubscriber() throws Exception {
        this.notVerified();
    }

    public void blackboxSubscriberTest(BlackboxTestStageTestRun blackboxTestStageTestRun) throws Throwable {
        BlackboxTestStage blackboxTestStage = new BlackboxTestStage(this.env, true);
        blackboxTestStageTestRun.run(blackboxTestStage);
    }

    public void blackboxSubscriberWithoutSetupTest(BlackboxTestStageTestRun blackboxTestStageTestRun) throws Throwable {
        BlackboxTestStage blackboxTestStage = new BlackboxTestStage(this.env, false);
        blackboxTestStageTestRun.run(blackboxTestStage);
    }

    public void notVerified() {
        throw new SkipException("Not verified using this TCK.");
    }

    public class BlackboxTestStage
    extends TestEnvironment.ManualPublisher<T> {
        public Publisher<T> pub;
        public TestEnvironment.ManualSubscriber<T> tees;
        public T lastT;
        private Optional<SubscriberWhiteboxVerification.BlackboxSubscriberProxy<T>> subProxy;

        public BlackboxTestStage(TestEnvironment testEnvironment) throws InterruptedException {
            this(testEnvironment, true);
        }

        public BlackboxTestStage(TestEnvironment testEnvironment, boolean bl) throws InterruptedException {
            super(testEnvironment);
            this.lastT = null;
            this.subProxy = Optional.empty();
            if (bl) {
                this.pub = this.createHelperPublisher(Long.MAX_VALUE);
                this.tees = testEnvironment.newManualSubscriber(this.pub);
                Subscriber subscriber = SubscriberBlackboxVerification.this.createSubscriber();
                this.subProxy = Optional.of(this.createBlackboxSubscriberProxy(testEnvironment, subscriber));
                this.subscribe(this.subProxy.get());
            }
        }

        public Subscriber<? super T> sub() {
            return (Subscriber)this.subscriber.value();
        }

        public SubscriberWhiteboxVerification.BlackboxSubscriberProxy<T> subProxy() {
            return this.subProxy.get();
        }

        public Publisher<T> createHelperPublisher(long l) {
            return SubscriberBlackboxVerification.this.createHelperPublisher(l);
        }

        public SubscriberWhiteboxVerification.BlackboxSubscriberProxy<T> createBlackboxSubscriberProxy(TestEnvironment testEnvironment, Subscriber<T> subscriber) {
            return new SubscriberWhiteboxVerification.BlackboxSubscriberProxy(testEnvironment, subscriber);
        }

        public T signalNext() throws InterruptedException {
            Object t = this.nextT();
            this.sendNext(t);
            return t;
        }

        public T nextT() throws InterruptedException {
            this.lastT = this.tees.requestNextElement();
            return this.lastT;
        }
    }

    abstract class BlackboxTestStageTestRun {
        BlackboxTestStageTestRun() {
        }

        public abstract void run(BlackboxTestStage var1) throws Throwable;
    }
}

