/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.tck;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.reactivestreams.tck.TestEnvironment;
import org.reactivestreams.tck.support.Function;
import org.reactivestreams.tck.support.Optional;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class PublisherVerification<T> {
    private final TestEnvironment env;
    private final long publisherReferenceGCTimeoutMillis;

    public PublisherVerification(TestEnvironment testEnvironment, long l) {
        this.env = testEnvironment;
        this.publisherReferenceGCTimeoutMillis = l;
    }

    public abstract Publisher<T> createPublisher(long var1);

    public abstract Publisher<T> createErrorStatePublisher();

    public long maxElementsFromPublisher() {
        return Long.MAX_VALUE;
    }

    public boolean skipStochasticTests() {
        return false;
    }

    public long boundedDepthOfOnNextAndRequestRecursion() {
        return 1L;
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.env.clearAsyncErrors();
    }

    @Test
    public void createPublisher1MustProduceAStreamOfExactly1Element() throws Throwable {
        this.activePublisherTest(1L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws InterruptedException {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                Assert.assertTrue((boolean)this.requestNextElementOrEndOfStream(publisher, manualSubscriber).isDefined(), (String)String.format("Publisher %s produced no elements", publisher));
                manualSubscriber.requestEndOfStream();
            }

            Optional<T> requestNextElementOrEndOfStream(Publisher<T> publisher, TestEnvironment.ManualSubscriber<T> manualSubscriber) throws InterruptedException {
                return manualSubscriber.requestNextElementOrEndOfStream("Timeout while waiting for next element from Publisher" + publisher);
            }
        });
    }

    @Test
    public void createPublisher3MustProduceAStreamOfExactly3Elements() throws Throwable {
        this.activePublisherTest(3L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws InterruptedException {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                Assert.assertTrue((boolean)this.requestNextElementOrEndOfStream(publisher, manualSubscriber).isDefined(), (String)String.format("Publisher %s produced no elements", publisher));
                Assert.assertTrue((boolean)this.requestNextElementOrEndOfStream(publisher, manualSubscriber).isDefined(), (String)String.format("Publisher %s produced only 1 element", publisher));
                Assert.assertTrue((boolean)this.requestNextElementOrEndOfStream(publisher, manualSubscriber).isDefined(), (String)String.format("Publisher %s produced only 2 elements", publisher));
                manualSubscriber.requestEndOfStream();
            }

            Optional<T> requestNextElementOrEndOfStream(Publisher<T> publisher, TestEnvironment.ManualSubscriber<T> manualSubscriber) throws InterruptedException {
                return manualSubscriber.requestNextElementOrEndOfStream("Timeout while waiting for next element from Publisher" + publisher);
            }
        });
    }

    @Test
    public void validate_maxElementsFromPublisher() throws Exception {
        Assert.assertTrue((this.maxElementsFromPublisher() >= 0L ? 1 : 0) != 0, (String)"maxElementsFromPublisher MUST return a number >= 0");
    }

    @Test
    public void validate_boundedDepthOfOnNextAndRequestRecursion() throws Exception {
        Assert.assertTrue((this.boundedDepthOfOnNextAndRequestRecursion() >= 1L ? 1 : 0) != 0, (String)"boundedDepthOfOnNextAndRequestRecursion must return a number >= 1");
    }

    @Test
    public void spec101_subscriptionRequestMustResultInTheCorrectNumberOfProducedElements() throws Throwable {
        this.activePublisherTest(5L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws InterruptedException {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                manualSubscriber.expectNone("Publisher " + publisher + " produced value before the first `request`: ");
                manualSubscriber.request(1L);
                manualSubscriber.nextElement("Publisher " + publisher + " produced no element after first `request`");
                manualSubscriber.expectNone("Publisher " + publisher + " produced unrequested: ");
                manualSubscriber.request(1L);
                manualSubscriber.request(2L);
                manualSubscriber.nextElements(3L, PublisherVerification.this.env.defaultTimeoutMillis(), "Publisher " + publisher + " produced less than 3 elements after two respective `request` calls");
                manualSubscriber.expectNone("Publisher " + publisher + "produced unrequested ");
            }
        });
    }

    @Test
    public void spec102_maySignalLessThanRequestedAndTerminateSubscription() throws Throwable {
        this.activePublisherTest(3L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                manualSubscriber.request(10L);
                manualSubscriber.nextElements(3L);
                manualSubscriber.expectCompletion();
            }
        });
    }

    @Test
    public void spec103_mustSignalOnMethodsSequentially() throws Throwable {
        this.stochasticTest(100, new Function<Integer, Void>(){

            @Override
            public Void apply(Integer n) throws Throwable {
                PublisherVerification.this.activePublisherTest(10L, new PublisherTestRun<T>(){

                    @Override
                    public void run(Publisher<T> publisher) throws Throwable {
                        final TestEnvironment.Latch latch = new TestEnvironment.Latch(PublisherVerification.this.env);
                        final TestEnvironment.Latch latch2 = new TestEnvironment.Latch(PublisherVerification.this.env);
                        publisher.subscribe(new Subscriber<T>(){
                            private Subscription subs;
                            private long gotElements = 0L;
                            private String state = "init";

                            public void onSubscribe(Subscription subscription) {
                                latch.assertOpen("Expected latch to be open during onSubscribe call, state seems to be: " + this.state);
                                latch.close();
                                this.state = "onSubscribe";
                                this.subs = subscription;
                                this.subs.request(1L);
                                latch.reOpen();
                            }

                            public void onNext(T t) {
                                latch.assertOpen("Expected latch to be open during onNext call, state seems to be: " + this.state);
                                latch.close();
                                this.state = "onNext-" + t;
                                ++this.gotElements;
                                if (this.gotElements <= 10L) {
                                    this.subs.request(1L);
                                }
                                latch.reOpen();
                            }

                            public void onError(Throwable throwable) {
                                latch.assertOpen("Expected latch to be open during onError call, state seems to be: " + this.state);
                                latch.close();
                                this.state = "onError";
                                latch.reOpen();
                            }

                            public void onComplete() {
                                latch.assertOpen("Expected latch to be open during onComplete call, state seems to be: " + this.state);
                                latch.close();
                                this.state = "onComplete";
                                latch.reOpen();
                                latch2.close();
                            }
                        });
                        latch2.expectClose(10L * PublisherVerification.this.env.defaultTimeoutMillis(), "Expected 10 elements to be drained");
                    }
                });
                return null;
            }
        });
    }

    @Test
    public void spec104_mustSignalOnErrorWhenFails() throws Throwable {
        this.errorPublisherTest(new PublisherTestRun<T>(){

            @Override
            public void run(final Publisher<T> publisher) throws InterruptedException {
                final TestEnvironment.Latch latch = new TestEnvironment.Latch(PublisherVerification.this.env);
                publisher.subscribe((Subscriber)new TestEnvironment.TestSubscriber<T>(PublisherVerification.this.env){

                    @Override
                    public void onError(Throwable throwable) {
                        latch.assertOpen(String.format("Error-state Publisher %s called `onError` twice on new Subscriber", publisher));
                        latch.close();
                    }
                });
                latch.expectClose(String.format("Error-state Publisher %s did not call `onError` on new Subscriber", publisher));
                Thread.sleep(PublisherVerification.this.env.defaultTimeoutMillis());
                PublisherVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec105_mustSignalOnCompleteWhenFiniteStreamTerminates() throws Throwable {
        this.activePublisherTest(3L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                manualSubscriber.requestNextElement();
                manualSubscriber.requestNextElement();
                manualSubscriber.requestNextElement();
                manualSubscriber.requestEndOfStream();
                manualSubscriber.expectNone();
            }
        });
    }

    @Test
    public void spec106_mustConsiderSubscriptionCancelledAfterOnErrorOrOnCompleteHasBeenCalled() throws Throwable {
        this.notVerified();
    }

    @Test
    public void spec107_mustNotEmitFurtherSignalsOnceOnCompleteHasBeenSignalled() throws Throwable {
        this.activePublisherTest(1L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                manualSubscriber.request(10L);
                manualSubscriber.nextElement();
                manualSubscriber.expectCompletion();
                manualSubscriber.request(10L);
                manualSubscriber.expectNone();
            }
        });
    }

    @Test
    public void spec107_mustNotEmitFurtherSignalsOnceOnErrorHasBeenSignalled() throws Throwable {
        this.notVerified();
    }

    @Test
    public void spec108_possiblyCanceledSubscriptionShouldNotReceiveOnErrorOrOnCompleteSignals() throws Throwable {
        this.notVerified();
    }

    @Test
    public void spec109_subscribeShouldNotThrowNonFatalThrowable() throws Throwable {
        this.notVerified();
    }

    @Test
    public void spec110_rejectASubscriptionRequestIfTheSameSubscriberSubscribesTwice() throws Throwable {
        this.optionalActivePublisherTest(3L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                publisher.subscribe(manualSubscriber);
                manualSubscriber.expectErrorWithMessage(IllegalStateException.class, "1.10");
            }
        });
    }

    @Test
    public void spec111_maySupportMultiSubscribe() throws Throwable {
        this.optionalActivePublisherTest(1L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                TestEnvironment.ManualSubscriber manualSubscriber2 = PublisherVerification.this.env.newManualSubscriber(publisher);
                PublisherVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec112_mayRejectCallsToSubscribeIfPublisherIsUnableOrUnwillingToServeThemRejectionMustTriggerOnErrorInsteadOfOnSubscribe() throws Throwable {
        this.errorPublisherTest(new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                final TestEnvironment.Latch latch = new TestEnvironment.Latch(PublisherVerification.this.env);
                TestEnvironment.ManualSubscriberWithSubscriptionSupport manualSubscriberWithSubscriptionSupport = new TestEnvironment.ManualSubscriberWithSubscriptionSupport<T>(PublisherVerification.this.env){

                    @Override
                    public void onError(Throwable throwable) {
                        latch.assertOpen("Only one onError call expected");
                        latch.close();
                    }

                    @Override
                    public void onSubscribe(Subscription subscription) {
                        this.env.flop("onSubscribe should not be called if Publisher is unable to subscribe a Subscriber");
                    }
                };
                publisher.subscribe((Subscriber)manualSubscriberWithSubscriptionSupport);
                latch.assertClosed("Should have received onError");
                PublisherVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec113_mustProduceTheSameElementsInTheSameSequenceToAllOfItsSubscribersWhenRequestingOneByOne() throws Throwable {
        this.optionalActivePublisherTest(5L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws InterruptedException {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                TestEnvironment.ManualSubscriber manualSubscriber2 = PublisherVerification.this.env.newManualSubscriber(publisher);
                TestEnvironment.ManualSubscriber manualSubscriber3 = PublisherVerification.this.env.newManualSubscriber(publisher);
                manualSubscriber.request(1L);
                Object t = manualSubscriber.nextElement("Publisher " + publisher + " did not produce the requested 1 element on 1st subscriber");
                manualSubscriber2.request(2L);
                List list = manualSubscriber2.nextElements(2L, "Publisher " + publisher + " did not produce the requested 2 elements on 2nd subscriber");
                manualSubscriber.request(1L);
                Object t2 = manualSubscriber.nextElement("Publisher " + publisher + " did not produce the requested 1 element on 1st subscriber");
                manualSubscriber3.request(3L);
                List list2 = manualSubscriber3.nextElements(3L, "Publisher " + publisher + " did not produce the requested 3 elements on 3rd subscriber");
                manualSubscriber3.request(1L);
                Object t3 = manualSubscriber3.nextElement("Publisher " + publisher + " did not produce the requested 1 element on 3rd subscriber");
                manualSubscriber3.request(1L);
                Object t4 = manualSubscriber3.nextElement("Publisher " + publisher + " did not produce the requested 1 element on 3rd subscriber");
                manualSubscriber3.requestEndOfStream("Publisher " + publisher + " did not complete the stream as expected on 3rd subscriber");
                manualSubscriber2.request(3L);
                List list3 = manualSubscriber2.nextElements(3L, "Publisher " + publisher + " did not produce the requested 3 elements on 2nd subscriber");
                manualSubscriber2.requestEndOfStream("Publisher " + publisher + " did not complete the stream as expected on 2nd subscriber");
                manualSubscriber.request(2L);
                List list4 = manualSubscriber.nextElements(2L, "Publisher " + publisher + " did not produce the requested 2 elements on 1st subscriber");
                manualSubscriber.request(1L);
                Object t5 = manualSubscriber.nextElement("Publisher " + publisher + " did not produce the requested 1 element on 1st subscriber");
                manualSubscriber.requestEndOfStream("Publisher " + publisher + " did not complete the stream as expected on 1st subscriber");
                ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(t, t2));
                arrayList.addAll(list4);
                arrayList.addAll(Collections.singleton(t5));
                ArrayList arrayList2 = new ArrayList(list);
                arrayList2.addAll(list3);
                ArrayList arrayList3 = new ArrayList(list2);
                arrayList3.add(t3);
                arrayList3.add(t4);
                Assert.assertEquals(arrayList, arrayList2, (String)("Publisher " + publisher + " did not produce the same element sequence for subscribers 1 and 2"));
                Assert.assertEquals(arrayList, arrayList3, (String)("Publisher " + publisher + " did not produce the same element sequence for subscribers 1 and 3"));
            }
        });
    }

    @Test
    public void spec113_mustProduceTheSameElementsInTheSameSequenceToAllOfItsSubscribersWhenRequestingManyUpfront() throws Throwable {
        this.optionalActivePublisherTest(3L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                TestEnvironment.ManualSubscriber manualSubscriber2 = PublisherVerification.this.env.newManualSubscriber(publisher);
                TestEnvironment.ManualSubscriber manualSubscriber3 = PublisherVerification.this.env.newManualSubscriber(publisher);
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                ArrayList arrayList3 = new ArrayList();
                manualSubscriber.request(4L);
                manualSubscriber2.request(4L);
                manualSubscriber3.request(4L);
                arrayList.addAll(manualSubscriber.nextElements(3L));
                arrayList2.addAll(manualSubscriber2.nextElements(3L));
                arrayList3.addAll(manualSubscriber3.nextElements(3L));
                manualSubscriber.expectCompletion();
                manualSubscriber2.expectCompletion();
                manualSubscriber3.expectCompletion();
                Assert.assertEquals(arrayList, arrayList2, (String)String.format("Expected elements to be signaled in the same sequence to 1st and 2nd subscribers", new Object[0]));
                Assert.assertEquals(arrayList2, arrayList3, (String)String.format("Expected elements to be signaled in the same sequence to 2nd and 3rd subscribers", new Object[0]));
            }
        });
    }

    @Test
    public void spec302_mustAllowSynchronousRequestCallsFromOnNextAndOnSubscribe() throws Throwable {
        this.activePublisherTest(6L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                TestEnvironment.ManualSubscriber manualSubscriber = new TestEnvironment.ManualSubscriber<T>(PublisherVerification.this.env){

                    @Override
                    public void onSubscribe(Subscription subscription) {
                        this.subscription.completeImmediatly(subscription);
                        subscription.request(1L);
                        subscription.request(1L);
                        subscription.request(1L);
                    }

                    @Override
                    public void onNext(T t) {
                        Subscription subscription = (Subscription)this.subscription.value();
                        subscription.request(1L);
                    }
                };
                PublisherVerification.this.env.subscribe(publisher, manualSubscriber);
                long l = PublisherVerification.this.env.defaultTimeoutMillis();
                PublisherVerification.this.env.verifyNoAsyncErrors(l);
            }
        });
    }

    @Test
    public void spec303_mustNotAllowUnboundedRecursion() throws Throwable {
        long l = this.boundedDepthOfOnNextAndRequestRecursion() + 1L;
        this.activePublisherTest(l, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                final ThreadLocal<Long> threadLocal = new ThreadLocal<Long>(){

                    @Override
                    protected Long initialValue() {
                        return 0L;
                    }
                };
                TestEnvironment.ManualSubscriberWithSubscriptionSupport manualSubscriberWithSubscriptionSupport = new TestEnvironment.ManualSubscriberWithSubscriptionSupport<T>(PublisherVerification.this.env){

                    @Override
                    public void onNext(T t) {
                        threadLocal.set((Long)threadLocal.get() + 1L);
                        super.onNext(t);
                        Long l = (Long)threadLocal.get();
                        if (l > PublisherVerification.this.boundedDepthOfOnNextAndRequestRecursion()) {
                            this.env.flop(String.format("Got %d onNext calls within thread: %s, yet expected recursive bound was %d", l, Thread.currentThread(), PublisherVerification.this.boundedDepthOfOnNextAndRequestRecursion()));
                        }
                        ((Subscription)this.subscription.value()).request(1L);
                        threadLocal.set((Long)threadLocal.get() - 1L);
                    }
                };
                PublisherVerification.this.env.subscribe(publisher, manualSubscriberWithSubscriptionSupport);
                manualSubscriberWithSubscriptionSupport.request(1L);
                manualSubscriberWithSubscriptionSupport.nextElementOrEndOfStream();
                PublisherVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec304_requestShouldNotPerformHeavyComputations() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec305_cancelMustNotSynchronouslyPerformHeavyCompuatation() throws Exception {
        this.notVerified();
    }

    @Test
    public void spec306_afterSubscriptionIsCancelledRequestMustBeNops() throws Throwable {
        this.activePublisherTest(3L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                TestEnvironment.ManualSubscriberWithSubscriptionSupport manualSubscriberWithSubscriptionSupport = new TestEnvironment.ManualSubscriberWithSubscriptionSupport<T>(PublisherVerification.this.env){

                    @Override
                    public void cancel() {
                        if (this.subscription.isCompleted()) {
                            ((Subscription)this.subscription.value()).cancel();
                        } else {
                            this.env.flop("Cannot cancel a subscription before having received it");
                        }
                    }
                };
                PublisherVerification.this.env.subscribe(publisher, manualSubscriberWithSubscriptionSupport);
                manualSubscriberWithSubscriptionSupport.cancel();
                manualSubscriberWithSubscriptionSupport.request(1L);
                manualSubscriberWithSubscriptionSupport.request(1L);
                manualSubscriberWithSubscriptionSupport.request(1L);
                manualSubscriberWithSubscriptionSupport.expectNone();
                PublisherVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec307_afterSubscriptionIsCancelledAdditionalCancelationsMustBeNops() throws Throwable {
        this.activePublisherTest(1L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                Subscription subscription = (Subscription)manualSubscriber.subscription.value();
                subscription.cancel();
                subscription.cancel();
                subscription.cancel();
                manualSubscriber.expectNone();
                PublisherVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec309_requestZeroMustThrowIllegalArgumentException() throws Throwable {
        this.activePublisherTest(10L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                final TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                PublisherVerification.this.env.expectThrowingOfWithMessage(IllegalArgumentException.class, "3.9", new Runnable(){

                    @Override
                    public void run() {
                        manualSubscriber.request(0L);
                    }
                });
            }
        });
    }

    @Test
    public void spec309_requestNegativeNumberMustThrowIllegalArgumentException() throws Throwable {
        this.activePublisherTest(10L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                final TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                PublisherVerification.this.env.expectThrowingOfWithMessage(IllegalArgumentException.class, "3.9", new Runnable(){

                    @Override
                    public void run() {
                        manualSubscriber.request(-1L);
                    }
                });
            }
        });
    }

    @Test
    public void spec312_cancelMustMakeThePublisherToEventuallyStopSignaling() throws Throwable {
        this.activePublisherTest(20L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                boolean bl;
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                int n = 10;
                int n2 = 5;
                manualSubscriber.request(n);
                manualSubscriber.request(n2);
                int n3 = n + n2;
                manualSubscriber.cancel();
                manualSubscriber.nextElement();
                int n4 = 1;
                do {
                    manualSubscriber.expectNone();
                    Throwable throwable = PublisherVerification.this.env.dropAsyncError();
                    if (throwable == null) {
                        bl = false;
                        continue;
                    }
                    ++n4;
                    bl = true;
                } while (bl && n4 < n3);
                Assert.assertTrue((n4 <= n3 ? 1 : 0) != 0, (String)String.format("Publisher signalled [%d] elements, which is more than the signalled demand: %d", n4, n3));
            }
        });
        this.env.verifyNoAsyncErrors();
    }

    @Test
    public void spec313_cancelMustMakeThePublisherEventuallyDropAllReferencesToTheSubscriber() throws Throwable {
        final ReferenceQueue referenceQueue = new ReferenceQueue();
        final Function function = new Function<Publisher<T>, WeakReference<TestEnvironment.ManualSubscriber<T>>>(){

            @Override
            public WeakReference<TestEnvironment.ManualSubscriber<T>> apply(Publisher<T> publisher) throws Exception {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                WeakReference weakReference = new WeakReference(manualSubscriber, referenceQueue);
                manualSubscriber.request(1L);
                manualSubscriber.nextElement();
                manualSubscriber.cancel();
                return weakReference;
            }
        };
        this.activePublisherTest(3L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                WeakReference weakReference = (WeakReference)function.apply(publisher);
                Thread.sleep(PublisherVerification.this.publisherReferenceGCTimeoutMillis);
                System.gc();
                if (!weakReference.equals(referenceQueue.remove(100L))) {
                    PublisherVerification.this.env.flop("Publisher " + publisher + " did not drop reference to test subscriber after subscription cancellation");
                }
            }
        });
    }

    @Test
    public void spec317_mustSupportAPendingElementCountUpToLongMaxValue() throws Throwable {
        this.activePublisherTest(3L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                manualSubscriber.request(Long.MAX_VALUE);
                manualSubscriber.nextElements(3L);
                manualSubscriber.expectCompletion();
                PublisherVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec317_mustSupportACumulativePendingElementCountUpToLongMaxValue() throws Throwable {
        this.activePublisherTest(3L, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newManualSubscriber(publisher);
                manualSubscriber.request(0x3FFFFFFFFFFFFFFFL);
                manualSubscriber.request(0x3FFFFFFFFFFFFFFFL);
                manualSubscriber.request(1L);
                manualSubscriber.nextElements(3L);
                manualSubscriber.expectCompletion();
                PublisherVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    @Test
    public void spec317_mustSignalOnErrorWhenPendingAboveLongMaxValue() throws Throwable {
        this.activePublisherTest(Integer.MAX_VALUE, new PublisherTestRun<T>(){

            @Override
            public void run(Publisher<T> publisher) throws Throwable {
                TestEnvironment.ManualSubscriber manualSubscriber = PublisherVerification.this.env.newBlackholeSubscriber(publisher);
                manualSubscriber.request(0x7FFFFFFFFFFFFFFEL);
                boolean bl = false;
                for (long i = 0L; !bl && i < 10L; ++i) {
                    manualSubscriber.request(0x7FFFFFFFFFFFFFFEL);
                    try {
                        PublisherVerification.this.env.assertAsyncErrorWithMessage(IllegalStateException.class, "3.17");
                        bl = true;
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                PublisherVerification.this.env.verifyNoAsyncErrors();
            }
        });
    }

    public void activePublisherTest(long l, PublisherTestRun<T> publisherTestRun) throws Throwable {
        if (l > this.maxElementsFromPublisher()) {
            throw new SkipException(String.format("Unable to run this test, as required elements nr: %d is higher than supported by given producer: %d", l, this.maxElementsFromPublisher()));
        }
        Publisher<T> publisher = this.createPublisher(l);
        publisherTestRun.run(publisher);
        this.env.verifyNoAsyncErrors();
    }

    public void optionalActivePublisherTest(long l, PublisherTestRun<T> publisherTestRun) throws Throwable {
        if (l > this.maxElementsFromPublisher()) {
            throw new SkipException(String.format("Unable to run this test, as required elements nr: %d is higher than supported by given producer: %d", l, this.maxElementsFromPublisher()));
        }
        Publisher<T> publisher = this.createPublisher(l);
        try {
            this.potentiallyPendingTest(publisher, publisherTestRun);
        }
        catch (Exception exception) {
            this.notVerified("Skipped because tested publisher does NOT implement this OPTIONAL requirement.");
        }
        catch (AssertionError assertionError) {
            this.notVerified("Skipped because tested publisher does NOT implement this OPTIONAL requirement.");
        }
    }

    public void errorPublisherTest(PublisherTestRun<T> publisherTestRun) throws Throwable {
        this.potentiallyPendingTest(this.createErrorStatePublisher(), publisherTestRun);
    }

    public void potentiallyPendingTest(Publisher<T> publisher, PublisherTestRun<T> publisherTestRun) throws Throwable {
        if (publisher == null) {
            throw new SkipException("Skipping, because no Publisher was provided for this type of test");
        }
        publisherTestRun.run(publisher);
    }

    public void stochasticTest(int n, Function<Integer, Void> function) throws Throwable {
        if (this.skipStochasticTests()) {
            this.notVerified("Skipping @Stochastic test because `skipStochasticTests()` returned `true`!");
        }
        for (int i = 0; i < n; ++i) {
            function.apply(i);
        }
    }

    public void notVerified() {
        throw new SkipException("Not verified by this TCK.");
    }

    public void notVerified(String string) {
        throw new SkipException(string);
    }

    public static interface PublisherTestRun<T> {
        public void run(Publisher<T> var1) throws Throwable;
    }
}

