/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.tck.support;

import java.util.NoSuchElementException;

public abstract class Optional<T> {
    private static final Optional<Object> NONE = new Optional<Object>(){

        @Override
        public Object get() {
            throw new NoSuchElementException(".get call on None!");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };

    private Optional() {
    }

    public static <T> Optional<T> empty() {
        return NONE;
    }

    public static <T> Optional<T> of(T t) {
        if (t == null) {
            return NONE;
        }
        return new Some<T>(t);
    }

    public abstract T get();

    public abstract boolean isEmpty();

    public boolean isDefined() {
        return !this.isEmpty();
    }

    public String toString() {
        return "None";
    }

    public static class Some<T>
    extends Optional<T> {
        private final T value;

        Some(T t) {
            this.value = t;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public String toString() {
            return "Some(" + this.value + ")";
        }
    }
}

