/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json.mapping;

import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import org.reactivecouchbase.json.JsObject;
import org.reactivecouchbase.json.JsValue;
import org.reactivecouchbase.json.Json;
import org.reactivecouchbase.json.Syntax;
import org.reactivecouchbase.json.mapping.Writer;

public class ThrowableWriter
implements Writer<Throwable> {
    private final boolean printStacks;

    public ThrowableWriter(boolean printStacks) {
        this.printStacks = printStacks;
    }

    @Override
    public JsValue write(Throwable value) {
        Object[] els = value.getStackTrace();
        Array elements = Array.empty();
        if (els != null && els.length != 0) {
            elements = elements.appendAll((Iterable)Array.of((Object[])els));
        }
        Seq elementsAsStr = elements.map(StackTraceElement::toString);
        JsObject base = Json.obj(Syntax.$("message", value.getMessage()), Syntax.$("type", value.getClass().getName()));
        if (this.printStacks) {
            base = base.add(Syntax.$("stack", Json.arr(elementsAsStr)));
        }
        if (value.getCause() != null) {
            base = base.add(Json.obj(new JsObject[]{Syntax.$("cause", Json.toJson(value.getCause(), new ThrowableWriter(this.printStacks)))}));
        }
        return base;
    }
}

