/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json.mapping;

import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import org.reactivecouchbase.json.JsValue;
import org.reactivecouchbase.json.mapping.DefaultReaders;
import org.reactivecouchbase.json.mapping.JsError;
import org.reactivecouchbase.json.mapping.JsResult;
import org.reactivecouchbase.json.mapping.Reader;

public class JsValidator<T>
implements Reader<T> {
    private final Seq<Reader<T>> validators;
    private final boolean traverse;

    public static <T> JsValidator<T> validateWith(Class<T> clazz) {
        return new JsValidator<T>(Array.of((Object)DefaultReaders.getReader(clazz).getOrElse(() -> {
            throw new IllegalStateException("No reader found for class " + clazz.getName());
        })), true);
    }

    public static <T> JsValidator<T> validateWith(Reader<T> base) {
        return new JsValidator<T>(Array.of(base), true);
    }

    public static <T> JsValidator<T> of(Class<T> clazz) {
        return new JsValidator<T>(Array.empty(), true);
    }

    public JsValidator<T> traversable() {
        return new JsValidator<T>(this.validators, true);
    }

    public JsValidator<T> failFast() {
        return new JsValidator<T>(this.validators, false);
    }

    public JsValidator(Seq<Reader<T>> validators, boolean traverse) {
        this.validators = validators;
        this.traverse = traverse;
    }

    @Override
    public JsValidator<T> and(Reader<T> reader) {
        return new JsValidator<T>(this.validators.append(reader), this.traverse);
    }

    @Override
    public JsResult<T> read(JsValue value) {
        JsResult lastRes = JsResult.error(new RuntimeException("No validators"));
        Array throwables = Array.empty();
        for (Reader reader : this.validators) {
            lastRes = reader.read(value);
            if (!lastRes.isErrors()) continue;
            if (!this.traverse) {
                return lastRes;
            }
            throwables = throwables.appendAll(((JsError)lastRes.asError().get()).errors);
        }
        if (throwables.isEmpty()) {
            return lastRes;
        }
        return new JsError((Seq<Throwable>)throwables);
    }
}

