/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json.mapping;

import io.vavr.collection.Iterator;
import java.util.function.Predicate;
import org.reactivecouchbase.json.exceptions.ValidationError;
import org.reactivecouchbase.json.mapping.JsError;
import org.reactivecouchbase.json.mapping.JsResult;
import org.reactivecouchbase.json.mapping.JsSuccess;
import org.reactivecouchbase.json.mapping.Reader;

public class ReaderConstraints {
    public static final String EMAIL_PATTERN = "[\\w!#$%&'*+/=?^_`{|}~-]+(?:\\.[\\w!#$%&'*+/=?^_`{|}~-]+)*@(?:[\\w](?:[\\w-]*[\\w])?\\.)+[a-zA-Z0-9](?:[\\w-]*[\\w])?";
    public static final String URL_PATTERN = "^(http|https|ftp)\\://[a-zA-Z0-9\\-\\.]+\\.[a-zA-Z]{2,3}(:[a-zA-Z0-9]*)?/?([a-zA-Z0-9\\-\\._\\?\\,\\'/\\\\\\+&amp;%\\$#\\=~\\!])*$";
    public static final String PHONE_PATTERN = "^([\\+][0-9]{1,3}([ \\.\\-]))?([\\(]{1}[0-9]{2,6}[\\)])?([0-9 \\.\\-/]{3,20})((x|ext|extension)[ ]?[0-9]{1,4})?$";

    private ReaderConstraints() {
    }

    public static Reader<String> email() {
        return ReaderConstraints.matches(EMAIL_PATTERN);
    }

    public static Reader<String> url() {
        return ReaderConstraints.matches(URL_PATTERN);
    }

    public static Reader<String> phone() {
        return ReaderConstraints.matches(PHONE_PATTERN);
    }

    public static Reader<String> matches(String pattern) {
        return value -> {
            try {
                String str = value.as(String.class);
                if (str.matches(pattern)) {
                    return new JsSuccess<String>(str);
                }
                return new JsError(new ValidationError("'" + str + "' does not match pattern '" + pattern + "'"));
            }
            catch (Exception e) {
                return new JsError(new ValidationError(e.getMessage()));
            }
        };
    }

    public static Reader<Integer> min(Integer min) {
        return value -> {
            try {
                Integer str = value.as(Integer.class);
                if (str < min) {
                    return new JsError(new ValidationError("'" + str + "' is below limit '" + min + "'"));
                }
                return new JsSuccess<Integer>(str);
            }
            catch (Exception e) {
                return new JsError(new ValidationError(e.getMessage()));
            }
        };
    }

    public static Reader<Integer> max(Integer max) {
        return value -> {
            try {
                Integer str = value.as(Integer.class);
                if (str > max) {
                    return new JsError(new ValidationError("'" + str + "' is over limit '" + max + "'"));
                }
                return new JsSuccess<Integer>(str);
            }
            catch (Exception e) {
                return new JsError(new ValidationError(e.getMessage()));
            }
        };
    }

    public static <A> Reader<A> verify(Predicate<A> p, Reader<A> reads) {
        return value -> {
            try {
                JsResult str = value.read(reads);
                Iterator iterator = str.asError().iterator();
                if (iterator.hasNext()) {
                    JsError err = (JsError)iterator.next();
                    return err;
                }
                iterator = str.asSuccess().iterator();
                if (iterator.hasNext()) {
                    JsSuccess success = (JsSuccess)iterator.next();
                    if (p.test(success.get())) {
                        return new JsSuccess(success.get());
                    }
                    return new JsError(new ValidationError("Doesn't validate the predicate"));
                }
                throw new RuntimeException("Can't happen");
            }
            catch (Exception e) {
                return new JsError(new ValidationError(e.getMessage()));
            }
        };
    }
}

