/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.utils;

import java.util.Comparator;
import java.util.function.Consumer;
import org.rdfhdt.hdt.triples.IndexedNode;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;
import org.rdfhdt.hdt.util.string.ReplazableString;

public class DebugOrderNodeIterator
implements Consumer<IndexedNode> {
    private static boolean assertEnabled;
    private final Comparator<CharSequence> comparator;
    private final String name;
    private final ReplazableString prevBuffer = new ReplazableString(16);
    private final boolean allowDuplicated;

    public static boolean isAssertEnable() {
        return assertEnabled;
    }

    public static Consumer<IndexedNode> of(String name) {
        return DebugOrderNodeIterator.of(name, false);
    }

    public static Consumer<IndexedNode> of(String name, boolean allowDuplicated) {
        return DebugOrderNodeIterator.of(DebugOrderNodeIterator.isAssertEnable(), name, allowDuplicated);
    }

    public static Consumer<IndexedNode> of(boolean debug, String name) {
        return DebugOrderNodeIterator.of(debug, name, false);
    }

    public static Consumer<IndexedNode> of(boolean debug, String name, boolean allowDuplicated) {
        return DebugOrderNodeIterator.of(debug, name, allowDuplicated, CharSequenceComparator.getInstance());
    }

    public static Consumer<IndexedNode> of(boolean debug, String name, boolean allowDuplicated, Comparator<CharSequence> comparator) {
        if (debug) {
            return new DebugOrderNodeIterator(comparator, name, allowDuplicated);
        }
        return t -> {};
    }

    private DebugOrderNodeIterator(Comparator<CharSequence> comparator, String name, boolean allowDuplicated) {
        this.comparator = comparator;
        this.name = name;
        this.allowDuplicated = allowDuplicated;
    }

    @Override
    public void accept(IndexedNode obj) {
        ByteString node = obj.getNode();
        if (this.prevBuffer.length() != 0) {
            int cmp = this.comparator.compare(this.prevBuffer, node);
            if (cmp == 0 && !this.allowDuplicated) {
                throw new AssertionError((Object)("DUPLICATION ERROR: prevBuffer == comparator for string '" + node + "' == '" + this.prevBuffer + "' in section " + this.name));
            }
            if (cmp > 0) {
                throw new AssertionError((Object)("ORDER ERROR: prevBuffer > comparator for string '" + node + "' > '" + this.prevBuffer + "' in section " + this.name));
            }
        }
        this.prevBuffer.replace(node);
    }

    static {
        try {
            assert (false);
        }
        catch (AssertionError e) {
            assertEnabled = true;
        }
    }
}

