/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.string;

import java.io.Serializable;
import java.util.Arrays;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;
import org.rdfhdt.hdt.util.string.DelayedString;

public class CompactString
implements CharSequence,
Serializable,
ByteString {
    private static final long serialVersionUID = 6789858615261959413L;
    final byte[] data;
    private int hash;
    public static final CompactString EMPTY = new CompactString();

    private CompactString() {
        this.data = new byte[0];
    }

    public CompactString(ByteString str) {
        this.data = Arrays.copyOf(str.getBuffer(), str.length());
    }

    public CompactString(CompactString other) {
        this.data = Arrays.copyOf(other.data, other.data.length);
        this.hash = other.hash;
    }

    public CompactString(String other) {
        this.data = other.getBytes(ByteStringUtil.STRING_ENCODING);
    }

    public CompactString(CharSequence other) {
        this.data = other instanceof ByteString ? Arrays.copyOf(((ByteString)other).getBuffer(), other.length()) : other.toString().getBytes(ByteStringUtil.STRING_ENCODING);
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public byte[] getBuffer() {
        return this.getData();
    }

    public CompactString(byte[] data) {
        this.data = data;
    }

    public int indexOf(char ch) {
        for (int i = 0; i < this.data.length; ++i) {
            if ((char)(this.data[i] & 0xFF) != ch) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        for (int i = this.data.length - 1; i >= 0; --i) {
            if ((char)(this.data[i] & 0xFF) != ch) continue;
            return i;
        }
        return -1;
    }

    @Override
    public char charAt(int index) {
        return (char)(this.data[index] & 0xFF);
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public ByteString subSequence(int start, int end) {
        if (start < 0 || end > this.length() || end - start < 0) {
            throw new IllegalArgumentException("Illegal range " + start + "-" + end + " for sequence of length " + this.length());
        }
        byte[] newdata = new byte[end - start];
        System.arraycopy(this.data, start, newdata, 0, end - start);
        return new CompactString(newdata);
    }

    @Override
    public String toString() {
        return new String(this.data, 0, this.data.length, ByteStringUtil.STRING_ENCODING);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = -2128831035;
            int i = this.data.length;
            while (i-- != 0) {
                this.hash = this.hash * 16777619 ^ this.data[i];
            }
        }
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof CompactString) {
            CompactString cmp = (CompactString)o;
            if (this.data.length != cmp.data.length) {
                return false;
            }
            int i = this.data.length;
            while (i-- != 0) {
                if (this.data[i] == cmp.data[i]) continue;
                return false;
            }
            return true;
        }
        if (o instanceof CharSequence) {
            CharSequence other = (CharSequence)o;
            return this.length() == other.length() && CharSequenceComparator.getInstance().compare(this, other) == 0;
        }
        throw new NotImplementedException();
    }

    public CharSequence getDelayed() {
        return new DelayedString(this);
    }
}

