/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.string;

import java.util.Comparator;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.DelayedString;

public final class CharSequenceComparator
implements Comparator<CharSequence> {
    private static final Comparator<CharSequence> instance = new CharSequenceComparator();

    public static Comparator<CharSequence> getInstance() {
        return instance;
    }

    @Override
    public int compare(CharSequence s1, CharSequence s2) {
        if (s1 == s2) {
            return 0;
        }
        s1 = DelayedString.unwrap(s1);
        s2 = DelayedString.unwrap(s2);
        if (s1 instanceof ByteString && s2 instanceof ByteString) {
            ByteString cs1 = (ByteString)s1;
            ByteString cs2 = (ByteString)s2;
            return cs1.compareTo(cs2);
        }
        if (s1 instanceof String && s2 instanceof String) {
            String rs1 = (String)s1;
            String rs2 = (String)s2;
            return rs1.compareTo(rs2);
        }
        return s1.toString().compareTo(s2.toString());
    }
}

