/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.string;

import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.CompactString;

public interface ByteString
extends CharSequence,
Comparable<ByteString> {
    public static ByteString empty() {
        return CompactString.EMPTY;
    }

    public static ByteString of(CharSequence sec) {
        return ByteStringUtil.asByteString(sec);
    }

    public byte[] getBuffer();

    @Override
    default public int compareTo(ByteString other) {
        int n = Math.min(this.length(), other.length());
        for (int k = 0; k < n; ++k) {
            char c2;
            char c1 = this.charAt(k);
            if (c1 == (c2 = other.charAt(k))) continue;
            return c1 - c2;
        }
        return this.length() - other.length();
    }

    @Override
    public ByteString subSequence(int var1, int var2);

    default public ByteString copyAppend(CharSequence other) {
        return this.copyAppend(ByteString.of(other));
    }

    default public ByteString copyAppend(ByteString other) {
        byte[] buffer = new byte[this.length() + other.length()];
        System.arraycopy(this.getBuffer(), 0, buffer, 0, this.length());
        System.arraycopy(other.getBuffer(), 0, buffer, this.length(), other.length());
        return new CompactString(buffer);
    }

    default public ByteString copy() {
        return new CompactString(this);
    }
}

