/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.listener;

import org.rdfhdt.hdt.listener.MultiThreadListener;
import org.rdfhdt.hdt.listener.ProgressListener;

public abstract class PrefixListener
implements ProgressListener {
    protected final String prefix;

    public static PrefixListener of(String prefix, ProgressListener listener) {
        if (listener == null) {
            return null;
        }
        if (listener instanceof MultiThreadListener) {
            return new MultiThreadPrefixListener(prefix, (MultiThreadListener)listener);
        }
        return new SingleThreadPrefixListener(prefix, listener);
    }

    private PrefixListener(String prefix) {
        this.prefix = prefix;
    }

    public abstract void clearThreads();

    private static class MultiThreadPrefixListener
    extends PrefixListener
    implements MultiThreadListener {
        private final MultiThreadListener listener;

        private MultiThreadPrefixListener(String prefix, MultiThreadListener listener) {
            super(prefix);
            this.listener = listener;
        }

        public void notifyProgress(String thread, float level, String message) {
            this.listener.notifyProgress(thread, level, this.prefix + message);
        }

        public void unregisterAllThreads() {
            this.listener.unregisterAllThreads();
        }

        @Override
        public void clearThreads() {
            this.unregisterAllThreads();
        }

        public void registerThread(String threadName) {
            this.listener.registerThread(threadName);
        }

        public void unregisterThread(String threadName) {
            this.listener.unregisterThread(threadName);
        }
    }

    private static class SingleThreadPrefixListener
    extends PrefixListener {
        private final ProgressListener listener;

        private SingleThreadPrefixListener(String prefix, ProgressListener listener) {
            super(prefix);
            this.listener = listener;
        }

        @Override
        public void clearThreads() {
        }

        public void notifyProgress(float level, String message) {
            this.listener.notifyProgress(level, this.prefix + message);
        }
    }
}

