/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.listener;

import org.rdfhdt.hdt.listener.ProgressListener;

public class IntermediateListener
implements ProgressListener {
    private final ProgressListener child;
    private float min;
    private float max;
    private String prefix;

    public IntermediateListener(ProgressListener child) {
        this(child, 0.0f, 100.0f);
    }

    public IntermediateListener(ProgressListener child, float min, float max) {
        this(child, min, max, "");
    }

    public IntermediateListener(ProgressListener child, String prefix) {
        this(child, 0.0f, 100.0f, prefix);
    }

    public IntermediateListener(ProgressListener child, float min, float max, String prefix) {
        this.child = child;
        this.min = min;
        this.max = max;
        this.prefix = prefix;
    }

    public void notifyProgress(float level, String message) {
        if (this.child != null) {
            float newlevel = this.min + level * (this.max - this.min) / 100.0f;
            this.child.notifyProgress(newlevel, this.prefix + message);
        }
    }

    public void setRange(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

