/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io.compress;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.rdfhdt.hdt.util.disk.LongArray;

public class WriteLongArrayBuffer
implements LongArray,
Closeable {
    private static final boolean DISABLE_BUFFER = true;
    private final LongArray array;
    private ArrayElementLong[] bufferLong;
    private ArrayElementInt[] bufferInt;
    private int index = 0;
    private boolean lastOrder;

    public WriteLongArrayBuffer(LongArray array, long maxValue, int maxElement) {
        this.array = array;
    }

    @Override
    public void clear() {
        this.index = 0;
    }

    public void free() {
        this.flush();
        this.bufferInt = null;
        this.bufferLong = null;
        System.gc();
    }

    private ArrayElement get(int index) {
        if (this.bufferLong != null) {
            return this.bufferLong[index];
        }
        if (this.bufferInt != null) {
            return this.bufferInt[index];
        }
        throw new IllegalArgumentException("free buffer!");
    }

    private void checkConsistency() {
        if (this.size() == this.maxCapacity()) {
            this.flush();
        }
    }

    public void flush() {
        if (this.size() == 0) {
            return;
        }
        if (this.bufferLong != null) {
            Arrays.sort(this.bufferLong, 0, this.size(), ArrayElement::compareTo);
        } else if (this.bufferInt != null) {
            Arrays.sort(this.bufferInt, 0, this.size(), ArrayElement::compareTo);
        } else {
            return;
        }
        if (this.lastOrder) {
            for (int i = 0; i < this.index; ++i) {
                ArrayElement e = this.get(i);
                this.array.set(e.getIndex(), e.getValue());
            }
        } else {
            for (int i = this.index - 1; i >= 0; --i) {
                ArrayElement e = this.get(i);
                this.array.set(e.getIndex(), e.getValue());
            }
        }
        this.lastOrder = !this.lastOrder;
        this.clear();
    }

    @Override
    public long get(long index) {
        this.flush();
        return this.array.get(index);
    }

    @Override
    public void set(long index, long value) {
        this.array.set(index, value);
    }

    @Override
    public long length() {
        this.flush();
        return this.array.length();
    }

    @Override
    public int sizeOf() {
        return this.array.sizeOf();
    }

    @Override
    public void resize(long newSize) throws IOException {
        this.array.resize(newSize);
    }

    public int size() {
        return this.index;
    }

    public int maxCapacity() {
        if (this.bufferLong != null) {
            return this.bufferLong.length;
        }
        return this.bufferInt.length;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.array instanceof Closeable) {
            ((Closeable)((Object)this.array)).close();
        }
    }

    private static class ArrayElementInt
    implements ArrayElement {
        private final int index;
        private final int value;

        public ArrayElementInt(long index, long value) {
            this.index = (int)index;
            this.value = (int)value;
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        @Override
        public long getValue() {
            return this.value;
        }
    }

    private static class ArrayElementLong
    implements ArrayElement {
        private final long index;
        private final long value;

        public ArrayElementLong(long index, long value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        @Override
        public long getValue() {
            return this.value;
        }
    }

    private static interface ArrayElement
    extends Comparable<ArrayElement> {
        public long getIndex();

        public long getValue();

        @Override
        default public int compareTo(ArrayElement o) {
            return Long.compare(this.getIndex(), o.getIndex());
        }
    }
}

