/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io.compress;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.compress.Pair;

public class PairWriter
implements Closeable {
    private final CRCOutputStream out;
    private final long size;
    private long index;
    private final Pair lastValue = new Pair();

    public PairWriter(OutputStream writer, long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("Negative size!");
        }
        this.out = new CRCOutputStream(writer, new CRC32());
        VByte.encode(this.out, size);
        this.size = size;
    }

    public void append(Pair pair) throws IOException {
        if (this.index >= this.size) {
            throw new IllegalArgumentException("add more elements than size!");
        }
        VByte.encodeSigned(this.out, pair.predicatePosition - this.lastValue.predicatePosition);
        VByte.encodeSigned(this.out, pair.object - this.lastValue.object);
        VByte.encodeSigned(this.out, pair.predicate - this.lastValue.predicate);
        this.lastValue.setAll(pair);
        ++this.index;
    }

    public void writeCRC() throws IOException {
        this.out.writeCRC();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.index != this.size) {
                throw new IllegalArgumentException("less elements than size were added!");
            }
            this.writeCRC();
        }
        finally {
            this.out.close();
        }
    }
}

