/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io.compress;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.io.compress.Pair;

public class PairReader
implements ExceptionIterator<Pair, IOException>,
Closeable {
    private final CRCInputStream stream;
    private final Pair next = new Pair();
    private boolean read = false;
    private boolean end = false;
    private final long size;
    private long index;

    public PairReader(InputStream stream) throws IOException {
        this.stream = new CRCInputStream(stream, new CRC32());
        this.size = VByte.decode(this.stream);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean hasNext() throws IOException {
        long pred;
        long v;
        if (this.read) {
            return true;
        }
        if (this.end) {
            return false;
        }
        if (this.index == this.size) {
            this.end = true;
            if (!this.stream.readCRCAndCheck()) {
                throw new CRCException("CRC Error while reading PreMapped pairs.");
            }
            return false;
        }
        ++this.index;
        long p = VByte.decodeSigned(this.stream);
        return !this.setAllOrEnd(p, v = VByte.decodeSigned(this.stream), pred = VByte.decodeSigned(this.stream));
    }

    private boolean setAllOrEnd(long p, long v, long pred) {
        if (this.end) {
            return true;
        }
        this.next.increaseAll(p, v, pred);
        this.read = true;
        return false;
    }

    @Override
    public Pair next() throws IOException {
        if (!this.hasNext()) {
            return null;
        }
        this.read = false;
        return this.next;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

