/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io.compress;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.hdt.impl.diskimport.CompressTripleMapper;
import org.rdfhdt.hdt.hdt.impl.diskimport.TripleCompressionResult;
import org.rdfhdt.hdt.hdt.impl.diskimport.TripleCompressionResultEmpty;
import org.rdfhdt.hdt.hdt.impl.diskimport.TripleCompressionResultFile;
import org.rdfhdt.hdt.hdt.impl.diskimport.TripleCompressionResultPartial;
import org.rdfhdt.hdt.iterator.utils.AsyncIteratorFetcher;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.iterator.utils.SizeFetcher;
import org.rdfhdt.hdt.listener.MultiThreadListener;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TripleIDComparator;
import org.rdfhdt.hdt.util.ParallelSortableArrayList;
import org.rdfhdt.hdt.util.concurrent.KWayMerger;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.io.compress.CompressTripleMergeIterator;
import org.rdfhdt.hdt.util.io.compress.CompressTripleReader;
import org.rdfhdt.hdt.util.io.compress.CompressTripleWriter;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapCompressTripleMerger
implements KWayMerger.KWayMergerImpl<TripleID, SizeFetcher<TripleID>> {
    private static final Logger log = LoggerFactory.getLogger(MapCompressTripleMerger.class);
    private final CloseSuppressPath baseFileName;
    private final AsyncIteratorFetcher<TripleID> source;
    private final CompressTripleMapper mapper;
    private final MultiThreadListener listener;
    private final TripleComponentOrder order;
    private final int bufferSize;
    private final int k;
    private final AtomicLong triplesCount = new AtomicLong();
    private final long chunkSize;

    public MapCompressTripleMerger(CloseSuppressPath baseFileName, AsyncIteratorFetcher<TripleID> source, CompressTripleMapper mapper, MultiThreadListener listener, TripleComponentOrder order, int bufferSize, long chunkSize, int k) {
        this.baseFileName = baseFileName;
        this.source = source;
        this.mapper = mapper;
        this.listener = listener;
        this.order = order;
        this.bufferSize = bufferSize;
        this.chunkSize = chunkSize;
        this.k = k;
    }

    public TripleCompressionResult mergeToFile(int workers) throws InterruptedException, IOException, KWayMerger.KWayMergerException {
        KWayMerger<TripleID, SizeFetcher<TripleID>> merger = new KWayMerger<TripleID, SizeFetcher<TripleID>>(this.baseFileName, this.source, this, Math.max(1, workers - 1), this.k);
        merger.start();
        Optional<CloseSuppressPath> sections = merger.waitResult();
        if (sections.isEmpty()) {
            return new TripleCompressionResultEmpty(this.order);
        }
        return new TripleCompressionResultFile(this.triplesCount.get(), sections.get(), this.order, this.bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TripleCompressionResult mergeToPartial() throws IOException, KWayMerger.KWayMergerException {
        ArrayList<CloseSuppressPath> files = new ArrayList<CloseSuppressPath>();
        try {
            this.baseFileName.mkdirs();
            this.baseFileName.closeWithDeleteRecurse();
            long fileName = 0L;
            while (!this.source.isEnd()) {
                CloseSuppressPath file = this.baseFileName.resolve("chunk#" + fileName++);
                this.createChunk((SizeFetcher<TripleID>)this.newStopFlux((Supplier)this.source), file);
                files.add(file);
            }
        }
        catch (Throwable e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    IOUtil.closeAll(files);
                }
                finally {
                    this.baseFileName.close();
                }
                throw throwable;
            }
        }
        return new TripleCompressionResultPartial(files, this.triplesCount.get(), this.order, this.bufferSize){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    MapCompressTripleMerger.this.baseFileName.close();
                }
            }
        };
    }

    public TripleCompressionResult merge(int workers, String mode) throws KWayMerger.KWayMergerException, InterruptedException, IOException {
        if (mode == null) {
            mode = "";
        }
        switch (mode) {
            case "": 
            case "compressionComplete": {
                return this.mergeToFile(workers);
            }
            case "compressionPartial": {
                return this.mergeToPartial();
            }
        }
        throw new IllegalArgumentException("Unknown compression mode: " + mode);
    }

    @Override
    public void createChunk(SizeFetcher<TripleID> flux, CloseSuppressPath output) throws KWayMerger.KWayMergerException {
        TripleID next;
        BufferedTriples buffer = new BufferedTriples();
        ParallelSortableArrayList<TripleID> tripleIDS = buffer.triples;
        this.listener.notifyProgress(10.0f, "reading triples part2  " + this.triplesCount);
        while ((next = flux.get()) != null) {
            TripleID mappedTriple = new TripleID(this.mapper.extractSubject(next.getSubject()), this.mapper.extractPredicate(next.getPredicate()), this.mapper.extractObjects(next.getObject()));
            assert (mappedTriple.isValid());
            tripleIDS.add(mappedTriple);
            long count = this.triplesCount.incrementAndGet();
            if (count % 100000L == 0L) {
                this.listener.notifyProgress(10.0f, "reading triples part2 " + this.triplesCount);
            }
            if (tripleIDS.size() != 0x7FFFFFF9) continue;
            break;
        }
        try {
            tripleIDS.parallelSort(TripleIDComparator.getComparator(this.order));
            int count = 0;
            int block = tripleIDS.size() < 10 ? 1 : tripleIDS.size() / 10;
            IntermediateListener il = new IntermediateListener((ProgressListener)this.listener);
            il.setRange(70.0f, 100.0f);
            il.setPrefix("writing triples " + output.getFileName() + " ");
            try (CompressTripleWriter w = new CompressTripleWriter(output.openOutputStream(this.bufferSize, new OpenOption[0]));){
                il.notifyProgress(0.0f, "creating file");
                TripleID prev = new TripleID(-1L, -1L, -1L);
                for (TripleID triple : tripleIDS) {
                    if (++count % block == 0) {
                        il.notifyProgress((float)count / ((float)block / 10.0f), "writing triples " + count + "/" + tripleIDS.size());
                    }
                    if (prev.match(triple)) continue;
                    prev.setAll(triple.getSubject(), triple.getPredicate(), triple.getObject());
                    w.appendTriple(triple);
                }
                this.listener.notifyProgress(100.0f, "writing completed " + this.triplesCount + " " + output.getFileName());
            }
        }
        catch (IOException e) {
            throw new KWayMerger.KWayMergerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeChunks(List<CloseSuppressPath> inputs, CloseSuppressPath output) throws KWayMerger.KWayMergerException {
        try {
            this.listener.notifyProgress(0.0f, "merging triples " + output.getFileName());
            Closeable[] readers = new CompressTripleReader[inputs.size()];
            try {
                for (int i = 0; i < inputs.size(); ++i) {
                    readers[i] = new CompressTripleReader(inputs.get(i).openInputStream(this.bufferSize, new OpenOption[0]));
                }
                try (CompressTripleWriter w = new CompressTripleWriter(output.openOutputStream(this.bufferSize, new OpenOption[0]));){
                    ExceptionIterator it = CompressTripleMergeIterator.buildOfTree((ExceptionIterator[])readers, (TripleComponentOrder)this.order);
                    while (it.hasNext()) {
                        w.appendTriple((TripleID)it.next());
                    }
                }
            }
            finally {
                IOUtil.closeAll(readers);
            }
            this.listener.notifyProgress(100.0f, "triples merged " + output.getFileName());
            IOUtil.closeAll(inputs);
        }
        catch (IOException e) {
            throw new KWayMerger.KWayMergerException(e);
        }
    }

    @Override
    public SizeFetcher<TripleID> newStopFlux(Supplier<TripleID> flux) {
        return SizeFetcher.ofTripleLong(flux, this.chunkSize);
    }

    public static class BufferedTriples {
        ParallelSortableArrayList<TripleID> triples = new ParallelSortableArrayList(TripleID[].class);

        private BufferedTriples() {
        }
    }

    public static class TripleFile
    implements Closeable {
        long triples;
        CloseSuppressPath path;

        private TripleFile(long triples, CloseSuppressPath path) {
            this.triples = triples;
            this.path = path;
        }

        @Override
        public void close() throws IOException {
            this.path.close();
        }
    }
}

