/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.triples.IndexedNode;
import org.rdfhdt.hdt.util.io.compress.CompressNodeMergeIterator;
import org.rdfhdt.hdt.util.io.compress.CompressNodeReader;
import org.rdfhdt.hdt.util.io.compress.CompressNodeWriter;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.ReplazableString;

public class CompressUtil {
    public static final long SHARED_MASK = 1L;
    public static final int INDEX_SHIFT = 1;

    public static void writeCompressedSection(List<IndexedNode> strings, OutputStream output, ProgressListener listener) throws IOException {
        CompressUtil.writeCompressedSection(ExceptionIterator.of(strings.iterator()), strings.size(), output, listener);
    }

    public static void writeCompressedSection(ExceptionIterator<IndexedNode, IOException> it, long size, OutputStream output, ProgressListener listener) throws IOException {
        long block;
        CompressNodeWriter writer = new CompressNodeWriter(output, size);
        long element = 0L;
        long l = block = size < 10L ? 1L : size / 10L;
        while (it.hasNext()) {
            if (listener != null && element % block == 0L) {
                listener.notifyProgress((float)(10L * element / block), "write section " + element + "/" + size);
            }
            writer.appendNode(it.next());
            ++element;
        }
        it.forEachRemaining(writer::appendNode);
        writer.writeCRC();
        if (listener != null) {
            listener.notifyProgress(100.0f, "section completed " + size + " nodes");
        }
    }

    public static void mergeCompressedSection(InputStream stream1, InputStream stream2, OutputStream output, ProgressListener listener) throws IOException {
        CompressNodeReader in1r = new CompressNodeReader(stream1);
        CompressNodeReader in2r = new CompressNodeReader(stream2);
        long size1 = in1r.getSize();
        long size2 = in2r.getSize();
        CompressUtil.writeCompressedSection(new CompressNodeMergeIterator(in1r, in2r), size1 + size2, output, listener);
        in1r.checkComplete();
        in2r.checkComplete();
    }

    public static long computeSharedNode(long id, long sharedCount) {
        if ((id & 1L) != 0L) {
            return CompressUtil.getId(id);
        }
        return CompressUtil.getId(id) + sharedCount;
    }

    public static long asShared(long id) {
        return CompressUtil.getHeaderId(id) | 1L;
    }

    public static long getId(long headerId) {
        return headerId >>> 1;
    }

    public static long getHeaderId(long id) {
        return id << 1;
    }

    public static DuplicatedIterator asNoDupeCharSequenceIterator(ExceptionIterator<IndexedNode, ?> nodes, DuplicatedNodeConsumer duplicatedNodeConsumer) {
        return new DuplicatedIterator(nodes.asIterator(), duplicatedNodeConsumer);
    }

    private CompressUtil() {
    }

    public static class DuplicatedIterator
    implements Iterator<IndexedNode> {
        private final Iterator<IndexedNode> it;
        private final ReplazableString prev = new ReplazableString();
        private IndexedNode next;
        private long id;
        private final DuplicatedNodeConsumer duplicatedNodeConsumer;
        private long lastHeader;

        DuplicatedIterator(Iterator<IndexedNode> it, DuplicatedNodeConsumer duplicatedNodeConsumer) {
            this.it = it;
            this.duplicatedNodeConsumer = Objects.requireNonNullElseGet(duplicatedNodeConsumer, () -> (i, j, k) -> {});
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.it.hasNext()) {
                IndexedNode node = this.it.next();
                ByteString next = node.getNode();
                int cmp = this.prev.compareTo(next);
                assert (cmp <= 0) : "bad order : " + this.prev + " > " + next;
                if (cmp == 0) {
                    assert (this.id != node.getIndex()) : "same index and prevIndex";
                    this.duplicatedNodeConsumer.onDuplicated(this.id, node.getIndex(), this.lastHeader);
                    continue;
                }
                this.next = node;
                this.prev.replace(next);
                this.id = node.getIndex();
                return true;
            }
            return false;
        }

        @Override
        public IndexedNode next() {
            if (!this.hasNext()) {
                return null;
            }
            IndexedNode old = this.next;
            this.next = null;
            return old;
        }

        public void setLastHeader(long lastHeader) {
            this.lastHeader = lastHeader;
        }
    }

    @FunctionalInterface
    public static interface DuplicatedNodeConsumer {
        public void onDuplicated(long var1, long var3, long var5);
    }
}

